/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.CTESubstitution$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.classic.DataStreamReader;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.pipelines.AnalysisWarning;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowAnalysis$;
import org.apache.spark.sql.pipelines.graph.FlowAnalysisContext;
import org.apache.spark.sql.pipelines.graph.FlowAnalysisContext$;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.FlowFunctionResult;
import org.apache.spark.sql.pipelines.graph.GraphErrors$;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager$;
import org.apache.spark.sql.pipelines.graph.IdentifierHelper$;
import org.apache.spark.sql.pipelines.graph.Input;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.ResolvedInput;
import org.apache.spark.sql.pipelines.graph.UnresolvedDatasetException;
import org.apache.spark.sql.pipelines.util.BatchReadOptions;
import org.apache.spark.sql.pipelines.util.InputReadOptions;
import org.apache.spark.sql.pipelines.util.StreamingReadOptions;
import org.apache.spark.sql.pipelines.util.StreamingReadOptions$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;

public final class FlowAnalysis$ {
    public static final FlowAnalysis$ MODULE$ = new FlowAnalysis$();

    public FlowFunction createFlowFunctionFromLogicalPlan(LogicalPlan plan) {
        return new FlowFunction(plan){
            private transient Logger org$apache$spark$internal$Logging$$log_;
            private final LogicalPlan plan$1;

            public String logName() {
                return Logging.logName$((Logging)this);
            }

            public Logger log() {
                return Logging.log$((Logging)this);
            }

            public Logging.LogStringContext LogStringContext(StringContext sc) {
                return Logging.LogStringContext$((Logging)this, (StringContext)sc);
            }

            public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
                Logging.withLogContext$((Logging)this, context, body);
            }

            public void logInfo(Function0<String> msg) {
                Logging.logInfo$((Logging)this, msg);
            }

            public void logInfo(LogEntry entry) {
                Logging.logInfo$((Logging)this, (LogEntry)entry);
            }

            public void logInfo(LogEntry entry, Throwable throwable) {
                Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
            }

            public void logDebug(Function0<String> msg) {
                Logging.logDebug$((Logging)this, msg);
            }

            public void logDebug(LogEntry entry) {
                Logging.logDebug$((Logging)this, (LogEntry)entry);
            }

            public void logDebug(LogEntry entry, Throwable throwable) {
                Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
            }

            public void logTrace(Function0<String> msg) {
                Logging.logTrace$((Logging)this, msg);
            }

            public void logTrace(LogEntry entry) {
                Logging.logTrace$((Logging)this, (LogEntry)entry);
            }

            public void logTrace(LogEntry entry, Throwable throwable) {
                Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
            }

            public void logWarning(Function0<String> msg) {
                Logging.logWarning$((Logging)this, msg);
            }

            public void logWarning(LogEntry entry) {
                Logging.logWarning$((Logging)this, (LogEntry)entry);
            }

            public void logWarning(LogEntry entry, Throwable throwable) {
                Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
            }

            public void logError(Function0<String> msg) {
                Logging.logError$((Logging)this, msg);
            }

            public void logError(LogEntry entry) {
                Logging.logError$((Logging)this, (LogEntry)entry);
            }

            public void logError(LogEntry entry, Throwable throwable) {
                Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
            }

            public void logInfo(Function0<String> msg, Throwable throwable) {
                Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
            }

            public void logDebug(Function0<String> msg, Throwable throwable) {
                Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
            }

            public void logTrace(Function0<String> msg, Throwable throwable) {
                Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
            }

            public void logWarning(Function0<String> msg, Throwable throwable) {
                Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
            }

            public void logError(Function0<String> msg, Throwable throwable) {
                Logging.logError$((Logging)this, msg, (Throwable)throwable);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
                Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
            }

            public void initializeLogIfNecessary(boolean isInterpreter) {
                Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
            }

            public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
                return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
            }

            public boolean initializeLogIfNecessary$default$2() {
                return Logging.initializeLogIfNecessary$default$2$((Logging)this);
            }

            public void initializeForcefully(boolean isInterpreter, boolean silent) {
                Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
            }

            public Logger org$apache$spark$internal$Logging$$log_() {
                return this.org$apache$spark$internal$Logging$$log_;
            }

            public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
                this.org$apache$spark$internal$Logging$$log_ = x$1;
            }

            public FlowFunctionResult call(Set<TableIdentifier> allInputs, Seq<Input> availableInputs, scala.collection.immutable.Map<String, String> confs, QueryContext queryContext) {
                Try try_;
                Set<TableIdentifier> x$1 = allInputs;
                Seq<Input> x$2 = availableInputs;
                QueryContext x$3 = queryContext;
                SparkSession x$4 = SparkSession$.MODULE$.active();
                HashSet<ResolvedInput> x$5 = FlowAnalysisContext$.MODULE$.apply$default$4();
                HashSet<ResolvedInput> x$6 = FlowAnalysisContext$.MODULE$.apply$default$5();
                HashSet<TableIdentifier> x$7 = FlowAnalysisContext$.MODULE$.apply$default$6();
                boolean x$8 = FlowAnalysisContext$.MODULE$.apply$default$7();
                Buffer<AnalysisWarning> x$9 = FlowAnalysisContext$.MODULE$.apply$default$8();
                HashSet<TableIdentifier> x$10 = FlowAnalysisContext$.MODULE$.apply$default$10();
                FlowAnalysisContext ctx = new FlowAnalysisContext(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$4, x$10);
                try {
                    confs.foreach((Function1 & Serializable)x0$1 -> {
                        anon.1.$anonfun$call$1(ctx, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> FlowAnalysis$.MODULE$.org$apache$spark$sql$pipelines$graph$FlowAnalysis$$analyze(ctx, $this.plan$1));
                }
                finally {
                    ctx.restoreOriginalConf();
                }
                Try df = try_;
                return new FlowFunctionResult((Set<TableIdentifier>)ctx.requestedInputs().toSet(), (Set<ResolvedInput>)ctx.batchInputs().toSet(), (Set<ResolvedInput>)ctx.streamingInputs().toSet(), (Set<TableIdentifier>)ctx.externalInputs().toSet(), (Try<Dataset<Row>>)df, confs, (Seq<AnalysisWarning>)ctx.analysisWarnings().toList());
            }

            public static final /* synthetic */ void $anonfun$call$1(FlowAnalysisContext ctx$1, Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ctx$1.setConf(k, v);
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.plan$1 = plan$1;
                Logging.$init$((Logging)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$call$1$adapted(org.apache.spark.sql.pipelines.graph.FlowAnalysisContext scala.Tuple2 ), $anonfun$call$2(org.apache.spark.sql.pipelines.graph.FlowAnalysis$$anon$1 org.apache.spark.sql.pipelines.graph.FlowAnalysisContext )}, serializedLambda);
            }
        };
    }

    public Dataset<Row> org$apache$spark$sql$pipelines$graph$FlowAnalysis$$analyze(FlowAnalysisContext context, LogicalPlan plan) {
        LogicalPlan planWithInlinedCTEs = CTESubstitution$.MODULE$.apply(plan);
        SparkSession spark = context.spark();
        LogicalPlan resolvedPlan = (LogicalPlan)planWithInlinedCTEs.transformWithSubqueries((PartialFunction)new Serializable(context, spark){
            private static final long serialVersionUID = 0L;
            private final FlowAnalysisContext context$1;
            private final SparkSession spark$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                UnresolvedRelation unresolvedRelation = null;
                A1 A1 = x1;
                if (A1 instanceof UnresolvedRelation) {
                    bl = true;
                    unresolvedRelation = (UnresolvedRelation)A1;
                    if (unresolvedRelation.isStreaming()) {
                        return (B1)FlowAnalysis$.MODULE$.org$apache$spark$sql$pipelines$graph$FlowAnalysis$$readStreamInput(this.context$1, IdentifierHelper$.MODULE$.toQuotedString((Seq<String>)unresolvedRelation.multipartIdentifier()), this.spark$1.readStream(), new StreamingReadOptions(StreamingReadOptions$.MODULE$.apply$default$1(), StreamingReadOptions$.MODULE$.apply$default$2())).queryExecution().analyzed();
                    }
                }
                if (bl) {
                    return (B1)FlowAnalysis$.MODULE$.org$apache$spark$sql$pipelines$graph$FlowAnalysis$$readBatchInput(this.context$1, IdentifierHelper$.MODULE$.toQuotedString((Seq<String>)unresolvedRelation.multipartIdentifier()), new BatchReadOptions()).queryExecution().analyzed();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                boolean bl = false;
                UnresolvedRelation unresolvedRelation = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof UnresolvedRelation) {
                    bl = true;
                    unresolvedRelation = (UnresolvedRelation)logicalPlan;
                    if (unresolvedRelation.isStreaming()) {
                        return true;
                    }
                }
                return bl;
            }
            {
                this.context$1 = context$1;
                this.spark$1 = spark$1;
            }
        });
        return Dataset$.MODULE$.ofRows(spark, resolvedPlan);
    }

    public final Dataset<Row> org$apache$spark$sql$pipelines$graph$FlowAnalysis$$readBatchInput(FlowAnalysisContext context, String name, BatchReadOptions batchReadOptions) {
        GraphIdentifierManager.DatasetIdentifier datasetIdentifier = GraphIdentifierManager$.MODULE$.parseAndQualifyInputIdentifier(context, name);
        if (datasetIdentifier instanceof GraphIdentifierManager.InternalDatasetIdentifier) {
            GraphIdentifierManager.InternalDatasetIdentifier internalDatasetIdentifier = (GraphIdentifierManager.InternalDatasetIdentifier)datasetIdentifier;
            return this.readGraphInput(context, internalDatasetIdentifier, batchReadOptions);
        }
        if (datasetIdentifier instanceof GraphIdentifierManager.ExternalDatasetIdentifier) {
            GraphIdentifierManager.ExternalDatasetIdentifier externalDatasetIdentifier = (GraphIdentifierManager.ExternalDatasetIdentifier)datasetIdentifier;
            return this.readExternalBatchInput(context, externalDatasetIdentifier, name);
        }
        throw new MatchError((Object)datasetIdentifier);
    }

    public final Dataset<Row> org$apache$spark$sql$pipelines$graph$FlowAnalysis$$readStreamInput(FlowAnalysisContext context, String name, DataStreamReader streamReader, StreamingReadOptions streamingReadOptions) {
        GraphIdentifierManager.DatasetIdentifier datasetIdentifier = GraphIdentifierManager$.MODULE$.parseAndQualifyInputIdentifier(context, name);
        if (datasetIdentifier instanceof GraphIdentifierManager.InternalDatasetIdentifier) {
            GraphIdentifierManager.InternalDatasetIdentifier internalDatasetIdentifier = (GraphIdentifierManager.InternalDatasetIdentifier)datasetIdentifier;
            return this.readGraphInput(context, internalDatasetIdentifier, streamingReadOptions);
        }
        if (datasetIdentifier instanceof GraphIdentifierManager.ExternalDatasetIdentifier) {
            GraphIdentifierManager.ExternalDatasetIdentifier externalDatasetIdentifier = (GraphIdentifierManager.ExternalDatasetIdentifier)datasetIdentifier;
            return this.readExternalStreamInput(context, externalDatasetIdentifier, streamReader, name);
        }
        throw new MatchError((Object)datasetIdentifier);
    }

    private final Dataset<Row> readGraphInput(FlowAnalysisContext ctx, GraphIdentifierManager.InternalDatasetIdentifier inputIdentifier, InputReadOptions readOptions) {
        TableIdentifier datasetIdentifier = inputIdentifier.identifier();
        ctx.requestedInputs().$plus$eq((Object)datasetIdentifier);
        if (!ctx.allInputs().contains((Object)datasetIdentifier)) {
            throw GraphErrors$.MODULE$.pipelineLocalDatasetNotDefinedError(datasetIdentifier.unquotedString());
        }
        if (!ctx.availableInput().contains((Object)datasetIdentifier)) {
            throw new UnresolvedDatasetException(datasetIdentifier);
        }
        Input i = (Input)ctx.availableInput().apply((Object)datasetIdentifier);
        Dataset<Row> inputDF = i.load(readOptions);
        Input input = i;
        if (input instanceof Flow) {
            Input input2 = input;
            ((Flow)((Object)input2)).sqlConf().foreach((Function1 & Serializable)x0$1 -> {
                FlowAnalysis$.$anonfun$readGraphInput$1(ctx, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        boolean incompatibleViewReadCheck = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(ctx.spark().conf().get("pipelines.incompatibleViewCheck.enabled", "true")));
        AliasIdentifier aliasIdentifier = new AliasIdentifier(datasetIdentifier.table(), (Seq)new .colon.colon((Object)datasetIdentifier.catalog(), (List)new .colon.colon((Object)datasetIdentifier.database(), (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms()));
        InputReadOptions inputReadOptions = readOptions;
        if (inputReadOptions instanceof StreamingReadOptions) {
            StreamingReadOptions streamingReadOptions = (StreamingReadOptions)inputReadOptions;
            if (!inputDF.isStreaming() && incompatibleViewReadCheck) {
                throw new AnalysisException("INCOMPATIBLE_BATCH_VIEW_READ", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetIdentifier"), (Object)datasetIdentifier.toString())})));
            }
            Object object = streamingReadOptions.droppedUserOptions().nonEmpty() ? ctx.analysisWarnings().$plus$eq((Object)new AnalysisWarning.StreamingReaderOptionsDropped(datasetIdentifier.unquotedString(), (Seq<String>)streamingReadOptions.droppedUserOptions().keys().toSeq())) : BoxedUnit.UNIT;
            HashSet cfr_ignored_0 = (HashSet)ctx.streamingInputs().$plus$eq((Object)new ResolvedInput(i, aliasIdentifier));
        } else {
            if (inputDF.isStreaming() && incompatibleViewReadCheck) {
                throw new AnalysisException("INCOMPATIBLE_STREAMING_VIEW_READ", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetIdentifier"), (Object)datasetIdentifier.toString())})));
            }
            HashSet cfr_ignored_1 = (HashSet)ctx.batchInputs().$plus$eq((Object)new ResolvedInput(i, aliasIdentifier));
        }
        return Dataset$.MODULE$.ofRows(ctx.spark(), (LogicalPlan)new SubqueryAlias(aliasIdentifier, inputDF.queryExecution().logical()));
    }

    private final Dataset<Row> readExternalBatchInput(FlowAnalysisContext context, GraphIdentifierManager.ExternalDatasetIdentifier inputIdentifier, String name) {
        SparkSession spark = context.spark();
        context.externalInputs().$plus$eq((Object)inputIdentifier.identifier());
        return spark.read().table(inputIdentifier.identifier().quotedString());
    }

    private final Dataset<Row> readExternalStreamInput(FlowAnalysisContext context, GraphIdentifierManager.ExternalDatasetIdentifier inputIdentifier, DataStreamReader streamReader, String name) {
        context.externalInputs().$plus$eq((Object)inputIdentifier.identifier());
        return streamReader.table(inputIdentifier.identifier().quotedString());
    }

    public static final /* synthetic */ void $anonfun$readGraphInput$1(FlowAnalysisContext ctx$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ctx$2.setConf(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private FlowAnalysis$() {
    }
}

