/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.DataflowGraphTransformer$;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.GraphElement;
import org.apache.spark.sql.pipelines.graph.ResolutionCompletedFlow;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NoStackTrace;

@ScalaSignature(bytes="\u0006\u0005\rMe\u0001B/_\u0001-D\u0001b\u0018\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002!I\u0011Q\u0005\u0001A\u0002\u0013%\u0011q\u0005\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002\u0004!I\u0011q\u0007\u0001A\u0002\u0013%\u0011\u0011\b\u0005\n\u0003/\u0002\u0001\u0019!C\u0005\u00033B\u0001\"!\u0018\u0001A\u0003&\u00111\b\u0005\n\u0003?\u0002\u0001\u0019!C\u0005\u0003CB\u0011\"a\u001b\u0001\u0001\u0004%I!!\u001c\t\u0011\u0005E\u0004\u0001)Q\u0005\u0003GB\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u0013\u0005e\u0004\u00011A\u0005\n\u0005m\u0004\u0002CA@\u0001\u0001\u0006K!a\u001e\t\u0013\u0005\u0005\u0005\u00011A\u0005\n\u0005\r\u0005\"CAG\u0001\u0001\u0007I\u0011BAH\u0011!\t\u0019\n\u0001Q!\n\u0005\u0015\u0005\"CAK\u0001\u0001\u0007I\u0011BAL\u0011%\tY\n\u0001a\u0001\n\u0013\ti\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0015BAM\u0011%\t\u0019\u000b\u0001a\u0001\n\u0013\t)\u000bC\u0005\u00020\u0002\u0001\r\u0011\"\u0003\u00022\"A\u0011Q\u0017\u0001!B\u0013\t9\u000bC\u0005\u00028\u0002\u0001\r\u0011\"\u0003\u0002\u0002!I\u0011\u0011\u0018\u0001A\u0002\u0013%\u00111\u0018\u0005\t\u0003\u007f\u0003\u0001\u0015)\u0003\u0002\u0004!I\u0011\u0011\u0019\u0001C\u0002\u0013%\u00111\u0019\u0005\t\u0003\u0017\u0004\u0001\u0015!\u0003\u0002F\"I\u0011Q\u001a\u0001A\u0002\u0013%\u0011q\u001a\u0005\n\u0003/\u0004\u0001\u0019!C\u0005\u00033D\u0001\"!8\u0001A\u0003&\u0011\u0011\u001b\u0005\u000b\u0003?\u0004\u0001R1A\u0005\n\u0005\u0005\b\"CAz\u0001\t\u0007I\u0011BA{\u0011!\ti\u0010\u0001Q\u0001\n\u0005]\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013AqAa\u0003\u0001\t\u0003\u0011i\u0001C\u0004\u0003\u001a\u0001!IAa\u0007\t\u000f\t\r\u0002\u0001\"\u0001\u0003&!I!1\b\u0001\u0012\u0002\u0013\u0005!Q\b\u0005\b\u0005'\u0002A\u0011\u0001B+\u0011\u001d\u00119\u0006\u0001C!\u00053:qAa\u0017_\u0011\u0003\u0011iF\u0002\u0004^=\"\u0005!q\f\u0005\u0007w6\"\tAa\u001a\u0007\r\t%T\u0006\u0011B6\u0011)\u0011ii\fBK\u0002\u0013\u0005!q\u0012\u0005\u000b\u0005#{#\u0011#Q\u0001\n\u0005-\u0003B\u0003BJ_\tU\r\u0011\"\u0001\u0003\u0016\"Q!QT\u0018\u0003\u0012\u0003\u0006IAa&\t\rm|C\u0011\u0001BP\u0011%\u0011IkLA\u0001\n\u0003\u0011Y\u000bC\u0005\u00032>\n\n\u0011\"\u0001\u00034\"I!qW\u0018\u0012\u0002\u0013\u0005!\u0011\u0018\u0005\n\u0005{{\u0013\u0011!C!\u0005\u007fC\u0011Ba20\u0003\u0003%\t!a1\t\u0013\t%w&!A\u0005\u0002\t-\u0007\"\u0003Bk_\u0005\u0005I\u0011\tBl\u0011%\u0011)oLA\u0001\n\u0003\u00119\u000fC\u0005\u0003l>\n\t\u0011\"\u0011\u0003n\"I!\u0011_\u0018\u0002\u0002\u0013\u0005#1\u001f\u0005\n\u0005k|\u0013\u0011!C!\u0005o<\u0011Ba?.\u0003\u0003E\tA!@\u0007\u0013\t%T&!A\t\u0002\t}\bBB>B\t\u0003\u00199\u0002C\u0005\u0004\u001a\u0005\u000b\t\u0011\"\u0012\u0004\u001c!I1QD!\u0002\u0002\u0013\u00055q\u0004\u0005\n\u0007K\t\u0015\u0011!CA\u0007OA\u0011b!\u000fB\u0003\u0003%Iaa\u000f\u0007\r\ruR\u0006QB \u0011)\u0011\u0019j\u0012BK\u0002\u0013\u0005!Q\u0013\u0005\u000b\u0005;;%\u0011#Q\u0001\n\t]\u0005BB>H\t\u0003\u0019\t\u0005C\u0005\u0003*\u001e\u000b\t\u0011\"\u0001\u0004H!I!\u0011W$\u0012\u0002\u0013\u0005!\u0011\u0018\u0005\n\u0005{;\u0015\u0011!C!\u0005\u007fC\u0011Ba2H\u0003\u0003%\t!a1\t\u0013\t%w)!A\u0005\u0002\r-\u0003\"\u0003Bk\u000f\u0006\u0005I\u0011\tBl\u0011%\u0011)oRA\u0001\n\u0003\u0019y\u0005C\u0005\u0003l\u001e\u000b\t\u0011\"\u0011\u0004T!I!\u0011_$\u0002\u0002\u0013\u0005#1\u001f\u0005\n\u0005k<\u0015\u0011!C!\u0007/:\u0011ba\u0017.\u0003\u0003E\ta!\u0018\u0007\u0013\ruR&!A\t\u0002\r}\u0003BB>W\t\u0003\u00199\u0007C\u0005\u0004\u001aY\u000b\t\u0011\"\u0012\u0004\u001c!I1Q\u0004,\u0002\u0002\u0013\u00055\u0011\u000e\u0005\n\u0007K1\u0016\u0011!CA\u0007[B\u0011b!\u000fW\u0003\u0003%Iaa\u000f\t\u000f\rMT\u0006\"\u0001\u0004v\tAB)\u0019;bM2|wo\u0012:ba\"$&/\u00198tM>\u0014X.\u001a:\u000b\u0005}\u0003\u0017!B4sCBD'BA1c\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0002dI\u0006\u00191/\u001d7\u000b\u0005\u00154\u0017!B:qCJ\\'BA4i\u0003\u0019\t\u0007/Y2iK*\t\u0011.A\u0002pe\u001e\u001c\u0001aE\u0002\u0001YR\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\t1\fgn\u001a\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019hN\u0001\u0004PE*,7\r\u001e\t\u0003[VL!A\u001e8\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f!\tA\u00180D\u0001_\u0013\tQhLA\u0007ECR\fg\r\\8x\u000fJ\f\u0007\u000f[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005ut\bC\u0001=\u0001\u0011\u0015y&\u00011\u0001x\u0003\u0019!\u0018M\u00197fgV\u0011\u00111\u0001\t\u0007\u0003\u000b\tI\"a\b\u000f\t\u0005\u001d\u00111\u0003\b\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u00026\u0002\rq\u0012xn\u001c;?\u0013\t\t\t\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0016\u0005]\u0011a\u00029bG.\fw-\u001a\u0006\u0003\u0003#IA!a\u0007\u0002\u001e\t\u00191+Z9\u000b\t\u0005U\u0011q\u0003\t\u0004q\u0006\u0005\u0012bAA\u0012=\n)A+\u00192mK\u0006QA/\u00192mKN|F%Z9\u0015\t\u0005%\u0012\u0011\u0007\t\u0005\u0003W\ti#\u0004\u0002\u0002\u0018%!\u0011qFA\f\u0005\u0011)f.\u001b;\t\u0013\u0005MB!!AA\u0002\u0005\r\u0011a\u0001=%c\u00059A/\u00192mKN\u0004\u0013\u0001\u0003;bE2,W*\u00199\u0016\u0005\u0005m\u0002\u0003CA\u001f\u0003\u000b\nY%a\b\u000f\t\u0005}\u0012\u0011\t\t\u0005\u0003\u0013\t9\"\u0003\u0003\u0002D\u0005]\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0005%#aA'ba*!\u00111IA\f!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)E\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002V\u0005=#a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0019Q\f'\r\\3NCB|F%Z9\u0015\t\u0005%\u00121\f\u0005\n\u0003g9\u0011\u0011!a\u0001\u0003w\t\u0011\u0002^1cY\u0016l\u0015\r\u001d\u0011\u0002\u000b\u0019dwn^:\u0016\u0005\u0005\r\u0004CBA\u0003\u00033\t)\u0007E\u0002y\u0003OJ1!!\u001b_\u0005\u00111En\\<\u0002\u0013\u0019dwn^:`I\u0015\fH\u0003BA\u0015\u0003_B\u0011\"a\r\u000b\u0003\u0003\u0005\r!a\u0019\u0002\r\u0019dwn^:!\u0003\u001d1Gn\\<t)>,\"!a\u001e\u0011\u0011\u0005u\u0012QIA&\u0003G\n1B\u001a7poN$vn\u0018\u0013fcR!\u0011\u0011FA?\u0011%\t\u0019$DA\u0001\u0002\u0004\t9(\u0001\u0005gY><8\u000fV8!\u0003\u00151\u0018.Z<t+\t\t)\t\u0005\u0004\u0002\u0006\u0005e\u0011q\u0011\t\u0004q\u0006%\u0015bAAF=\n!a+[3x\u0003%1\u0018.Z<t?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005E\u0005\"CA\u001a!\u0005\u0005\t\u0019AAC\u0003\u00191\u0018.Z<tA\u00059a/[3x\u001b\u0006\u0004XCAAM!!\ti$!\u0012\u0002L\u0005\u001d\u0015a\u0003<jK^l\u0015\r]0%KF$B!!\u000b\u0002 \"I\u00111G\n\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\tm&,w/T1qA\u0005Ya-Y5mK\u00124En\\<t+\t\t9\u000b\u0005\u0004\u0002\u0006\u0005e\u0011\u0011\u0016\t\u0004q\u0006-\u0016bAAW=\n9\"+Z:pYV$\u0018n\u001c8D_6\u0004H.\u001a;fI\u001acwn^\u0001\u0010M\u0006LG.\u001a3GY><8o\u0018\u0013fcR!\u0011\u0011FAZ\u0011%\t\u0019DFA\u0001\u0002\u0004\t9+\u0001\u0007gC&dW\r\u001a$m_^\u001c\b%\u0001\u0007gC&dW\r\u001a+bE2,7/\u0001\tgC&dW\r\u001a+bE2,7o\u0018\u0013fcR!\u0011\u0011FA_\u0011%\t\u0019$GA\u0001\u0002\u0004\t\u0019!A\u0007gC&dW\r\u001a+bE2,7\u000fI\u0001\fa\u0006\u0014\u0018\r\u001c7fY&\u001cX.\u0006\u0002\u0002FB!\u00111FAd\u0013\u0011\tI-a\u0006\u0003\u0007%sG/\u0001\u0007qCJ\fG\u000e\\3mSNl\u0007%\u0001\u000fgSb,G\rU8pY\u0016CXmY;u_JLe.\u001b;jC2L'0\u001a3\u0016\u0005\u0005E\u0007\u0003BA\u0016\u0003'LA!!6\u0002\u0018\t9!i\\8mK\u0006t\u0017\u0001\t4jq\u0016$\u0007k\\8m\u000bb,7-\u001e;pe&s\u0017\u000e^5bY&TX\rZ0%KF$B!!\u000b\u0002\\\"I\u00111\u0007\u0010\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u001eM&DX\r\u001a)p_2,\u00050Z2vi>\u0014\u0018J\\5uS\u0006d\u0017N_3eA\u0005\tb-\u001b=fIB{w\u000e\\#yK\u000e,Ho\u001c:\u0016\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\u000bG>t7-\u001e:sK:$(bAAwa\u0006!Q\u000f^5m\u0013\u0011\t\t0a:\u0003%QC'/Z1e!>|G.\u0012=fGV$xN]\u0001\rg\u0016dg-\u0012=fGV$xN]\u000b\u0003\u0003o\u0004B!!:\u0002z&!\u00111`At\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!D:fY\u001a,\u00050Z2vi>\u0014\b%A\bd_6\u0004X\u000f^3UC\ndW-T1q)\t\tY$\u0001\bd_6\u0004X\u000f^3WS\u0016<X*\u00199\u0015\u0005\u0005e\u0015AD2p[B,H/\u001a$m_^\u001cHk\u001c\u000b\u0003\u0003o\nq\u0002\u001e:b]N4wN]7UC\ndWm\u001d\u000b\u0004{\n=\u0001b\u0002B\tM\u0001\u0007!1C\u0001\fiJ\fgn\u001d4pe6,'\u000f\u0005\u0005\u0002,\tU\u0011qDA\u0010\u0013\u0011\u00119\"a\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0014A\b3fM\u0006,H\u000e^(o\r\u0006LG.\u001a3EKB,g\u000eZ3oiR\u000b'\r\\3t)\u0011\tIC!\b\t\u000f\t}q\u00051\u0001\u0003\"\u00059b-Y5mK\u0012$\u0016M\u00197f\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\t\t\u0003{\t)%a\u0013\u0002\u0004\u0005\u0011BO]1og\u001a|'/\u001c#po:tu\u000eZ3t)\u0015i(q\u0005B\u001c\u0011\u001d\u0011\t\u0002\u000ba\u0001\u0005S\u0001\"\"a\u000b\u0003,\t=\"Q\u0007B\u001b\u0013\u0011\u0011i#a\u0006\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001=\u00032%\u0019!1\u00070\u0003\u0019\u001d\u0013\u0018\r\u001d5FY\u0016lWM\u001c;\u0011\r\u0005\u0015\u0011\u0011\u0004B\u0018\u0011%\u0011I\u0004\u000bI\u0001\u0002\u0004\t\t.\u0001\neSN\f'\r\\3QCJ\fG\u000e\\3mSNl\u0017\u0001\b;sC:\u001chm\u001c:n\t><hNT8eKN$C-\u001a4bk2$HEM\u000b\u0003\u0005\u007fQC!!5\u0003B-\u0012!1\t\t\u0005\u0005\u000b\u0012y%\u0004\u0002\u0003H)!!\u0011\nB&\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003N\u0005]\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u000bB$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011O\u0016$H)\u0019;bM2|wo\u0012:ba\",\u0012a^\u0001\u0006G2|7/\u001a\u000b\u0003\u0003S\t\u0001\u0004R1uC\u001adwn^$sCBDGK]1og\u001a|'/\\3s!\tAXfE\u0002.\u0005C\u0002B!a\u000b\u0003d%!!QMA\f\u0005\u0019\te.\u001f*fMR\u0011!Q\f\u0002 )J\fgn\u001d4pe6tu\u000eZ3SKR\u0014\u00180\u00192mK\u0016C8-\u001a9uS>t7#C\u0018\u0003n\tM$\u0011\u0011BD!\u0011\t)Aa\u001c\n\t\tE\u0014Q\u0004\u0002\n\u000bb\u001cW\r\u001d;j_:\u0004BA!\u001e\u0003~5\u0011!q\u000f\u0006\u0005\u0005s\u0012Y(A\u0004d_:$(o\u001c7\u000b\t\u00055\u0018qC\u0005\u0005\u0005\u007f\u00129H\u0001\u0007O_N#\u0018mY6Ue\u0006\u001cW\r\u0005\u0003\u0002,\t\r\u0015\u0002\u0002BC\u0003/\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u0006\t%\u0015\u0002\u0002BF\u0003;\u0011AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011\u0003Z1uCN,G/\u00133f]RLg-[3s+\t\tY%\u0001\neCR\f7/\u001a;JI\u0016tG/\u001b4jKJ\u0004\u0013A\u00034bS2,GMT8eKV\u0011!q\u0013\t\u0004q\ne\u0015b\u0001BN=\n!\"+Z:pYV$\u0018n\u001c8GC&dW\r\u001a$m_^\f1BZ1jY\u0016$gj\u001c3fAQ1!\u0011\u0015BS\u0005O\u00032Aa)0\u001b\u0005i\u0003b\u0002BGi\u0001\u0007\u00111\n\u0005\b\u0005'#\u0004\u0019\u0001BL\u0003\u0011\u0019w\u000e]=\u0015\r\t\u0005&Q\u0016BX\u0011%\u0011i)\u000eI\u0001\u0002\u0004\tY\u0005C\u0005\u0003\u0014V\u0002\n\u00111\u0001\u0003\u0018\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B[U\u0011\tYE!\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0018\u0016\u0005\u0005/\u0013\t%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0003\u00042!\u001cBb\u0013\r\u0011)M\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u001aBj!\u0011\tYCa4\n\t\tE\u0017q\u0003\u0002\u0004\u0003:L\b\"CA\u001au\u0005\u0005\t\u0019AAc\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001Bm!\u0019\u0011YN!9\u0003N6\u0011!Q\u001c\u0006\u0005\u0005?\f9\"\u0001\u0006d_2dWm\u0019;j_:LAAa9\u0003^\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\tN!;\t\u0013\u0005MB(!AA\u0002\t5\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!1\u0003p\"I\u00111G\u001f\u0002\u0002\u0003\u0007\u0011QY\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QY\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005E'\u0011 \u0005\n\u0003gy\u0014\u0011!a\u0001\u0005\u001b\fq\u0004\u0016:b]N4wN]7O_\u0012,'+\u001a;ss\u0006\u0014G.Z#yG\u0016\u0004H/[8o!\r\u0011\u0019+Q\n\u0006\u0003\u000e\u00051Q\u0002\t\u000b\u0007\u0007\u0019I!a\u0013\u0003\u0018\n\u0005VBAB\u0003\u0015\u0011\u00199!a\u0006\u0002\u000fI,h\u000e^5nK&!11BB\u0003\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0007\u001f\u0019)\"\u0004\u0002\u0004\u0012)\u001911\u00039\u0002\u0005%|\u0017\u0002\u0002BF\u0007#!\"A!@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!1\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t\u00056\u0011EB\u0012\u0011\u001d\u0011i\t\u0012a\u0001\u0003\u0017BqAa%E\u0001\u0004\u00119*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r%2Q\u0007\t\u0007\u0003W\u0019Yca\f\n\t\r5\u0012q\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0005-2\u0011GA&\u0005/KAaa\r\u0002\u0018\t1A+\u001e9mKJB\u0011ba\u000eF\u0003\u0003\u0005\rA!)\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u0001m\u0005q!&/\u00198tM>\u0014XNT8eK\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u001c\u0012b\u0012B7\u0005g\u0012\tIa\"\u0015\t\r\r3Q\t\t\u0004\u0005G;\u0005b\u0002BJ\u0015\u0002\u0007!q\u0013\u000b\u0005\u0007\u0007\u001aI\u0005C\u0005\u0003\u0014.\u0003\n\u00111\u0001\u0003\u0018R!!QZB'\u0011%\t\u0019dTA\u0001\u0002\u0004\t)\r\u0006\u0003\u0002R\u000eE\u0003\"CA\u001a#\u0006\u0005\t\u0019\u0001Bg)\u0011\u0011\tm!\u0016\t\u0013\u0005M\"+!AA\u0002\u0005\u0015G\u0003BAi\u00073B\u0011\"a\rU\u0003\u0003\u0005\rA!4\u00029Q\u0013\u0018M\\:g_Jlgj\u001c3f\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]B\u0019!1\u0015,\u0014\u000bY\u001b\tg!\u0004\u0011\u0011\r\r11\rBL\u0007\u0007JAa!\u001a\u0004\u0006\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\ruC\u0003BB\"\u0007WBqAa%Z\u0001\u0004\u00119\n\u0006\u0003\u0004p\rE\u0004CBA\u0016\u0007W\u00119\nC\u0005\u00048i\u000b\t\u00111\u0001\u0004D\u0005ar/\u001b;i\t\u0006$\u0018M\u001a7po\u001e\u0013\u0018\r\u001d5Ue\u0006t7OZ8s[\u0016\u0014X\u0003BB<\u0007\u007f\"Ba!\u001f\u0004\u0012R!11PBF!\u0011\u0019iha \r\u0001\u001191\u0011\u0011/C\u0002\r\r%!\u0001+\u0012\t\r\u0015%Q\u001a\t\u0005\u0003W\u00199)\u0003\u0003\u0004\n\u0006]!a\u0002(pi\"Lgn\u001a\u0005\b\u0007\u001bc\u0006\u0019ABH\u0003\u00051\u0007cBA\u0016\u0005+i81\u0010\u0005\u0006?r\u0003\ra\u001e")
public class DataflowGraphTransformer
implements AutoCloseable {
    private ThreadPoolExecutor fixedPoolExecutor;
    private final DataflowGraph graph;
    private scala.collection.immutable.Seq<Table> tables;
    private Map<TableIdentifier, Table> tableMap;
    private scala.collection.immutable.Seq<Flow> flows;
    private Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> flowsTo;
    private scala.collection.immutable.Seq<View> views;
    private Map<TableIdentifier, View> viewMap;
    private scala.collection.immutable.Seq<ResolutionCompletedFlow> failedFlows;
    private scala.collection.immutable.Seq<Table> failedTables;
    private final int parallelism;
    private boolean fixedPoolExecutorInitialized;
    private final ExecutorService selfExecutor;
    private volatile boolean bitmap$0;

    public static <T> T withDataflowGraphTransformer(DataflowGraph graph, Function1<DataflowGraphTransformer, T> f) {
        return DataflowGraphTransformer$.MODULE$.withDataflowGraphTransformer(graph, f);
    }

    private scala.collection.immutable.Seq<Table> tables() {
        return this.tables;
    }

    private void tables_$eq(scala.collection.immutable.Seq<Table> x$1) {
        this.tables = x$1;
    }

    private Map<TableIdentifier, Table> tableMap() {
        return this.tableMap;
    }

    private void tableMap_$eq(Map<TableIdentifier, Table> x$1) {
        this.tableMap = x$1;
    }

    private scala.collection.immutable.Seq<Flow> flows() {
        return this.flows;
    }

    private void flows_$eq(scala.collection.immutable.Seq<Flow> x$1) {
        this.flows = x$1;
    }

    private Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> flowsTo() {
        return this.flowsTo;
    }

    private void flowsTo_$eq(Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> x$1) {
        this.flowsTo = x$1;
    }

    private scala.collection.immutable.Seq<View> views() {
        return this.views;
    }

    private void views_$eq(scala.collection.immutable.Seq<View> x$1) {
        this.views = x$1;
    }

    private Map<TableIdentifier, View> viewMap() {
        return this.viewMap;
    }

    private void viewMap_$eq(Map<TableIdentifier, View> x$1) {
        this.viewMap = x$1;
    }

    private scala.collection.immutable.Seq<ResolutionCompletedFlow> failedFlows() {
        return this.failedFlows;
    }

    private void failedFlows_$eq(scala.collection.immutable.Seq<ResolutionCompletedFlow> x$1) {
        this.failedFlows = x$1;
    }

    private scala.collection.immutable.Seq<Table> failedTables() {
        return this.failedTables;
    }

    private void failedTables_$eq(scala.collection.immutable.Seq<Table> x$1) {
        this.failedTables = x$1;
    }

    private int parallelism() {
        return this.parallelism;
    }

    private boolean fixedPoolExecutorInitialized() {
        return this.fixedPoolExecutorInitialized;
    }

    private void fixedPoolExecutorInitialized_$eq(boolean x$1) {
        this.fixedPoolExecutorInitialized = x$1;
    }

    private ThreadPoolExecutor fixedPoolExecutor$lzycompute() {
        DataflowGraphTransformer dataflowGraphTransformer = this;
        synchronized (dataflowGraphTransformer) {
            if (!this.bitmap$0) {
                this.fixedPoolExecutorInitialized_$eq(true);
                this.fixedPoolExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.parallelism(), "data-flow-graph-transformer-");
                this.bitmap$0 = true;
            }
        }
        return this.fixedPoolExecutor;
    }

    private ThreadPoolExecutor fixedPoolExecutor() {
        if (!this.bitmap$0) {
            return this.fixedPoolExecutor$lzycompute();
        }
        return this.fixedPoolExecutor;
    }

    private ExecutorService selfExecutor() {
        return this.selfExecutor;
    }

    private synchronized Map<TableIdentifier, Table> computeTableMap() {
        return ((IterableOnceOps)this.tables().map((Function1 & Serializable)table -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)table.identifier()), table))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, View> computeViewMap() {
        return ((IterableOnceOps)this.views().map((Function1 & Serializable)view -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)view.identifier()), view))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> computeFlowsTo() {
        return this.flows().groupBy((Function1 & Serializable)x$1 -> x$1.destinationIdentifier());
    }

    public synchronized DataflowGraphTransformer transformTables(Function1<Table, Table> transformer) {
        this.tables_$eq((scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().map(transformer)));
        this.tableMap_$eq(this.computeTableMap());
        return this;
    }

    private void defaultOnFailedDependentTables(Map<TableIdentifier, scala.collection.immutable.Seq<Table>> failedTableDependencies) {
        Predef$.MODULE$.require(failedTableDependencies.isEmpty(), (Function0 & Serializable)() -> "Dependency failure happened and some tables were not resolved");
    }

    public DataflowGraphTransformer transformDownNodes(Function2<GraphElement, scala.collection.immutable.Seq<GraphElement>, scala.collection.immutable.Seq<GraphElement>> transformer, boolean disableParallelism) {
        ExecutorService executor = disableParallelism ? this.selfExecutor() : this.fixedPoolExecutor();
        int batchSize = disableParallelism ? 1 : this.parallelism();
        ConcurrentLinkedQueue resolvedFlows2 = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedTables = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedViews = new ConcurrentLinkedQueue();
        ConcurrentHashMap resolvedFlowsMap = new ConcurrentHashMap();
        ConcurrentHashMap resolvedFlowDestinationsMap = new ConcurrentHashMap();
        ConcurrentLinkedQueue failedFlowsQueue = new ConcurrentLinkedQueue();
        ConcurrentHashMap failedDependentFlows = new ConcurrentHashMap();
        ArrayBuffer futures = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ConcurrentLinkedDeque toBeResolvedFlows = new ConcurrentLinkedDeque();
        toBeResolvedFlows.addAll(CollectionConverters$.MODULE$.SeqHasAsJava(this.flows()).asJava());
        while (futures.nonEmpty() || toBeResolvedFlows.peekFirst() != null) {
            BoxedUnit boxedUnit;
            None$ flowOpt;
            Tuple2 tuple2 = futures.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer done = (ArrayBuffer)tuple2._1();
            ArrayBuffer notDone = (ArrayBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)done, (Object)notDone);
            ArrayBuffer done2 = (ArrayBuffer)tuple22._1();
            ArrayBuffer notDone2 = (ArrayBuffer)tuple22._2();
            try {
                done2.foreach((Function1 & Serializable)x$4 -> {
                    x$4.get();
                    return BoxedUnit.UNIT;
                });
            }
            catch (ExecutionException exn) {
                throw exn.getCause();
            }
            futures = notDone2;
            Object object = flowOpt = futures.size() < batchSize ? Option$.MODULE$.apply(toBeResolvedFlows.pollFirst()) : None$.MODULE$;
            if (flowOpt.isDefined()) {
                Flow flow2 = (Flow)flowOpt.get();
                boxedUnit = futures.append(executor.submit(() -> {
                    DataflowGraphTransformer.$anonfun$transformDownNodes$3(this, transformer, flow2, resolvedFlowsMap, resolvedFlows2, failedDependentFlows, resolvedFlowDestinationsMap, toBeResolvedFlows, resolvedTables, resolvedViews, failedFlowsQueue);
                    return BoxedUnit.UNIT;
                }));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        this.failedTables_$eq((scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().filterNot((Function1 & Serializable)table -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$17(resolvedFlowDestinationsMap, table)))));
        Tuple2 tuple2 = CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedFlows2).asScala().toSeq().partition((Function1 & Serializable)flow -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$18(resolvedFlowDestinationsMap, flow)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq resolvedFlowsWithResolvedDest = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq resolvedFlowsWithFailedDest = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)resolvedFlowsWithResolvedDest, (Object)resolvedFlowsWithFailedDest);
        scala.collection.immutable.Seq resolvedFlowsWithResolvedDest2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq resolvedFlowsWithFailedDest2 = (scala.collection.immutable.Seq)tuple23._2();
        this.failedFlows_$eq((scala.collection.immutable.Seq<ResolutionCompletedFlow>)((scala.collection.immutable.Seq)((IterableOps)resolvedFlowsWithFailedDest2.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(failedFlowsQueue).asScala().toSeq())).$plus$plus((IterableOnce)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(failedDependentFlows.values()).asScala().flatten(Predef$.MODULE$.$conforms())).toSeq())));
        this.flows_$eq((scala.collection.immutable.Seq<Flow>)resolvedFlowsWithResolvedDest2);
        this.flowsTo_$eq(this.computeFlowsTo());
        this.tables_$eq((scala.collection.immutable.Seq<Table>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedTables).asScala().toSeq());
        this.views_$eq((scala.collection.immutable.Seq<View>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedViews).asScala().toSeq());
        this.tableMap_$eq(this.computeTableMap());
        this.viewMap_$eq(this.computeViewMap());
        return this;
    }

    public boolean transformDownNodes$default$2() {
        return false;
    }

    public DataflowGraph getDataflowGraph() {
        return this.graph.copy((scala.collection.immutable.Seq<Flow>)((scala.collection.immutable.Seq)this.flows().$plus$plus(this.failedFlows())), (scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().$plus$plus(this.failedTables())), this.graph.copy$default$3());
    }

    @Override
    public void close() {
        if (this.fixedPoolExecutorInitialized()) {
            this.fixedPoolExecutor().shutdown();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$4(GraphElement x$5) {
        return x$5 instanceof ResolvedFlow;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$8(ConcurrentHashMap failedDependentFlows$1, TableIdentifier datasetIdentifier$1, ConcurrentLinkedDeque toBeResolvedFlows$1, TableIdentifier x$8, boolean resolved) {
        Object object = resolved ? failedDependentFlows$1.computeIfPresent(datasetIdentifier$1, (x$9, toRetryFlows) -> {
            toRetryFlows.foreach((Function1 & Serializable)x$10 -> {
                toBeResolvedFlows$1.addFirst(x$10);
                return BoxedUnit.UNIT;
            });
            return null;
        }) : BoxedUnit.UNIT;
        return resolved;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$12(BooleanRef isCurrentThreadLeader$1, TableIdentifier x$11) {
        isCurrentThreadLeader$1.elem = true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$14(ConcurrentHashMap failedDependentFlows$1, Flow flow$1, ConcurrentLinkedDeque toBeResolvedFlows$1, TableIdentifier x$13, boolean x$14) {
        failedDependentFlows$1.computeIfPresent(flow$1.destinationIdentifier(), (x$15, toRetryFlows) -> {
            toRetryFlows.foreach((Function1 & Serializable)x$16 -> {
                toBeResolvedFlows$1.addFirst(x$16);
                return BoxedUnit.UNIT;
            });
            return null;
        });
        return true;
    }

    public static final /* synthetic */ void $anonfun$transformDownNodes$3(DataflowGraphTransformer $this, Function2 transformer$1, Flow flow$1, ConcurrentHashMap resolvedFlowsMap$1, ConcurrentLinkedQueue resolvedFlows$1, ConcurrentHashMap failedDependentFlows$1, ConcurrentHashMap resolvedFlowDestinationsMap$1, ConcurrentLinkedDeque toBeResolvedFlows$1, ConcurrentLinkedQueue resolvedTables$1, ConcurrentLinkedQueue resolvedViews$1, ConcurrentLinkedQueue failedFlowsQueue$1) {
        block10: {
            try {
                Object object;
                try {
                    scala.collection.immutable.Seq result = (scala.collection.immutable.Seq)transformer$1.apply((Object)flow$1, (Object)package$.MODULE$.Seq().empty());
                    Predef$.MODULE$.require(result.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$4(x$5))), (Function0 & Serializable)() -> "transformer must return a Seq[Flow]");
                    scala.collection.immutable.Seq transformedFlows = (scala.collection.immutable.Seq)result.map((Function1 & Serializable)x$6 -> (ResolvedFlow)x$6);
                    resolvedFlowsMap$1.put(flow$1.identifier(), transformedFlows);
                    object = BoxesRunTime.boxToBoolean((boolean)resolvedFlows$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformedFlows).asJava()));
                }
                catch (TransformNodeRetryableException e) {
                    TableIdentifier datasetIdentifier = e.datasetIdentifier();
                    failedDependentFlows$1.compute(datasetIdentifier, (x$7, flows) -> {
                        ResolutionFailedFlow failedFlow = e.failedNode();
                        if (flows == null) {
                            return new .colon.colon((Object)failedFlow, (List)Nil$.MODULE$);
                        }
                        return (scala.collection.immutable.Seq)flows.$colon$plus((Object)failedFlow);
                    });
                    object = resolvedFlowDestinationsMap$1.computeIfPresent(datasetIdentifier, (x$8, resolved) -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$8(failedDependentFlows$1, datasetIdentifier, toBeResolvedFlows$1, x$8, BoxesRunTime.unboxToBoolean((Object)resolved))));
                }
                catch (Throwable other) {
                    throw other;
                }
                if (!((IterableOnceOps)$this.flowsTo().apply((Object)flow$1.destinationIdentifier())).forall((Function1 & Serializable)flowToDestination -> BoxesRunTime.boxToBoolean((boolean)resolvedFlowsMap$1.containsKey(flowToDestination.identifier())))) break block10;
                BooleanRef isCurrentThreadLeader = BooleanRef.create((boolean)false);
                resolvedFlowDestinationsMap$1.computeIfAbsent(flow$1.destinationIdentifier(), x$11 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$12(isCurrentThreadLeader, x$11)));
                if (isCurrentThreadLeader.elem) {
                    if ($this.tableMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.tableMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        resolvedTables$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends GraphElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof Table) {
                                    Table table = (Table)A1;
                                    return (B1)table;
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(GraphElement x1) {
                                GraphElement graphElement = x1;
                                return graphElement instanceof Table;
                            }
                        })).asJava());
                        v1 = resolvedFlows$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends GraphElement, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                A1 A1 = x2;
                                if (A1 instanceof ResolvedFlow) {
                                    ResolvedFlow resolvedFlow = (ResolvedFlow)A1;
                                    return (B1)resolvedFlow;
                                }
                                return (B1)function1.apply(x2);
                            }

                            public final boolean isDefinedAt(GraphElement x2) {
                                GraphElement graphElement = x2;
                                return graphElement instanceof ResolvedFlow;
                            }
                        })).asJava());
                    } else if ($this.viewMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.viewMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        v1 = resolvedViews$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.map((Function1 & Serializable)x$12 -> (View)x$12)).asJava());
                    } else {
                        throw new IllegalArgumentException("Unsupported destination " + flow$1.destinationIdentifier().unquotedString() + " in flow: " + flow$1.displayName() + " at transformDownNodes");
                    }
                    resolvedFlowDestinationsMap$1.computeIfPresent(flow$1.destinationIdentifier(), (x$13, x$14) -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$14(failedDependentFlows$1, flow$1, toBeResolvedFlows$1, x$13, BoxesRunTime.unboxToBoolean((Object)x$14))));
                }
            }
            catch (TransformNodeFailedException ex) {
                failedFlowsQueue$1.add(ex.failedNode());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$17(ConcurrentHashMap resolvedFlowDestinationsMap$1, Table table) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(table.identifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$18(ConcurrentHashMap resolvedFlowDestinationsMap$1, ResolutionCompletedFlow flow) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(flow.destinationIdentifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public DataflowGraphTransformer(DataflowGraph graph) {
        this.graph = graph;
        this.tables = graph.tables();
        this.tableMap = this.computeTableMap();
        this.flows = graph.flows();
        this.flowsTo = this.computeFlowsTo();
        this.views = graph.views();
        this.viewMap = this.computeViewMap();
        this.failedFlows = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.failedTables = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.parallelism = 10;
        this.fixedPoolExecutorInitialized = false;
        this.selfExecutor = ThreadUtils$.MODULE$.sameThreadExecutorService();
    }

    public static class TransformNodeFailedException
    extends Exception
    implements NoStackTrace,
    Product {
        private final ResolutionFailedFlow failedNode;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public ResolutionFailedFlow failedNode() {
            return this.failedNode;
        }

        public TransformNodeFailedException copy(ResolutionFailedFlow failedNode) {
            return new TransformNodeFailedException(failedNode);
        }

        public ResolutionFailedFlow copy$default$1() {
            return this.failedNode();
        }

        public String productPrefix() {
            return "TransformNodeFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.failedNode();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TransformNodeFailedException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "failedNode";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TransformNodeFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            TransformNodeFailedException transformNodeFailedException = (TransformNodeFailedException)x$1;
            ResolutionFailedFlow resolutionFailedFlow = this.failedNode();
            ResolutionFailedFlow resolutionFailedFlow2 = transformNodeFailedException.failedNode();
            if (resolutionFailedFlow == null) {
                if (resolutionFailedFlow2 != null) {
                    return false;
                }
            } else if (!resolutionFailedFlow.equals(resolutionFailedFlow2)) return false;
            if (!transformNodeFailedException.canEqual(this)) return false;
            return true;
        }

        public TransformNodeFailedException(ResolutionFailedFlow failedNode) {
            this.failedNode = failedNode;
            NoStackTrace.$init$((NoStackTrace)this);
            Product.$init$((Product)this);
        }
    }

    public static class TransformNodeRetryableException
    extends Exception
    implements NoStackTrace,
    Product {
        private final TableIdentifier datasetIdentifier;
        private final ResolutionFailedFlow failedNode;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public TableIdentifier datasetIdentifier() {
            return this.datasetIdentifier;
        }

        public ResolutionFailedFlow failedNode() {
            return this.failedNode;
        }

        public TransformNodeRetryableException copy(TableIdentifier datasetIdentifier, ResolutionFailedFlow failedNode) {
            return new TransformNodeRetryableException(datasetIdentifier, failedNode);
        }

        public TableIdentifier copy$default$1() {
            return this.datasetIdentifier();
        }

        public ResolutionFailedFlow copy$default$2() {
            return this.failedNode();
        }

        public String productPrefix() {
            return "TransformNodeRetryableException";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.datasetIdentifier();
                }
                case 1: {
                    return this.failedNode();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TransformNodeRetryableException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "datasetIdentifier";
                }
                case 1: {
                    return "failedNode";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TransformNodeRetryableException)) return false;
            boolean bl = true;
            if (!bl) return false;
            TransformNodeRetryableException transformNodeRetryableException = (TransformNodeRetryableException)x$1;
            TableIdentifier tableIdentifier = this.datasetIdentifier();
            TableIdentifier tableIdentifier2 = transformNodeRetryableException.datasetIdentifier();
            if (tableIdentifier == null) {
                if (tableIdentifier2 != null) {
                    return false;
                }
            } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
            ResolutionFailedFlow resolutionFailedFlow = this.failedNode();
            ResolutionFailedFlow resolutionFailedFlow2 = transformNodeRetryableException.failedNode();
            if (resolutionFailedFlow == null) {
                if (resolutionFailedFlow2 != null) {
                    return false;
                }
            } else if (!resolutionFailedFlow.equals(resolutionFailedFlow2)) return false;
            if (!transformNodeRetryableException.canEqual(this)) return false;
            return true;
        }

        public TransformNodeRetryableException(TableIdentifier datasetIdentifier, ResolutionFailedFlow failedNode) {
            this.datasetIdentifier = datasetIdentifier;
            this.failedNode = failedNode;
            NoStackTrace.$init$((NoStackTrace)this);
            Product.$init$((Product)this);
        }
    }
}

