/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.mesos.Protos;
import org.apache.mesos.protobuf.ByteString;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.deploy.mesos.config.package;
import org.apache.spark.deploy.mesos.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.mesos.MesosProtoUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MesosSchedulerBackendUtil$
implements Logging {
    public static MesosSchedulerBackendUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MesosSchedulerBackendUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<Protos.Volume> parseVolumesSpec(Seq<String> volumes) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)volumes.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split(":"), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            Option option;
            Option option2;
            Option option3;
            Protos.Volume.Builder vol = Protos.Volume.newBuilder().setMode(Protos.Volume.Mode.RW);
            String[] stringArray = spec;
            Option option4 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option4.isEmpty() && option4.get() != null && ((SeqLike)option4.get()).lengthCompare(1) == 0) {
                String container_path = (String)((SeqLike)option4.get()).apply(0);
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)vol.setContainerPath(container_path)));
            }
            Option option5 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option5.isEmpty() && option5.get() != null && ((SeqLike)option5.get()).lengthCompare(2) == 0) {
                String container_path = (String)((SeqLike)option5.get()).apply(0);
                String string = (String)((SeqLike)option5.get()).apply(1);
                if ("rw".equals(string)) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)vol.setContainerPath(container_path)));
                }
            }
            if (!(option3 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
                String container_path = (String)((SeqLike)option3.get()).apply(0);
                String string = (String)((SeqLike)option3.get()).apply(1);
                if ("ro".equals(string)) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)vol.setContainerPath(container_path).setMode(Protos.Volume.Mode.RO)));
                }
            }
            if (!(option2 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                String host_path = (String)((SeqLike)option2.get()).apply(0);
                String container_path = (String)((SeqLike)option2.get()).apply(1);
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)vol.setContainerPath(container_path).setHostPath(host_path)));
            }
            Option option6 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option6.isEmpty() && option6.get() != null && ((SeqLike)option6.get()).lengthCompare(3) == 0) {
                String host_path = (String)((SeqLike)option6.get()).apply(0);
                String container_path = (String)((SeqLike)option6.get()).apply(1);
                String string = (String)((SeqLike)option6.get()).apply(2);
                if ("rw".equals(string)) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)vol.setContainerPath(container_path).setHostPath(host_path)));
                }
            }
            if (!(option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                String host_path = (String)((SeqLike)option.get()).apply(0);
                String container_path = (String)((SeqLike)option.get()).apply(1);
                String string = (String)((SeqLike)option.get()).apply(2);
                if ("ro".equals(string)) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)vol.setContainerPath(container_path).setHostPath(host_path).setMode(Protos.Volume.Mode.RO)));
                }
            }
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Unable to parse volume specs: ").append(volumes).append(". ").append("Expected form: \"[host-dir:]container-dir[:rw|:ro](, ...)\"").toString());
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.build(), Seq$.MODULE$.canBuildFrom())).toList();
    }

    public List<Protos.ContainerInfo.DockerInfo.PortMapping> parsePortMappingsSpec(Seq<String> portmaps) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)portmaps.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split(":"), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            Iterable iterable;
            Protos.ContainerInfo.DockerInfo.PortMapping.Builder portmap = Protos.ContainerInfo.DockerInfo.PortMapping.newBuilder().setProtocol("tcp");
            String[] stringArray = spec;
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String host_port = (String)((SeqLike)option.get()).apply(0);
                String container_port = (String)((SeqLike)option.get()).apply(1);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)portmap.setHostPort(new StringOps(Predef$.MODULE$.augmentString(host_port)).toInt()).setContainerPort(new StringOps(Predef$.MODULE$.augmentString(container_port)).toInt())));
            } else {
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(3) == 0) {
                    String host_port = (String)((SeqLike)option2.get()).apply(0);
                    String container_port = (String)((SeqLike)option2.get()).apply(1);
                    String protocol = (String)((SeqLike)option2.get()).apply(2);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)portmap.setHostPort(new StringOps(Predef$.MODULE$.augmentString(host_port)).toInt()).setContainerPort(new StringOps(Predef$.MODULE$.augmentString(container_port)).toInt()).setProtocol(protocol)));
                } else {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Unable to parse port mapping specs: ").append(portmaps).append(". ").append("Expected form: \"host_port:container_port[:udp|:tcp](, ...)\"").toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.build(), Seq$.MODULE$.canBuildFrom())).toList();
    }

    private List<Protos.Parameter> parseParamsSpec(Seq<String> params) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)params.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.split("=", 2), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            Iterable iterable;
            Protos.Parameter.Builder param = Protos.Parameter.newBuilder();
            String[] stringArray = spec;
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String key = (String)((SeqLike)option.get()).apply(0);
                String value = (String)((SeqLike)option.get()).apply(1);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)param.setKey(key).setValue(value)));
            } else {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Unable to parse arbitrary parameters: ").append(params).append(". ").append("Expected form: \"key=value(, ...)\"").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.build(), Seq$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * Unable to fully structure code
     */
    public Protos.ContainerInfo.Builder buildContainerInfo(SparkConf conf) {
        if (!conf.contains(package$.MODULE$.EXECUTOR_DOCKER_IMAGE())) ** GOTO lbl-1000
        v0 = conf.get(package$.MODULE$.CONTAINERIZER());
        var3_2 = "docker";
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            v1 = Protos.ContainerInfo.Type.DOCKER;
        } else lbl-1000:
        // 2 sources

        {
            v1 = Protos.ContainerInfo.Type.MESOS;
        }
        containerType = v1;
        containerInfo = Protos.ContainerInfo.newBuilder().setType(containerType);
        ((Option)conf.get(package$.MODULE$.EXECUTOR_DOCKER_IMAGE())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildContainerInfo$1$adapted(org.apache.spark.SparkConf org.apache.mesos.Protos$ContainerInfo$Type org.apache.mesos.Protos$ContainerInfo$Builder java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((SparkConf)conf, (Protos.ContainerInfo.Type)containerType, (Protos.ContainerInfo.Builder)containerInfo));
        ((Option)conf.get(package$.MODULE$.NETWORK_NAME())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildContainerInfo$9(org.apache.spark.SparkConf org.apache.mesos.Protos$ContainerInfo$Builder java.lang.String ), (Ljava/lang/String;)Lorg/apache/mesos/Protos$ContainerInfo$Builder;)((SparkConf)conf, (Protos.ContainerInfo.Builder)containerInfo));
        return containerInfo;
    }

    private Seq<Protos.Secret> getSecrets(SparkConf conf, package.MesosSecretConfig secretConfig) {
        Seq referenceSecrets = (Seq)((TraversableLike)((Option)conf.get(secretConfig.SECRET_NAMES())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)s -> MesosSchedulerBackendUtil$.createReferenceSecret$1(s), Seq$.MODULE$.canBuildFrom());
        Seq valueSecrets = (Seq)((TraversableLike)((Option)conf.get(secretConfig.SECRET_VALUES())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)s -> MesosSchedulerBackendUtil$.createValueSecret$1(s), Seq$.MODULE$.canBuildFrom());
        if (valueSecrets.nonEmpty() && referenceSecrets.nonEmpty()) {
            throw new SparkException("Cannot specify both value-type and reference-type secrets.");
        }
        return referenceSecrets.nonEmpty() ? referenceSecrets : valueSecrets;
    }

    private boolean illegalSecretInput(Seq<String> dest, Seq<Protos.Secret> secrets) {
        return dest.nonEmpty() && dest.length() != secrets.length();
    }

    public List<Protos.Volume> getSecretVolume(SparkConf conf, package.MesosSecretConfig secretConfig) {
        Seq<Protos.Secret> secrets = this.getSecrets(conf, secretConfig);
        Seq secretPaths = (Seq)((Option)conf.get(secretConfig.SECRET_FILENAMES())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        if (this.illegalSecretInput((Seq<String>)secretPaths, secrets)) {
            throw new SparkException(new StringBuilder(110).append("Need to give equal numbers of secrets and file paths for file-based ").append("reference secrets got secrets ").append(secrets).append(", and paths ").append(secretPaths).toString());
        }
        return ((TraversableOnce)((TraversableLike)secrets.zip((GenIterable)secretPaths, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Protos.Secret s = (Protos.Secret)tuple2._1();
            String p = (String)tuple2._2();
            Protos.Volume.Source.Builder source = Protos.Volume.Source.newBuilder().setType(Protos.Volume.Source.Type.SECRET).setSecret(s);
            Protos.Volume volume = Protos.Volume.newBuilder().setContainerPath(p).setSource(source).setMode(Protos.Volume.Mode.RO).build();
            return volume;
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    public List<Protos.Environment.Variable> getSecretEnvVar(SparkConf conf, package.MesosSecretConfig secretConfig) {
        Seq<Protos.Secret> secrets = this.getSecrets(conf, secretConfig);
        Seq secretEnvKeys = (Seq)((Option)conf.get(secretConfig.SECRET_ENVKEYS())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        if (this.illegalSecretInput((Seq<String>)secretEnvKeys, secrets)) {
            throw new SparkException(new StringBuilder(122).append("Need to give equal numbers of secrets and environment keys ").append("for environment-based reference secrets got secrets ").append(secrets).append(", ").append("and keys ").append(secretEnvKeys).toString());
        }
        return ((TraversableOnce)((TraversableLike)secrets.zip((GenIterable)secretEnvKeys, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Protos.Secret s = (Protos.Secret)tuple2._1();
            String k = (String)tuple2._2();
            Protos.Environment.Variable variable = Protos.Environment.Variable.newBuilder().setName(k).setType(Protos.Environment.Variable.Type.SECRET).setSecret(s).build();
            return variable;
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    private Protos.ContainerInfo.DockerInfo dockerInfo(String image, boolean forcePullImage, List<Protos.ContainerInfo.DockerInfo.PortMapping> portMaps, List<Protos.Parameter> params, Option<String> networkName) {
        Protos.ContainerInfo.DockerInfo.Builder dockerBuilder = Protos.ContainerInfo.DockerInfo.newBuilder().setImage(image).setForcePullImage(forcePullImage);
        portMaps.foreach((Function1 & Serializable & scala.Serializable)x$9 -> dockerBuilder.addPortMappings(x$9));
        params.foreach((Function1 & Serializable & scala.Serializable)x$10 -> dockerBuilder.addParameters(x$10));
        networkName.foreach((Function1 & Serializable & scala.Serializable)net -> {
            Protos.Parameter network = Protos.Parameter.newBuilder().setKey("net").setValue(net).build();
            dockerBuilder.setNetwork(Protos.ContainerInfo.DockerInfo.Network.USER);
            return dockerBuilder.addParameters(network);
        });
        return dockerBuilder.build();
    }

    private Protos.ContainerInfo.MesosInfo mesosInfo(String image, boolean forcePullImage) {
        Protos.Image.Builder imageProto = Protos.Image.newBuilder().setType(Protos.Image.Type.DOCKER).setDocker(Protos.Image.Docker.newBuilder().setName(image)).setCached(!forcePullImage);
        return Protos.ContainerInfo.MesosInfo.newBuilder().setImage(imageProto).build();
    }

    public Protos.TaskState taskStateToMesos(Enumeration.Value state) {
        Protos.TaskState taskState;
        Enumeration.Value value = state;
        Enumeration.Value value2 = TaskState$.MODULE$.LAUNCHING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            taskState = Protos.TaskState.TASK_STARTING;
        } else {
            Enumeration.Value value4 = TaskState$.MODULE$.RUNNING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                taskState = Protos.TaskState.TASK_RUNNING;
            } else {
                Enumeration.Value value6 = TaskState$.MODULE$.FINISHED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    taskState = Protos.TaskState.TASK_FINISHED;
                } else {
                    Enumeration.Value value8 = TaskState$.MODULE$.FAILED();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        taskState = Protos.TaskState.TASK_FAILED;
                    } else {
                        Enumeration.Value value10 = TaskState$.MODULE$.KILLED();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            taskState = Protos.TaskState.TASK_KILLED;
                        } else {
                            Enumeration.Value value12 = TaskState$.MODULE$.LOST();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                taskState = Protos.TaskState.TASK_LOST;
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
            }
        }
        return taskState;
    }

    public static final /* synthetic */ void $anonfun$buildContainerInfo$1(SparkConf conf$1, Protos.ContainerInfo.Type containerType$1, Protos.ContainerInfo.Builder containerInfo$1, String image) {
        boolean forcePullImage = ((Option)conf$1.get(package$.MODULE$.EXECUTOR_DOCKER_FORCE_PULL_IMAGE())).contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
        List portMaps = (List)((Option)conf$1.get(package$.MODULE$.EXECUTOR_DOCKER_PORT_MAPS())).map((Function1 & Serializable & scala.Serializable)portmaps -> MODULE$.parsePortMappingsSpec((Seq<String>)portmaps)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        List params2 = (List)((Option)conf$1.get(package$.MODULE$.EXECUTOR_DOCKER_PARAMETERS())).map((Function1 & Serializable & scala.Serializable)params -> MODULE$.parseParamsSpec((Seq<String>)params)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        Protos.ContainerInfo.Type type = containerType$1;
        Protos.ContainerInfo.Type type2 = Protos.ContainerInfo.Type.DOCKER;
        Protos.ContainerInfo.Builder builder = !(type != null ? !type.equals(type2) : type2 != null) ? containerInfo$1.setDocker(MODULE$.dockerInfo(image, forcePullImage, (List<Protos.ContainerInfo.DockerInfo.PortMapping>)portMaps, (List<Protos.Parameter>)params2, (Option<String>)((Option)conf$1.get(package$.MODULE$.NETWORK_NAME())))) : containerInfo$1.setMesos(MODULE$.mesosInfo(image, forcePullImage));
        Option volumes2 = ((Option)conf$1.get(package$.MODULE$.EXECUTOR_DOCKER_VOLUMES())).map((Function1 & Serializable & scala.Serializable)volumes -> MODULE$.parseVolumesSpec((Seq<String>)volumes));
        volumes2.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.foreach((Function1 & Serializable & scala.Serializable)x$8 -> containerInfo$1.addVolumes(x$8));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Protos.ContainerInfo.Builder $anonfun$buildContainerInfo$9(SparkConf conf$1, Protos.ContainerInfo.Builder containerInfo$1, String name) {
        Protos.Labels.Builder networkLabels = MesosProtoUtils$.MODULE$.mesosLabels((String)((Option)conf$1.get(package$.MODULE$.NETWORK_LABELS())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        Protos.NetworkInfo info = Protos.NetworkInfo.newBuilder().setName(name).setLabels(networkLabels).build();
        return containerInfo$1.addNetworkInfos(info);
    }

    private static final Protos.Secret createValueSecret$1(String data) {
        return Protos.Secret.newBuilder().setType(Protos.Secret.Type.VALUE).setValue(Protos.Secret.Value.newBuilder().setData(ByteString.copyFrom((byte[])data.getBytes()))).build();
    }

    private static final Protos.Secret createReferenceSecret$1(String name) {
        return Protos.Secret.newBuilder().setReference(Protos.Secret.Reference.newBuilder().setName(name)).setType(Protos.Secret.Type.REFERENCE).build();
    }

    private MesosSchedulerBackendUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$buildContainerInfo$1$adapted(SparkConf conf$1, Protos.ContainerInfo.Type containerType$1, Protos.ContainerInfo.Builder containerInfo$1, String image) {
        MesosSchedulerBackendUtil$.$anonfun$buildContainerInfo$1(conf$1, containerType$1, containerInfo$1, image);
        return BoxedUnit.UNIT;
    }
}

