/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest.mesos;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.mesos.MesosDriverDescription;
import org.apache.spark.deploy.mesos.MesosDriverDescription$;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.ErrorResponse;
import org.apache.spark.deploy.rest.SubmitRequestServlet;
import org.apache.spark.deploy.rest.SubmitRestMissingFieldException;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.package$;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterScheduler;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!\u0002\t\u0012\u0001Ei\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u00111\u0002!\u0011!Q\u0001\n5BQ!\r\u0001\u0005\u0002IBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004@\u0001\u0001\u0006I!\u000f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019)\u0005\u0001)A\u0005\u0005\"9a\t\u0001b\u0001\n\u00139\u0005BB&\u0001A\u0003%\u0001\nC\u0004M\u0001\t\u0007I\u0011B'\t\ri\u0003\u0001\u0015!\u0003O\u0011\u0015Y\u0006\u0001\"\u0003]\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0011\u00151\b\u0001\"\u0003x\u0011\u001d\t)\u0001\u0001C)\u0003\u000f\u0011\u0011$T3t_N\u001cVOY7jiJ+\u0017/^3tiN+'O\u001e7fi*\u0011!cE\u0001\u0006[\u0016\u001cxn\u001d\u0006\u0003)U\tAA]3ti*\u0011acF\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\"\u0001\u0001\u0010\u0011\u0005}\u0001S\"A\n\n\u0005\u0005\u001a\"\u0001F*vE6LGOU3rk\u0016\u001cHoU3sm2,G/A\u0005tG\",G-\u001e7fe\u000e\u0001\u0001CA\u0013+\u001b\u00051#B\u0001\n(\u0015\tA\u0013&A\u0004dYV\u001cH/\u001a:\u000b\u0005\t:\u0012BA\u0016'\u0005UiUm]8t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\fAaY8oMB\u0011afL\u0007\u0002/%\u0011\u0001g\u0006\u0002\n'B\f'o[\"p]\u001a\fa\u0001P5oSRtDcA\u001a6mA\u0011A\u0007A\u0007\u0002#!)!e\u0001a\u0001I!)Af\u0001a\u0001[\u0005\tB)\u0012$B+2#vlU+Q\u000bJ3\u0016jU#\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012qAQ8pY\u0016\fg.\u0001\nE\u000b\u001a\u000bU\u000b\u0014+`'V\u0003VI\u0015,J'\u0016\u0003\u0013A\u0004#F\r\u0006+F\nV0N\u000b6{%+W\u000b\u0002\u0005B\u0011!hQ\u0005\u0003\tn\u00121!\u00138u\u0003=!UIR!V\u0019R{V*R'P%f\u0003\u0013!\u0004#F\r\u0006+F\nV0D\u001fJ+5+F\u0001I!\tQ\u0014*\u0003\u0002Kw\t1Ai\\;cY\u0016\fa\u0002R#G\u0003VcEkX\"P%\u0016\u001b\u0006%\u0001\toKb$HI]5wKJtU/\u001c2feV\ta\n\u0005\u0002P16\t\u0001K\u0003\u0002R%\u00061\u0011\r^8nS\u000eT!a\u0015+\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002V-\u0006!Q\u000f^5m\u0015\u00059\u0016\u0001\u00026bm\u0006L!!\u0017)\u0003\u0015\u0005#x.\\5d\u0019>tw-A\toKb$HI]5wKJtU/\u001c2fe\u0002\n\u0001c\u0019:fCR,G)\u0019;f\r>\u0014X.\u0019;\u0016\u0003u\u0003\"AX1\u000e\u0003}S!\u0001\u0019,\u0002\tQ,\u0007\u0010^\u0005\u0003E~\u0013\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\u0002\u00179,w\u000f\u0012:jm\u0016\u0014\u0018\n\u001a\u000b\u0003KB\u0004\"AZ7\u000f\u0005\u001d\\\u0007C\u00015<\u001b\u0005I'B\u00016$\u0003\u0019a$o\\8u}%\u0011AnO\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002mw!)\u0011/\u0004a\u0001e\u0006Q1/\u001e2nSR$\u0015\r^3\u0011\u0005M$X\"\u0001+\n\u0005U$&\u0001\u0002#bi\u0016\faCY;jY\u0012$%/\u001b<fe\u0012+7o\u0019:jaRLwN\u001c\u000b\u0003qv\u0004\"!_>\u000e\u0003iT!AE\u000b\n\u0005qT(AF'fg>\u001cHI]5wKJ$Um]2sSB$\u0018n\u001c8\t\u000byt\u0001\u0019A@\u0002\u000fI,\u0017/^3tiB\u0019q$!\u0001\n\u0007\u0005\r1CA\fDe\u0016\fG/Z*vE6L7o]5p]J+\u0017/^3ti\u0006a\u0001.\u00198eY\u0016\u001cVOY7jiRA\u0011\u0011BA\b\u0003'\ti\u0002E\u0002 \u0003\u0017I1!!\u0004\u0014\u0005i\u0019VOY7jiJ+7\u000f\u001e)s_R|7m\u001c7SKN\u0004xN\\:f\u0011\u0019\t\tb\u0004a\u0001K\u0006\u0011\"/Z9vKN$X*Z:tC\u001e,'j]8o\u0011\u001d\t)b\u0004a\u0001\u0003/\taB]3rk\u0016\u001cH/T3tg\u0006<W\rE\u0002 \u00033I1!a\u0007\u0014\u0005e\u0019VOY7jiJ+7\u000f\u001e)s_R|7m\u001c7NKN\u001c\u0018mZ3\t\u000f\u0005}q\u00021\u0001\u0002\"\u0005y!/Z:q_:\u001cXmU3sm2,G\u000f\u0005\u0003\u0002$\u0005ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\t!$H\u000f\u001d\u0006\u0005\u0003W\ti#A\u0004tKJ4H.\u001a;\u000b\u0005\u0005=\u0012!\u00026bm\u0006D\u0018\u0002BA\u001a\u0003K\u00111\u0003\u0013;uaN+'O\u001e7fiJ+7\u000f]8og\u0016\u0004")
public class MesosSubmitRequestServlet
extends SubmitRequestServlet {
    private final MesosClusterScheduler scheduler;
    private final boolean DEFAULT_SUPERVISE;
    private final int DEFAULT_MEMORY;
    private final double DEFAULT_CORES;
    private final AtomicLong nextDriverNumber;

    private boolean DEFAULT_SUPERVISE() {
        return this.DEFAULT_SUPERVISE;
    }

    private int DEFAULT_MEMORY() {
        return this.DEFAULT_MEMORY;
    }

    private double DEFAULT_CORES() {
        return this.DEFAULT_CORES;
    }

    private AtomicLong nextDriverNumber() {
        return this.nextDriverNumber;
    }

    private SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    }

    private String newDriverId(Date submitDate) {
        String arg$macro$1 = this.createDateFormat().format(submitDate);
        long arg$macro$2 = this.nextDriverNumber().incrementAndGet();
        return new StringOps("driver-%s-%04d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToLong((long)arg$macro$2)}));
    }

    private MesosDriverDescription buildDriverDescription(CreateSubmissionRequest request) {
        String appResource = (String)Option$.MODULE$.apply((Object)request.appResource()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Application jar 'appResource' is missing.");
        });
        String mainClass = (String)Option$.MODULE$.apply((Object)request.mainClass()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Main class 'mainClass' is missing.");
        });
        String[] appArgs = (String[])Option$.MODULE$.apply((Object)request.appArgs()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Application arguments 'appArgs' are missing.");
        });
        scala.collection.immutable.Map environmentVariables = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)request.environmentVariables()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SubmitRestMissingFieldException("Environment variables 'environmentVariables' are missing.");
        });
        scala.collection.immutable.Map sparkProperties = request.sparkProperties();
        Option driverExtraJavaOptions = sparkProperties.get((Object)"spark.driver.extraJavaOptions");
        Option driverExtraClassPath = sparkProperties.get((Object)"spark.driver.extraClassPath");
        Option driverExtraLibraryPath = sparkProperties.get((Object)"spark.driver.extraLibraryPath");
        Option superviseDriver = sparkProperties.get((Object)"spark.driver.supervise");
        Option driverMemory = sparkProperties.get((Object)"spark.driver.memory");
        Option driverCores = sparkProperties.get((Object)"spark.driver.cores");
        String name = (String)request.sparkProperties().getOrElse((Object)"spark.app.name", (Function0 & Serializable & scala.Serializable)() -> mainClass);
        SparkConf conf = new SparkConf(false).setAll((Traversable)sparkProperties);
        Seq extraClassPath = (Seq)Option$.MODULE$.option2Iterable(driverExtraClassPath).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(File.pathSeparator))), Seq$.MODULE$.canBuildFrom());
        Seq extraLibraryPath = (Seq)Option$.MODULE$.option2Iterable(driverExtraLibraryPath).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator))), Seq$.MODULE$.canBuildFrom());
        Seq extraJavaOpts = (Seq)driverExtraJavaOptions.map((Function1 & Serializable & scala.Serializable)s -> Utils$.MODULE$.splitCommandString(s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq sparkJavaOpts = Utils$.MODULE$.sparkJavaOpts(conf, Utils$.MODULE$.sparkJavaOpts$default$2());
        Seq javaOpts = (Seq)sparkJavaOpts.$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command(mainClass, (Seq)Predef$.MODULE$.wrapRefArray((Object[])appArgs), (Map)environmentVariables, extraClassPath, extraLibraryPath, javaOpts);
        boolean actualSuperviseDriver = BoxesRunTime.unboxToBoolean((Object)superviseDriver.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MesosSubmitRequestServlet.$anonfun$buildDriverDescription$10(x$3))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.DEFAULT_SUPERVISE()));
        int actualDriverMemory = BoxesRunTime.unboxToInt((Object)driverMemory.map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToInteger((int)Utils$.MODULE$.memoryStringToMb(str))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.DEFAULT_MEMORY()));
        double actualDriverCores = BoxesRunTime.unboxToDouble((Object)driverCores.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)MesosSubmitRequestServlet.$anonfun$buildDriverDescription$14(x$4))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.DEFAULT_CORES()));
        Date submitDate = new Date();
        String submissionId = this.newDriverId(submitDate);
        return new MesosDriverDescription(name, appResource, actualDriverMemory, actualDriverCores, actualSuperviseDriver, command, (scala.collection.immutable.Map<String, String>)request.sparkProperties(), submissionId, submitDate, MesosDriverDescription$.MODULE$.$lessinit$greater$default$10());
    }

    public SubmitRestProtocolResponse handleSubmit(String requestMessageJson, SubmitRestProtocolMessage requestMessage, HttpServletResponse responseServlet) {
        ErrorResponse errorResponse;
        SubmitRestProtocolMessage submitRestProtocolMessage = requestMessage;
        if (submitRestProtocolMessage instanceof CreateSubmissionRequest) {
            CreateSubmissionRequest createSubmissionRequest = (CreateSubmissionRequest)submitRestProtocolMessage;
            MesosDriverDescription driverDescription = this.buildDriverDescription(createSubmissionRequest);
            CreateSubmissionResponse s = this.scheduler.submitDriver(driverDescription);
            s.serverSparkVersion_$eq(package$.MODULE$.SPARK_VERSION());
            String[] unknownFields = this.findUnknownFields(requestMessageJson, requestMessage);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unknownFields)).nonEmpty()) {
                s.unknownFields_$eq(unknownFields);
            }
            errorResponse = s;
        } else {
            responseServlet.setStatus(400);
            errorResponse = this.handleError(new StringBuilder(37).append("Received message of unexpected type ").append(submitRestProtocolMessage.messageType()).append(".").toString());
        }
        return errorResponse;
    }

    public static final /* synthetic */ boolean $anonfun$buildDriverDescription$10(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
    }

    public static final /* synthetic */ double $anonfun$buildDriverDescription$14(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toDouble();
    }

    public MesosSubmitRequestServlet(MesosClusterScheduler scheduler, SparkConf conf) {
        this.scheduler = scheduler;
        this.DEFAULT_SUPERVISE = false;
        this.DEFAULT_MEMORY = Utils$.MODULE$.DEFAULT_DRIVER_MEM_MB();
        this.DEFAULT_CORES = 1.0;
        this.nextDriverNumber = new AtomicLong(0L);
    }
}

