/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!B\u0001\u0003\u0001!q!!I'fg>\u001c\b*\u00193p_B$U\r\\3hCRLwN\u001c+pW\u0016tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0015iWm]8t\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011!C:dQ\u0016$W\u000f\\3s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%a$\u0001\u0003d_:47\u0001\u0001\t\u0003?\u0001j\u0011\u0001C\u0005\u0003C!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nA\u0002[1e_>\u00048i\u001c8gS\u001e\u0004\"!J\u0015\u000e\u0003\u0019R!\u0001H\u0014\u000b\u0005!R\u0011A\u00025bI>|\u0007/\u0003\u0002+M\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u000fIJLg/\u001a:F]\u0012\u0004x.\u001b8u!\tq\u0013'D\u00010\u0015\t\u0001\u0004\"A\u0002sa\u000eL!AM\u0018\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\")A\u0007\u0001C\u0001k\u00051A(\u001b8jiz\"BA\u000e\u001d:uA\u0011q\u0007A\u0007\u0002\u0005!)Ad\ra\u0001=!)1e\ra\u0001I!)Af\ra\u0001[!9A\b\u0001b\u0001\n\u0013i\u0014aF2sK\u0012,g\u000e^5bYJ+g.Z<feRC'/Z1e+\u0005q\u0004CA G\u001b\u0005\u0001%BA!C\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0007\u0012\u000bA!\u001e;jY*\tQ)\u0001\u0003kCZ\f\u0017BA$A\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-\u001a\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002 \u00021\r\u0014X\rZ3oi&\fGNU3oK^,'\u000f\u00165sK\u0006$\u0007\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\u0019Q|7.\u001a8NC:\fw-\u001a:\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\u0011M,7-\u001e:jifT!A\u0015\u0005\u0002\r\u0011,\u0007\u000f\\8z\u0013\t!vJ\u0001\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\t\rY\u0003\u0001\u0015!\u0003N\u00035!xn[3o\u001b\u0006t\u0017mZ3sA!9\u0001\f\u0001b\u0001\n\u0013I\u0016!\u00039sS:\u001c\u0017\u000e]1m+\u0005Q\u0006CA.c\u001d\ta\u0006\r\u0005\u0002^#5\taL\u0003\u0002`;\u00051AH]8pizJ!!Y\t\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003CFAaA\u001a\u0001!\u0002\u0013Q\u0016A\u00039sS:\u001c\u0017\u000e]1mA!Q\u0001\u000e\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B5\u0002\u0007a$\u0013\u0007\u0005\u0003\u0011U2\u0014\u0018BA6\u0012\u0005\u0019!V\u000f\u001d7feA\u0019\u0001#\\8\n\u00059\f\"!B!se\u0006L\bC\u0001\tq\u0013\t\t\u0018C\u0001\u0003CsR,\u0007C\u0001\tt\u0013\t!\u0018C\u0001\u0003M_:<\u0007b\u0002<\u0001\u0001\u0004%Ia^\u0001\u0007i>\\WM\\:\u0016\u00031Dq!\u001f\u0001A\u0002\u0013%!0\u0001\u0006u_.,gn]0%KF$\"a\u001f@\u0011\u0005Aa\u0018BA?\u0012\u0005\u0011)f.\u001b;\t\u000f!D\u0018\u0011!a\u0001Y\"9\u0011\u0011\u0001\u0001!B\u0013a\u0017a\u0002;pW\u0016t7\u000f\t\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0005\u0003\u000f\t\u0011\u0003^5nK>3g*\u001a=u%\u0016tWm^1m+\u0005\u0011\b\"CA\u0006\u0001\u0001\u0007I\u0011BA\u0007\u0003U!\u0018.\\3PM:+\u0007\u0010\u001e*f]\u0016<\u0018\r\\0%KF$2a_A\b\u0011!A\u0017\u0011BA\u0001\u0002\u0004\u0011\bbBA\n\u0001\u0001\u0006KA]\u0001\u0013i&lWm\u00144OKb$(+\u001a8fo\u0006d\u0007\u0005C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a\u0005Q1.Z=uC\n4\u0015\u000e\\3\u0016\u0005\u0005m\u0001\u0003\u0002\t\u0002\u001eiK1!a\b\u0012\u0005\u0019y\u0005\u000f^5p]\"A\u00111\u0005\u0001!\u0002\u0013\tY\"A\u0006lKf$\u0018M\u0019$jY\u0016\u0004\u0003bBA\u0014\u0001\u0011%\u0011\u0011F\u0001\u0015g\u000eDW\rZ;mKR{7.\u001a8SK:,w/\u00197\u0015\u0003mDq!!\f\u0001\t\u0013\tI#\u0001\fhKRtUm\u001e#fY\u0016<\u0017\r^5p]R{7.\u001a8t\u0011\u001d\t\t\u0004\u0001C\u0005\u0003g\t\u0011D\u0019:pC\u0012\u001c\u0017m\u001d;EK2,w-\u0019;j_:$vn[3ogR\u001910!\u000e\t\rY\fy\u00031\u0001m\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\t\u0011bZ3u)>\\WM\\:\u0015\u00031\u0004")
public class MesosHadoopDelegationTokenManager
implements Logging {
    public final SparkConf org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf;
    private final RpcEndpointRef driverEndpoint;
    private final ScheduledExecutorService org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread;
    private final HadoopDelegationTokenManager org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager;
    private final String principal;
    private final /* synthetic */ Tuple2 x$1;
    private byte[] org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens;
    private long timeOfNextRenewal;
    private final Option<String> keytabFile;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ScheduledExecutorService org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread;
    }

    public HadoopDelegationTokenManager org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager;
    }

    private String principal() {
        return this.principal;
    }

    public byte[] org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens;
    }

    private void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens_$eq(byte[] x$1) {
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens = x$1;
    }

    private long timeOfNextRenewal() {
        return this.timeOfNextRenewal;
    }

    private void timeOfNextRenewal_$eq(long x$1) {
        this.timeOfNextRenewal = x$1;
    }

    private Option<String> keytabFile() {
        return this.keytabFile;
    }

    private void scheduleTokenRenewal() {
        if (!this.keytabFile().isDefined()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using ticket cache for Kerberos authentication, no token renewal.");
            return;
        }
        Predef$.MODULE$.require(this.principal() != null, (Function0 & Serializable & scala.Serializable)() -> "Principal is required for Keytab-based authentication");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Using keytab: ").append(this.keytabFile().get()).append(" and principal ").append(this.principal()).toString());
        Runnable credentialRenewerRunnable = new Runnable(this){
            private final /* synthetic */ MesosHadoopDelegationTokenManager $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$getNewDelegationTokens();
                    this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$broadcastDelegationTokens(this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens());
                }
                catch (Exception e) {
                    long delay = TimeUnit.SECONDS.toMillis(BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf.get(package$.MODULE$.CREDENTIALS_RENEWAL_RETRY_WAIT())));
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Couldn't broadcast tokens, trying again in ").append(UIUtils$.MODULE$.formatDuration(delay)).toString(), e);
                    this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread().schedule(this, delay, TimeUnit.MILLISECONDS);
                    return;
                }
                this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$scheduleRenewal$1(this);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(long )}, serializedLambda);
            }
        };
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$scheduleRenewal$1(credentialRenewerRunnable);
    }

    public void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$getNewDelegationTokens() {
        long l;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Attempting to login to KDC with principal ").append(this.principal()).toString());
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal(), (String)((String)this.keytabFile().get()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Successfully logged into KDC");
        Credentials tempCreds = ugi.getCredentials();
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf);
        long nextRenewalTime = BoxesRunTime.unboxToLong((Object)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(this, tempCreds, hadoopConf){
            private final /* synthetic */ MesosHadoopDelegationTokenManager $outer;
            private final Credentials tempCreds$1;
            private final Configuration hadoopConf$1;

            public long run() {
                return this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager().obtainDelegationTokens(this.hadoopConf$1, this.tempCreds$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tempCreds$1 = tempCreds$1;
                this.hadoopConf$1 = hadoopConf$1;
            }
        }));
        long currTime = System.currentTimeMillis();
        if (nextRenewalTime <= currTime) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Next credential renewal time (").append(nextRenewalTime).append(") is earlier than ").append(new StringBuilder(75).append("current time (").append(currTime).append("), which is unexpected, please check your credential renewal ").toString()).append("related configurations in the target services.").toString());
            l = currTime;
        } else {
            l = SparkHadoopUtil$.MODULE$.nextCredentialRenewalTime(nextRenewalTime, this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf);
        }
        this.timeOfNextRenewal_$eq(l);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Time of next renewal is in ").append(this.timeOfNextRenewal() - System.currentTimeMillis()).append(" ms").toString());
        UserGroupInformation.getCurrentUser().addCredentials(tempCreds);
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens_$eq(SparkHadoopUtil$.MODULE$.get().serialize(tempCreds));
    }

    public void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$broadcastDelegationTokens(byte[] tokens) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Sending new tokens to all executors");
        this.driverEndpoint.send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(tokens));
    }

    public byte[] getTokens() {
        return this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens();
    }

    private final Tuple2 liftedTree1$1() {
        Tuple2 tuple2;
        try {
            Credentials creds = UserGroupInformation.getCurrentUser().getCredentials();
            Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf);
            long rt = this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager().obtainDelegationTokens(hadoopConf, creds);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Initialized tokens: ").append(SparkHadoopUtil$.MODULE$.get().dumpTokens(creds)).toString());
            tuple2 = new Tuple2((Object)SparkHadoopUtil$.MODULE$.get().serialize(creds), (Object)BoxesRunTime.boxToLong((long)SparkHadoopUtil$.MODULE$.nextCredentialRenewalTime(rt, this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf)));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to fetch Hadoop delegation tokens ").append(e).toString());
            throw e;
        }
        return tuple2;
    }

    public final void org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$scheduleRenewal$1(Runnable runnable) {
        long remainingTime = this.timeOfNextRenewal() - System.currentTimeMillis();
        if (remainingTime <= 0L) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Credentials have expired, creating new ones now.");
            runnable.run();
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Scheduling login from keytab in ").append(remainingTime).append(" millis.").toString());
            this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread().schedule(runnable, remainingTime, TimeUnit.MILLISECONDS);
        }
    }

    public MesosHadoopDelegationTokenManager(SparkConf conf, Configuration hadoopConfig, RpcEndpointRef driverEndpoint) {
        long timeOfNextRenewal;
        byte[] tokens;
        block3: {
            Tuple2 tuple2;
            block2: {
                this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$conf = conf;
                this.driverEndpoint = driverEndpoint;
                Logging.$init$((Logging)this);
                Predef$.MODULE$.require(driverEndpoint != null, (Function0 & Serializable & scala.Serializable)() -> "DriverEndpoint is not initialized");
                this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$credentialRenewerThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Credential Renewal Thread");
                this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokenManager = new HadoopDelegationTokenManager(conf, hadoopConfig);
                this.principal = (String)((Option)conf.get((ConfigEntry)package$.MODULE$.PRINCIPAL())).orNull(Predef$.MODULE$.$conforms());
                tuple2 = this.liftedTree1$1();
                if (tuple2 == null) break block2;
                tokens = (byte[])tuple2._1();
                timeOfNextRenewal = tuple2._2$mcJ$sp();
                if (tokens != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        byte[] byArray = tokens;
        long l = timeOfNextRenewal;
        Tuple2 tuple2 = new Tuple2((Object)byArray, (Object)BoxesRunTime.boxToLong((long)l));
        this.x$1 = tuple2;
        this.org$apache$spark$scheduler$cluster$mesos$MesosHadoopDelegationTokenManager$$tokens = (byte[])this.x$1._1();
        this.timeOfNextRenewal = this.x$1._2$mcJ$sp();
        this.keytabFile = (Option)conf.get((ConfigEntry)package$.MODULE$.KEYTAB());
        this.scheduleTokenRenewal();
    }
}

