/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import org.apache.spark.SparkContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.mesos.MesosCoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.mesos.MesosFineGrainedSchedulerBackend;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001y3Q!\u0001\u0002\u0001\u00119\u00111#T3t_N\u001cE.^:uKJl\u0015M\\1hKJT!a\u0001\u0003\u0002\u000b5,7o\\:\u000b\u0005\u00151\u0011aB2mkN$XM\u001d\u0006\u0003\u000f!\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\r%\u0011\u0001D\u0002\u0002\u0017\u000bb$XM\u001d8bY\u000ecWo\u001d;fe6\u000bg.Y4fe\")!\u0004\u0001C\u00019\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\n1\"T#T\u001fN{&+R$F1V\t!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005AQ.\u0019;dQ&twM\u0003\u0002(#\u0005!Q\u000f^5m\u0013\tICEA\u0003SK\u001e,\u0007\u0010\u0003\u0004,\u0001\u0001\u0006IAI\u0001\r\u001b\u0016\u001bvjU0S\u000b\u001e+\u0005\f\t\u0005\u0006[\u0001!\tEL\u0001\nG\u0006t7I]3bi\u0016$\"a\f\u001a\u0011\u0005A\u0001\u0014BA\u0019\u0012\u0005\u001d\u0011un\u001c7fC:DQa\r\u0017A\u0002Q\n\u0011\"\\1ti\u0016\u0014XK\u0015'\u0011\u0005UbdB\u0001\u001c;!\t9\u0014#D\u00019\u0015\tI4$\u0001\u0004=e>|GOP\u0005\u0003wE\ta\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111(\u0005\u0005\u0006\u0001\u0002!\t%Q\u0001\u0014GJ,\u0017\r^3UCN\\7k\u00195fIVdWM\u001d\u000b\u0004\u0005\u0016[\u0005C\u0001\fD\u0013\t!eAA\u0007UCN\\7k\u00195fIVdWM\u001d\u0005\u0006\r~\u0002\raR\u0001\u0003g\u000e\u0004\"\u0001S%\u000e\u0003!I!A\u0013\u0005\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000bMz\u0004\u0019\u0001\u001b\t\u000b5\u0003A\u0011\t(\u0002-\r\u0014X-\u0019;f'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012$Ba\u0014*T)B\u0011a\u0003U\u0005\u0003#\u001a\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\t\u000b\u0019c\u0005\u0019A$\t\u000bMb\u0005\u0019\u0001\u001b\t\u000b\u001da\u0005\u0019\u0001\"\t\u000bY\u0003A\u0011I,\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002Y7r\u0003\"\u0001E-\n\u0005i\u000b\"\u0001B+oSRDQaB+A\u0002\tCQ!X+A\u0002=\u000bqAY1dW\u0016tG\r")
public class MesosClusterManager
implements ExternalClusterManager {
    private final Regex MESOS_REGEX = new StringOps(Predef$.MODULE$.augmentString("mesos://(.*)")).r();

    private Regex MESOS_REGEX() {
        return this.MESOS_REGEX;
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("mesos");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        return new TaskSchedulerImpl(sc);
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        Predef$.MODULE$.require(!BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.IO_ENCRYPTION_ENABLED())), (Function0 & java.io.Serializable & Serializable)() -> "I/O encryption is currently not supported in Mesos.");
        String mesosUrl = ((Regex.MatchData)this.MESOS_REGEX().findFirstMatchIn((CharSequence)masterURL).get()).group(1);
        boolean coarse = sc.conf().getBoolean("spark.mesos.coarse", true);
        return coarse ? new MesosCoarseGrainedSchedulerBackend((TaskSchedulerImpl)scheduler, sc, mesosUrl, sc.env().securityManager()) : new MesosFineGrainedSchedulerBackend((TaskSchedulerImpl)scheduler, sc, mesosUrl);
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }
}

