/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.mesos;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.mesos.MesosClusterDispatcher$;
import org.apache.spark.deploy.mesos.MesosClusterDispatcherArguments;
import org.apache.spark.deploy.mesos.config.package$;
import org.apache.spark.deploy.mesos.ui.MesosClusterUI;
import org.apache.spark.deploy.rest.mesos.MesosRestServer;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.mesos.BlackHoleMesosClusterPersistenceEngineFactory;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterPersistenceEngineFactory;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterScheduler;
import org.apache.spark.scheduler.cluster.mesos.ZookeeperMesosClusterPersistenceEngineFactory;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!B\u0001\u0003\u0001\ta!AF'fg>\u001c8\t\\;ti\u0016\u0014H)[:qCR\u001c\u0007.\u001a:\u000b\u0005\r!\u0011!B7fg>\u001c(BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0005CJ<7o\u0001\u0001\u0011\u0005uqR\"\u0001\u0002\n\u0005}\u0011!aH'fg>\u001c8\t\\;ti\u0016\u0014H)[:qCR\u001c\u0007.\u001a:Be\u001e,X.\u001a8ug\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0003d_:4\u0007CA\u0012%\u001b\u00051\u0011BA\u0013\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0004S)Z\u0003CA\u000f\u0001\u0011\u0015Qb\u00051\u0001\u001d\u0011\u0015\tc\u00051\u0001#\u0011\u001di\u0003A1A\u0005\n9\nQ\u0002];cY&\u001c\u0017\t\u001a3sKN\u001cX#A\u0018\u0011\u0005A:dBA\u00196!\t\u0011t\"D\u00014\u0015\t!4$\u0001\u0004=e>|GOP\u0005\u0003m=\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011ag\u0004\u0005\u0007w\u0001\u0001\u000b\u0011B\u0018\u0002\u001dA,(\r\\5d\u0003\u0012$'/Z:tA!9Q\b\u0001b\u0001\n\u0013q\u0014\u0001\u0004:fG>4XM]=N_\u0012,W#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u00029\u0003\"1q\t\u0001Q\u0001\n}\nQB]3d_Z,'/_'pI\u0016\u0004\u0003bB%\u0001\u0005\u0004%IAS\u0001\u000eK:<\u0017N\\3GC\u000e$xN]=\u0016\u0003-\u0003\"\u0001\u0014*\u000e\u00035S!a\u0001(\u000b\u0005=\u0003\u0016aB2mkN$XM\u001d\u0006\u0003#\u001a\t\u0011b]2iK\u0012,H.\u001a:\n\u0005Mk%\u0001J'fg>\u001c8\t\\;ti\u0016\u0014\b+\u001a:tSN$XM\\2f\u000b:<\u0017N\\3GC\u000e$xN]=\t\rU\u0003\u0001\u0015!\u0003L\u00039)gnZ5oK\u001a\u000b7\r^8ss\u0002Bq!\u0015\u0001C\u0002\u0013%q+F\u0001Y!\ta\u0015,\u0003\u0002[\u001b\n)R*Z:pg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014\bB\u0002/\u0001A\u0003%\u0001,\u0001\u0006tG\",G-\u001e7fe\u0002BqA\u0018\u0001C\u0002\u0013%q,\u0001\u0004tKJ4XM]\u000b\u0002AB\u0011\u0011-Z\u0007\u0002E*\u00111a\u0019\u0006\u0003I\u0012\tAA]3ti&\u0011aM\u0019\u0002\u0010\u001b\u0016\u001cxn\u001d*fgR\u001cVM\u001d<fe\"1\u0001\u000e\u0001Q\u0001\n\u0001\fqa]3sm\u0016\u0014\b\u0005C\u0004k\u0001\t\u0007I\u0011B6\u0002\u000b],'-V5\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0002\u0002\u0005UL\u0017BA9o\u00059iUm]8t\u00072,8\u000f^3s+&Caa\u001d\u0001!\u0002\u0013a\u0017AB<fEVK\u0007\u0005C\u0004v\u0001\t\u0007I\u0011\u0002<\u0002\u001bMDW\u000f\u001e3po:d\u0015\r^2i+\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003y\u000e\u000bA!\u001e;jY&\u0011a0\u001f\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011\u001d\t\t\u0001\u0001Q\u0001\n]\fab\u001d5vi\u0012|wO\u001c'bi\u000eD\u0007\u0005C\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005%\u0001c\u0001\b\u0002\f%\u0019\u0011QB\b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#\u0001A\u0011AA\u0004\u00035\tw/Y5u'\",H\u000fZ8x]\"9\u0011Q\u0003\u0001\u0005\u0002\u0005\u001d\u0011\u0001B:u_B<\u0001\"!\u0007\u0003\u0011\u0003\u0011\u00111D\u0001\u0017\u001b\u0016\u001cxn]\"mkN$XM\u001d#jgB\fGo\u00195feB\u0019Q$!\b\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0002 M1\u0011QD\u0007\u0014\u0003C\u0001B!a\t\u0002(5\u0011\u0011Q\u0005\u0006\u0003y\u001aIA!!\u000b\u0002&\t\u00012i\\7nC:$G*\u001b8f+RLGn\u001d\u0005\bO\u0005uA\u0011AA\u0017)\t\tY\u0002\u0003\u0005\u00022\u0005uA\u0011IA\u001a\u0003\u0011i\u0017-\u001b8\u0015\t\u0005%\u0011Q\u0007\u0005\b5\u0005=\u0002\u0019AA\u001c!\u0011q\u0011\u0011H\u0018\n\u0007\u0005mrBA\u0003BeJ\f\u0017\u0010")
public class MesosClusterDispatcher
implements Logging {
    private final MesosClusterDispatcherArguments args;
    private final SparkConf conf;
    private final String publicAddress;
    private final String recoveryMode;
    private final MesosClusterPersistenceEngineFactory engineFactory;
    private final MesosClusterScheduler scheduler;
    private final MesosRestServer server;
    private final MesosClusterUI webUi;
    private final CountDownLatch shutdownLatch;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        MesosClusterDispatcher$.MODULE$.main(stringArray);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String publicAddress() {
        return this.publicAddress;
    }

    private String recoveryMode() {
        return this.recoveryMode;
    }

    private MesosClusterPersistenceEngineFactory engineFactory() {
        return this.engineFactory;
    }

    private MesosClusterScheduler scheduler() {
        return this.scheduler;
    }

    private MesosRestServer server() {
        return this.server;
    }

    private MesosClusterUI webUi() {
        return this.webUi;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public void start() {
        this.webUi().bind();
        this.scheduler().frameworkUrl_$eq((String)((Option)this.conf.get(package$.MODULE$.DISPATCHER_WEBUI_URL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.webUi().activeWebUiUrl()));
        this.scheduler().start();
        this.server().start();
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public void stop() {
        this.webUi().stop();
        this.server().stop();
        this.scheduler().stop();
        this.shutdownLatch().countDown();
    }

    public MesosClusterDispatcher(MesosClusterDispatcherArguments args, SparkConf conf) {
        MesosClusterPersistenceEngineFactory mesosClusterPersistenceEngineFactory;
        this.args = args;
        this.conf = conf;
        Logging.$init$((Logging)this);
        String authKey = SecurityManager$.MODULE$.SPARK_AUTH_SECRET_CONF();
        Predef$.MODULE$.require(conf.getOption(authKey).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(146).append("The MesosClusterDispatcher does not support authentication via ").append(authKey).append(".  It is not ").append("currently possible to run jobs in cluster mode with authentication on.").toString());
        this.publicAddress = (String)Option$.MODULE$.apply((Object)conf.getenv("SPARK_PUBLIC_DNS")).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.args.host());
        this.recoveryMode = ((String)conf.get(package$.MODULE$.RECOVERY_MODE())).toUpperCase();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Recovery mode in Mesos dispatcher set to: ").append(this.recoveryMode()).toString());
        String string = this.recoveryMode();
        if ("NONE".equals(string)) {
            mesosClusterPersistenceEngineFactory = new BlackHoleMesosClusterPersistenceEngineFactory();
        } else if ("ZOOKEEPER".equals(string)) {
            mesosClusterPersistenceEngineFactory = new ZookeeperMesosClusterPersistenceEngineFactory(conf);
        } else {
            throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported recovery mode: ").append(this.recoveryMode()).toString());
        }
        this.engineFactory = mesosClusterPersistenceEngineFactory;
        this.scheduler = new MesosClusterScheduler(this.engineFactory(), conf);
        this.server = new MesosRestServer(args.host(), args.port(), conf, this.scheduler());
        this.webUi = new MesosClusterUI(new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2()), args.webUiPort(), conf, this.publicAddress(), this.scheduler());
        this.shutdownLatch = new CountDownLatch(1);
    }
}

