/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Closeable;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!\u0002\b\u0010\u0001UY\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u00119\u0002!\u0011!Q\u0001\n=BQa\u000f\u0001\u0005\u0002qB\u0011\u0002\u0011\u0001A\u0002\u0003\u0007I\u0011B!\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0013Q\u0005\"\u0003)\u0001\u0001\u0004\u0005\t\u0015)\u0003C\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\u0001\u0007\u0001\"\u0001b\r\u0011\u0011\u0007\u0001B2\t\u000bmJA\u0011A;\t\u000baLA\u0011I=\t\u000f\u0005m\u0011\u0002\"\u0011\u0002\u001e!1\u00111D\u0005\u0005B\u0005\u0014q$\u0012=fGV$xN\u001d)pIN<\u0016\r^2i':\f\u0007o\u001d5piN{WO]2f\u0015\t\u0001\u0012#A\u0002lqMT!AE\n\u0002\u000f\rdWo\u001d;fe*\u0011A#F\u0001\ng\u000eDW\rZ;mKJT!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\n\u0004\u0001q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$M5\tAE\u0003\u0002&+\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002(I\t9Aj\\4hS:<\u0017AD:oCB\u001c\bn\u001c;t'R|'/Z\u0002\u0001!\tYC&D\u0001\u0010\u0013\tisB\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0011\u0001'O\u0007\u0002c)\u0011!gM\u0001\u0007G2LWM\u001c;\u000b\u0005Q*\u0014AC6vE\u0016\u0014h.\u001a;fg*\u0011agN\u0001\bM\u0006\u0014'/[29\u0015\u0005A\u0014AA5p\u0013\tQ\u0014G\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u00061A(\u001b8jiz\"2!\u0010 @!\tY\u0003\u0001C\u0003)\u0007\u0001\u0007!\u0006C\u0003/\u0007\u0001\u0007q&A\bxCR\u001c\u0007nQ8o]\u0016\u001cG/[8o+\u0005\u0011\u0005CA\"H\u001b\u0005!%B\u0001\u001dF\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001\u0013#\u0003\u0013\rcwn]3bE2,\u0017aE<bi\u000eD7i\u001c8oK\u000e$\u0018n\u001c8`I\u0015\fHCA&O!\tiB*\u0003\u0002N=\t!QK\\5u\u0011\u001dyU!!AA\u0002\t\u000b1\u0001\u001f\u00132\u0003A9\u0018\r^2i\u0007>tg.Z2uS>t\u0007%A\u0003ti\u0006\u0014H\u000f\u0006\u0002L'\")Ak\u0002a\u0001+\u0006i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012\u0004\"AV/\u000f\u0005][\u0006C\u0001-\u001f\u001b\u0005I&B\u0001.*\u0003\u0019a$o\\8u}%\u0011ALH\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]=\u0005!1\u000f^8q)\u0005Y%aE#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQ\u0016\u00148cA\u0005eUB\u0011Q\r[\u0007\u0002M*\u0011q-R\u0001\u0005Y\u0006tw-\u0003\u0002jM\n1qJ\u00196fGR\u00042\u0001M6n\u0013\ta\u0017GA\u0004XCR\u001c\u0007.\u001a:\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018!B7pI\u0016d'B\u0001:4\u0003\r\t\u0007/[\u0005\u0003i>\u00141\u0001U8e)\u00051\bCA<\n\u001b\u0005\u0001\u0011!D3wK:$(+Z2fSZ,G\r\u0006\u0003Lu\u0006]\u0001\"B>\f\u0001\u0004a\u0018AB1di&|g\u000eE\u0002~\u0003#q1A`A\u0007\u001d\ry\u00181\u0002\b\u0005\u0003\u0003\tIA\u0004\u0003\u0002\u0004\u0005\u001dab\u0001-\u0002\u0006%\t\u0001(\u0003\u00027o%\u0011A'N\u0005\u0003eMJ1!a\u00042\u0003\u001d9\u0016\r^2iKJLA!a\u0005\u0002\u0016\t1\u0011i\u0019;j_:T1!a\u00042\u0011\u0019\tIb\u0003a\u0001[\u0006\u0019\u0001o\u001c3\u0002\u000f=t7\t\\8tKR\u00191*a\b\t\u000f\u0005\u0005B\u00021\u0001\u0002$\u0005\tQ\rE\u00021\u0003KI1!a\n2\u0005A9\u0016\r^2iKJ,\u0005pY3qi&|g\u000e")
public class ExecutorPodsWatchSnapshotSource
implements Logging {
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore;
    private final KubernetesClient kubernetesClient;
    private Closeable watchConnection;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Closeable watchConnection() {
        return this.watchConnection;
    }

    private void watchConnection_$eq(Closeable x$1) {
        this.watchConnection = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.watchConnection() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start the watcher twice.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Starting watch for pods with labels ").append(Constants$.MODULE$.SPARK_APP_ID_LABEL()).append("=").append(applicationId).append(",").append(" ").append(Constants$.MODULE$.SPARK_ROLE_LABEL()).append("=").append(Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).append(".").toString());
        this.watchConnection_$eq((Closeable)((Watchable)((Filterable)this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).watch((Object)new ExecutorPodsWatcher()));
    }

    public void stop() {
        block0: {
            if (this.watchConnection() == null) break block0;
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.watchConnection().close());
            this.watchConnection_$eq(null);
        }
    }

    public ExecutorPodsWatchSnapshotSource(ExecutorPodsSnapshotsStore snapshotsStore, KubernetesClient kubernetesClient) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore = snapshotsStore;
        this.kubernetesClient = kubernetesClient;
        Logging.$init$((Logging)this);
    }

    private class ExecutorPodsWatcher
    implements Watcher<Pod> {
        public boolean reconnecting() {
            return super.reconnecting();
        }

        public void eventReceived(Watcher.Action action, Pod pod) {
            String podName = pod.getMetadata().getName();
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received executor pod update for pod named ").append(podName).append(", action ").append(action).toString());
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore.updatePod(pod);
        }

        public void onClose(WatcherException e) {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kubernetes client has been closed (this is expected if the application is shutting down.)", (Throwable)e);
        }

        public void onClose() {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kubernetes client has been closed.");
        }

        public /* synthetic */ ExecutorPodsWatchSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer() {
            return ExecutorPodsWatchSnapshotSource.this;
        }

        public ExecutorPodsWatcher() {
            if (ExecutorPodsWatchSnapshotSource.this == null) {
                throw null;
            }
        }
    }
}

