/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\t\u0013\u0001aq\u0002\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011E\u0002!\u0011!Q\u0001\nIB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")a\n\u0001C\u0001\u001f\"9Q\u000b\u0001b\u0001\n\u00131\u0006B\u0002.\u0001A\u0003%q\u000bC\u0005\\\u0001\u0001\u0007\t\u0019!C\u00059\"IQ\u000e\u0001a\u0001\u0002\u0004%IA\u001c\u0005\nK\u0002\u0001\r\u0011!Q!\nuCQ\u0001\u001f\u0001\u0005\u0002eDq!a\u0004\u0001\t\u0003\t\tB\u0002\u0004\u0002\u0014\u0001!\u0011Q\u0003\u0005\tw6\u0011\t\u0011)A\u0005y\"1a*\u0004C\u0001\u0003SAq!!\r\u000e\t\u0003\n\tBA\u0011Fq\u0016\u001cW\u000f^8s!>$7\u000fU8mY&twm\u00158baNDw\u000e^*pkJ\u001cWM\u0003\u0002\u0014)\u0005\u00191\u000eO:\u000b\u0005U1\u0012aB2mkN$XM\u001d\u0006\u0003/a\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c2\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011a%K\u0007\u0002O)\u0011\u0001\u0006G\u0001\tS:$XM\u001d8bY&\u0011!f\n\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011afL\u0007\u00021%\u0011\u0001\u0007\u0007\u0002\n'B\f'o[\"p]\u001a\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005MbT\"\u0001\u001b\u000b\u0005U2\u0014AB2mS\u0016tGO\u0003\u00028q\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005eR\u0014a\u00024bEJL7\r\u000f\u0006\u0002w\u0005\u0011\u0011n\\\u0005\u0003{Q\u0012\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011\u0001)Q\u0007\u0002%%\u0011!I\u0005\u0002\u001b\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;t'R|'/Z\u0001\u0010a>dG.\u001b8h\u000bb,7-\u001e;peB\u0011Q\tT\u0007\u0002\r*\u0011q\tS\u0001\u000bG>t7-\u001e:sK:$(BA%K\u0003\u0011)H/\u001b7\u000b\u0003-\u000bAA[1wC&\u0011QJ\u0012\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0003Q#J\u001bF\u000b\u0005\u0002A\u0001!)1&\u0002a\u0001[!)\u0011'\u0002a\u0001e!)a(\u0002a\u0001\u007f!)1)\u0002a\u0001\t\u0006y\u0001o\u001c7mS:<\u0017J\u001c;feZ\fG.F\u0001X!\t\u0001\u0003,\u0003\u0002ZC\t!Aj\u001c8h\u0003A\u0001x\u000e\u001c7j]\u001eLe\u000e^3sm\u0006d\u0007%A\u0007q_2d\u0017N\\4GkR,(/Z\u000b\u0002;B\u0012al\u0019\t\u0004\u000b~\u000b\u0017B\u00011G\u0005\u00191U\u000f^;sKB\u0011!m\u0019\u0007\u0001\t%!'\"!A\u0001\u0002\u000b\u0005aMA\u0002`IE\na\u0002]8mY&twMR;ukJ,\u0007%\u0005\u0002hUB\u0011\u0001\u0005[\u0005\u0003S\u0006\u0012qAT8uQ&tw\r\u0005\u0002!W&\u0011A.\t\u0002\u0004\u0003:L\u0018!\u00059pY2Lgn\u001a$viV\u0014Xm\u0018\u0013fcR\u0011qN\u001d\t\u0003AAL!!]\u0011\u0003\tUs\u0017\u000e\u001e\u0005\bg&\t\t\u00111\u0001u\u0003\rAH%\r\u0019\u0003k^\u00042!R0w!\t\u0011w\u000fB\u0005ee\u0006\u0005\t\u0011!B\u0001M\u0006)1\u000f^1siR\u0011qN\u001f\u0005\u0006w.\u0001\r\u0001`\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0011\u0007u\fIAD\u0002\u007f\u0003\u000b\u0001\"a`\u0011\u000e\u0005\u0005\u0005!bAA\u0002Y\u00051AH]8pizJ1!a\u0002\"\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011qA\u0011\u0002\tM$x\u000e\u001d\u000b\u0002_\na\u0001k\u001c7m%Vtg.\u00192mKN)Q\"a\u0006\u0002$A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e)\u000bA\u0001\\1oO&!\u0011\u0011EA\u000e\u0005\u0019y%M[3diB!\u0011\u0011DA\u0013\u0013\u0011\t9#a\u0007\u0003\u0011I+hN\\1cY\u0016$B!a\u000b\u00020A\u0019\u0011QF\u0007\u000e\u0003\u0001AQa_\bA\u0002q\f1A];o\u0001")
public class ExecutorPodsPollingSnapshotSource
implements Logging {
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient;
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore;
    private final ScheduledExecutorService pollingExecutor;
    private final long pollingInterval;
    private Future<?> pollingFuture;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long pollingInterval() {
        return this.pollingInterval;
    }

    private Future<?> pollingFuture() {
        return this.pollingFuture;
    }

    private void pollingFuture_$eq(Future<?> x$1) {
        this.pollingFuture = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.pollingFuture() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start polling more than once.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Starting to check for executor pod state every ").append(this.pollingInterval()).append(" ms.").toString());
        this.pollingFuture_$eq(this.pollingExecutor.scheduleWithFixedDelay(new PollRunnable(this, applicationId), this.pollingInterval(), this.pollingInterval(), TimeUnit.MILLISECONDS));
    }

    public void stop() {
        if (this.pollingFuture() != null) {
            this.pollingFuture().cancel(true);
            this.pollingFuture_$eq(null);
        }
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.pollingExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public ExecutorPodsPollingSnapshotSource(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, ScheduledExecutorService pollingExecutor) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore = snapshotsStore;
        this.pollingExecutor = pollingExecutor;
        Logging.$init$((Logging)this);
        this.pollingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL()));
    }

    private class PollRunnable
    implements Runnable {
        private final String applicationId;
        public final /* synthetic */ ExecutorPodsPollingSnapshotSource $outer;

        @Override
        public void run() {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Resynchronizing full executor pod state from Kubernetes.");
                $this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore.replaceSnapshot((Seq<Pod>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)((Listable)((Filterable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withoutLabel(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL(), "true")).list()).getItems()).asScala()).toSeq());
            });
        }

        public /* synthetic */ ExecutorPodsPollingSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer() {
            return this.$outer;
        }

        public PollRunnable(ExecutorPodsPollingSnapshotSource $outer, String applicationId) {
            this.applicationId = applicationId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

