/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.KeyToPath;
import java.io.File;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class KubernetesClientUtils$
implements Logging {
    public static KubernetesClientUtils$ MODULE$;
    private final String configMapNameExecutor;
    private final String configMapNameDriver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KubernetesClientUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String configMapName(String prefix) {
        return new StringBuilder(9).append(new StringOps(Predef$.MODULE$.augmentString(prefix)).take(54)).append("-conf-map").toString();
    }

    public String configMapNameExecutor() {
        return this.configMapNameExecutor;
    }

    public String configMapNameDriver() {
        return this.configMapNameDriver;
    }

    private String buildStringFromPropertiesMap(String configMapName, Map<String, String> propertiesMap) {
        Properties properties = new Properties();
        propertiesMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = properties.setProperty(k, v);
            return object;
        });
        StringWriter propertiesWriter = new StringWriter();
        properties.store(propertiesWriter, new StringBuilder(60).append("Java properties built from Kubernetes config map with name: ").append(configMapName).toString());
        return propertiesWriter.toString();
    }

    public Map<String, String> buildSparkConfDirFilesMap(String configMapName, SparkConf sparkConf, Map<String, String> resolvedPropertiesMap) {
        Map map;
        Map loadedConfFilesMap = this.loadSparkConfDirFiles(sparkConf);
        if (resolvedPropertiesMap.nonEmpty()) {
            String resolvedProperties = this.buildStringFromPropertiesMap(configMapName, resolvedPropertiesMap);
            map = loadedConfFilesMap.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_CONF_FILE_NAME()), (Object)resolvedProperties)})));
        } else {
            map = loadedConfFilesMap;
        }
        return map;
    }

    public Seq<KeyToPath> buildKeyToPathObjects(Map<String, String> confFilesMap) {
        return (Seq)((TraversableOnce)confFilesMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            block3: {
                Tuple2 tuple2;
                block2: {
                    String fileName;
                    tuple2 = x0$1;
                    if (tuple2 == null || (fileName = (String)tuple2._1()) == null) break block2;
                    string = fileName;
                    if (tuple2._2() != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            int filePermissionMode = 420;
            KeyToPath keyToPath = new KeyToPath(string, Predef$.MODULE$.int2Integer(filePermissionMode), string);
            return keyToPath;
        }, Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1 & Serializable & scala.Serializable)x -> x.getKey(), (Ordering)Ordering.String$.MODULE$);
    }

    public ConfigMap buildConfigMap(String configMapName, Map<String, String> confFileMap, Map<String, String> withLabels) {
        return ((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName).withLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(withLabels).asJava())).endMetadata()).addToData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(confFileMap).asJava())).build();
    }

    public Map<String, String> buildConfigMap$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Map<String, String> loadSparkConfDirFiles(SparkConf conf) {
        Map map;
        Option confDir = Option$.MODULE$.apply((Object)conf.getenv(Constants$.MODULE$.ENV_SPARK_CONF_DIR())).orElse((Function0 & Serializable & scala.Serializable)() -> conf.getOption("spark.home").map((Function1 & Serializable & scala.Serializable)dir -> new StringBuilder(5).append((String)dir).append("/conf").toString()));
        if (confDir.isDefined()) {
            Seq<File> confFiles = this.listConfFiles((String)confDir.get());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Spark configuration files loaded from ").append(confDir).append(" : ").append(confFiles.mkString(",")).toString());
            map = ((TraversableOnce)confFiles.map((Function1 & Serializable & scala.Serializable)file -> {
                void var2_2;
                BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8());
                Tuple2 mapping = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getName()), (Object)source.mkString());
                source.close();
                return var2_2;
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<File> listConfFiles(String confDir) {
        void var3_4;
        Function1 & Serializable & scala.Serializable fileFilter = (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)KubernetesClientUtils$.$anonfun$listConfFiles$1(f));
        File dir = new File(confDir);
        Nil$ confFiles = dir.isDirectory() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)KubernetesClientUtils$.$anonfun$listConfFiles$2(fileFilter, x))))).toSeq() : Nil$.MODULE$;
        return var3_4;
    }

    public static final /* synthetic */ boolean $anonfun$listConfFiles$1(File f) {
        return f.isFile() && !f.getName().endsWith("template") && !f.getName().matches("spark.*(conf|properties)");
    }

    public static final /* synthetic */ boolean $anonfun$listConfFiles$2(Function1 fileFilter$1, File x) {
        return BoxesRunTime.unboxToBoolean((Object)fileFilter$1.apply((Object)x));
    }

    private KubernetesClientUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.configMapNameExecutor = this.configMapName(new StringBuilder(11).append("spark-exec-").append(KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1())).toString());
        this.configMapNameDriver = this.configMapName(new StringBuilder(10).append("spark-drv-").append(KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1())).toString());
    }
}

