/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.sparkproject.guava.io.Files;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014Q\u0001C\u0005\u0001\u001fUA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006M\u0001!\ta\n\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0011\u0019y\u0003\u0001)A\u0005Y!)\u0001\u0007\u0001C\u0001c!)q\u0007\u0001C!q!)q\t\u0001C!\u0011\nA\u0002k\u001c3UK6\u0004H.\u0019;f\u0007>tg-[4NCB\u001cF/\u001a9\u000b\u0005)Y\u0011\u0001\u00034fCR,(/Z:\u000b\u00051i\u0011aA69g*\u0011abD\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005A\t\u0012!B:qCJ\\'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c2\u0001\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDH\u0007\u0002\u0013%\u0011q$\u0003\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0002\t\r|gNZ\u0002\u0001!\t\u0019C%D\u0001\f\u0013\t)3B\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002\u001e\u0001!)\u0001E\u0001a\u0001E\u0005Y\u0001.Y:UK6\u0004H.\u0019;f+\u0005a\u0003CA\f.\u0013\tq\u0003DA\u0004C_>dW-\u00198\u0002\u0019!\f7\u000fV3na2\fG/\u001a\u0011\u0002\u0019\r|gNZ5hkJ,\u0007k\u001c3\u0015\u0005I*\u0004CA\u00124\u0013\t!4B\u0001\u0005Ta\u0006\u00148\u000eU8e\u0011\u00151T\u00011\u00013\u0003\r\u0001x\u000eZ\u0001!O\u0016$\u0018\t\u001a3ji&|g.\u00197Q_\u0012\u001c\u0016p\u001d;f[B\u0013x\u000e]3si&,7\u000fF\u0001:!\u0011Q\u0014\t\u0012#\u000f\u0005mz\u0004C\u0001\u001f\u0019\u001b\u0005i$B\u0001 \"\u0003\u0019a$o\\8u}%\u0011\u0001\tG\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%aA'ba*\u0011\u0001\t\u0007\t\u0003u\u0015K!AR\"\u0003\rM#(/\u001b8h\u0003\u0001:W\r^!eI&$\u0018n\u001c8bY.+(-\u001a:oKR,7OU3t_V\u00148-Z:\u0015\u0003%\u00032AS(S\u001d\tYUJ\u0004\u0002=\u0019&\t\u0011$\u0003\u0002O1\u00059\u0001/Y2lC\u001e,\u0017B\u0001)R\u0005\r\u0019V-\u001d\u0006\u0003\u001db\u0001\"a\u00150\u000e\u0003QS!!\u0016,\u0002\u000b5|G-\u001a7\u000b\u0005]C\u0016aA1qS*\u0011\u0011LW\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA.]\u0003\u001d1\u0017M\u0019:jGbR\u0011!X\u0001\u0003S>L!a\u0018+\u0003\u0017!\u000b7/T3uC\u0012\fG/\u0019")
public class PodTemplateConfigMapStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf conf;
    private final boolean hasTemplate;

    private boolean hasTemplate() {
        return this.hasTemplate;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        SparkPod sparkPod;
        if (this.hasTemplate()) {
            Pod podWithVolume = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)((ConfigMapVolumeSourceFluent.ItemsNested)new PodBuilder(pod.pod()).editSpec().addNewVolume().withName(Constants$.MODULE$.POD_TEMPLATE_VOLUME()).withNewConfigMap().withName(Constants$.MODULE$.POD_TEMPLATE_CONFIGMAP()).addNewItem().withKey(Constants$.MODULE$.POD_TEMPLATE_KEY()).withPath(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_FILE_NAME())).endItem()).endConfigMap()).endVolume()).endSpec()).build();
            Container containerWithVolume = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(pod.container()).addNewVolumeMount().withName(Constants$.MODULE$.POD_TEMPLATE_VOLUME()).withMountPath(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_MOUNTPATH())).endVolumeMount()).build();
            sparkPod = new SparkPod(podWithVolume, containerWithVolume);
        } else {
            sparkPod = pod;
        }
        return sparkPod;
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return this.hasTemplate() ? (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE().key()), (Object)new StringBuilder(1).append(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_MOUNTPATH()).append("/").append(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_FILE_NAME()).toString())})) : Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        Nil$ nil$;
        if (this.hasTemplate()) {
            String podTemplateFile = (String)((Option)this.conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).get();
            String podTemplateString = Files.toString((File)new File(podTemplateFile), (Charset)StandardCharsets.UTF_8);
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(Constants$.MODULE$.POD_TEMPLATE_CONFIGMAP())).endMetadata()).addToData(Constants$.MODULE$.POD_TEMPLATE_KEY(), podTemplateString)).build()}));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public PodTemplateConfigMapStep(KubernetesConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.hasTemplate = conf.contains((ConfigEntry<?>)Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE());
    }
}

