/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.cache.Cache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%f!\u0002\f\u0018\u0001u\u0019\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"AA\n\u0001B\u0001B\u0003%Q\nC\u0003b\u0001\u0011\u0005!\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\r5\u0004\u0001\u0015!\u0003l\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015A\b\u0001\"\u0003z\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002Z\u0001!I!a\u0017\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBAK\u0001\u0011%\u0011qS\u0004\b\u00037;\u0002\u0012BAO\r\u00191r\u0003#\u0003\u0002 \"1\u0011M\u0005C\u0001\u0003CC\u0011\"a)\u0013\u0005\u0004%\t!!*\t\u0011\u0005\u001d&\u0003)A\u0005\u0003\u001f\u0013A$\u0012=fGV$xN\u001d)pINd\u0015NZ3ds\u000edW-T1oC\u001e,'O\u0003\u0002\u00193\u0005\u00191\u000eO:\u000b\u0005iY\u0012aB2mkN$XM\u001d\u0006\u00039u\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c2\u0001\u0001\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111FL\u0007\u0002Y)\u0011Q&H\u0001\tS:$XM\u001d8bY&\u0011q\u0006\f\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u00111\u0007N\u0007\u0002;%\u0011Q'\b\u0002\n'B\f'o[\"p]\u001a\fq\"\u001a=fGV$xN\u001d\"vS2$WM\u001d\t\u0003qej\u0011aF\u0005\u0003u]\u0011\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003{\u0019k\u0011A\u0010\u0006\u0003\u007f\u0001\u000baa\u00197jK:$(BA!C\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003\u0007\u0012\u000bqAZ1ce&\u001c\u0007HC\u0001F\u0003\tIw.\u0003\u0002H}\t\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tA$*\u0003\u0002L/\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006)\"/Z7pm\u0016$W\t_3dkR|'o]\"bG\",\u0007\u0003\u0002(X3fk\u0011a\u0014\u0006\u0003!F\u000bQaY1dQ\u0016T!AU*\u0002\r\r|W.\\8o\u0015\t!V+\u0001\u0004h_><G.\u001a\u0006\u0002-\u0006\u00191m\\7\n\u0005a{%!B\"bG\",\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0007G\u0012,gm\u001a5\u0011\u0005a\u0002\u0001\"\u0002\u0019\u0007\u0001\u0004\u0011\u0004\"\u0002\u001c\u0007\u0001\u00049\u0004\"B\u001e\u0007\u0001\u0004a\u0004\"\u0002%\u0007\u0001\u0004I\u0005\"\u0002'\u0007\u0001\u0004i\u0015aF3wK:$\bK]8dKN\u001c\u0018N\\4J]R,'O^1m+\u0005Y\u0007CA\u0013m\u0013\t\u0001g%\u0001\rfm\u0016tG\u000f\u0015:pG\u0016\u001c8/\u001b8h\u0013:$XM\u001d<bY\u0002\nQa\u001d;beR$\"\u0001]:\u0011\u0005\u0015\n\u0018B\u0001:'\u0005\u0011)f.\u001b;\t\u000bQL\u0001\u0019A;\u0002!M\u001c\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007C\u0001\u001dw\u0013\t9xCA\u0011Lk\n,'O\\3uKN\u001cE.^:uKJ\u001c6\r[3ek2,'OQ1dW\u0016tG-\u0001\bp]:+wo\u00158baNDw\u000e^:\u0015\u0007AT8\u0010C\u0003u\u0015\u0001\u0007Q\u000fC\u0003}\u0015\u0001\u0007Q0A\u0005t]\u0006\u00048\u000f[8ugB)a0!\u0004\u0002\u00149\u0019q0!\u0003\u000f\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u00022\u0003\u0019a$o\\8u}%\tq%C\u0002\u0002\f\u0019\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0010\u0005E!aA*fc*\u0019\u00111\u0002\u0014\u0011\u0007a\n)\"C\u0002\u0002\u0018]\u0011A#\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$\u0018AF8o\r&t\u0017\r\u001c(p]\u0012+G.\u001a;fIN#\u0018\r^3\u0015\u0013A\fi\"a\n\u0002,\u00055\u0002bBA\u0010\u0017\u0001\u0007\u0011\u0011E\u0001\ta>$7\u000b^1uKB\u0019\u0001(a\t\n\u0007\u0005\u0015rCA\u0007GS:\fG\u000eU8e'R\fG/\u001a\u0005\u0007\u0003SY\u0001\u0019A6\u0002\r\u0015DXmY%e\u0011\u0015!8\u00021\u0001v\u0011\u001d\tyc\u0003a\u0001\u0003c\tQ#\u001a=fG&#7OU3n_Z,G-\u00138S_VtG\rE\u0003\u00024\u0005u2.\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u001diW\u000f^1cY\u0016T1!a\u000f'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\t)DA\u0002TKR\fQC]3n_Z,W\t_3dkR|'O\u0012:p[.C4\u000fF\u0002q\u0003\u000bBq!a\u0012\r\u0001\u0004\tI%\u0001\u0006va\u0012\fG/\u001a3Q_\u0012\u0004B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0003n_\u0012,GNC\u0002\u0002T\u0001\u000b1!\u00199j\u0013\u0011\t9&!\u0014\u0003\u0007A{G-A\fsK6|g/Z#yK\u000e,Ho\u001c:Ge>l7\u000b]1sWR9\u0001/!\u0018\u0002`\u0005\u0005\u0004\"\u0002;\u000e\u0001\u0004)\bbBA\u0010\u001b\u0001\u0007\u0011\u0011\u0005\u0005\u0007\u0003Si\u0001\u0019A6\u0002\u001d\u0019Lg\u000eZ#ySR\u0014V-Y:p]R1\u0011qMA8\u0003c\u0002B!!\u001b\u0002l5\t1$C\u0002\u0002nm\u0011a\"\u0012=fGV$xN]#ySR,G\rC\u0004\u0002 9\u0001\r!!\t\t\r\u0005%b\u00021\u0001l\u0003E)\u00070\u001b;SK\u0006\u001cxN\\'fgN\fw-\u001a\u000b\t\u0003o\n9)!#\u0002\fB!\u0011\u0011PAA\u001d\u0011\tY(! \u0011\u0007\u0005\u0005a%C\u0002\u0002\u0000\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BAB\u0003\u000b\u0013aa\u0015;sS:<'bAA@M!9\u0011qD\bA\u0002\u0005\u0005\u0002BBA\u0015\u001f\u0001\u00071\u000eC\u0004\u0002\u000e>\u0001\r!a$\u0002\u0011\u0015D\u0018\u000e^\"pI\u0016\u00042!JAI\u0013\r\t\u0019J\n\u0002\u0004\u0013:$\u0018\u0001\u00044j]\u0012,\u00050\u001b;D_\u0012,G\u0003BAH\u00033Cq!a\b\u0011\u0001\u0004\t\t#\u0001\u000fFq\u0016\u001cW\u000f^8s!>$7\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:\u0011\u0005a\u00122C\u0001\n%)\t\ti*A\tV\u001d.suj\u0016(`\u000bbKEkX\"P\t\u0016+\"!a$\u0002%Us5JT(X\u001d~+\u0005,\u0013+`\u0007>#U\t\t")
public class ExecutorPodsLifecycleManager
implements Logging {
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Cache<Long, Long> removedExecutorsCache;
    private final long eventProcessingInterval;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long eventProcessingInterval() {
        return this.eventProcessingInterval;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        this.snapshotsStore.addSubscriber(this.eventProcessingInterval(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        block1: {
            HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
            snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
                return BoxedUnit.UNIT;
            });
            if (snapshots.nonEmpty()) {
                ExecutorPodsSnapshot latestSnapshot = (ExecutorPodsSnapshot)snapshots.last();
                ((IterableLike)((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$6(x$2)), Seq$.MODULE$.canBuildFrom())).toSet().$minus$minus((GenTraversableOnce)latestSnapshot.executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound)).foreach((Function1 & Serializable & scala.Serializable)missingExecutorId -> ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$7(this, schedulerBackend, execIdsRemovedInThisRound, BoxesRunTime.unboxToLong((Object)missingExecutorId)));
            }
            if (!execIdsRemovedInThisRound.nonEmpty()) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Removed executors with ids ").append(execIdsRemovedInThisRound.mkString(",")).append(" from Spark that were either found to be deleted or non-existent in the cluster.").toString());
        }
    }

    private void onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, Set<Object> execIdsRemovedInRound) {
        this.removeExecutorFromK8s(podState.pod());
        this.removeExecutorFromSpark(schedulerBackend, podState, execId);
        execIdsRemovedInRound.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
    }

    private void removeExecutorFromK8s(Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).delete());
    }

    private void removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        block0: {
            if (this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) != null) break block0;
            this.removedExecutorsCache.put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)execId)).toString(), (ExecutorLossReason)exitReason);
        }
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean exitCausedByApp = tuple22._1$mcZ$sp();
        String exitMessage = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        Tuple2 tuple24 = tuple23;
        boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
        String exitMessage2 = (String)tuple24._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n       |The executor with id ").append(execId).append(" exited with exit code ").append(exitCode).append(".\n       |The API gave the following brief reason: ").append(pod.getStatus().getReason()).append("\n       |The API gave the following message: ").append(pod.getStatus().getMessage()).append("\n       |The API gave the following container statuses:\n       |\n       |").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Buffer$.MODULE$.canBuildFrom())).mkString("\n===\n")).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(new StringBuilder(10).append(" pod name ").append(state.pod().getMetadata().getName()).toString()).toString());
                    $this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId);
                    boxedUnit = execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodFailed) {
                    PodFailed podFailed = (PodFailed)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Snapshot reported failed executor with id ").append(execId).append(",").append(new StringBuilder(10).append(" pod name ").append(state.pod().getMetadata().getName()).toString()).toString());
                    $this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (executorPodState instanceof PodSucceeded) {
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(new StringBuilder(45).append(" pod name ").append(state.pod().getMetadata().getName()).append(". Note that succeeded executors are").toString()).append(" unusual unless Spark specifically informed the executor to exit.").toString());
                    $this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$6(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ Object $anonfun$onNewSnapshots$7(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, long missingExecutorId) {
        BoxedUnit boxedUnit;
        if ($this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)missingExecutorId)) == null) {
            String exitReasonMessage = new StringBuilder(191).append("The executor with ID ").append(missingExecutorId).append(" was not found in the").append(" cluster but we didn't get a reason why. Marking the executor as failed. The").append(" executor may have been deleted but the driver missed the deletion event.").toString();
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
            ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
            schedulerBackend$2.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)missingExecutorId)).toString(), (ExecutorLossReason)exitReason);
            boxedUnit = execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)missingExecutorId));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Cache<Long, Long> removedExecutorsCache) {
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.removedExecutorsCache = removedExecutorsCache;
        Logging.$init$((Logging)this);
        this.eventProcessingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
    }
}

