/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4QAB\u0004\u0001\u001bMA\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006a\u0001!\t!\r\u0005\u0006q\u0001!\t%\u000f\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0006\u001f\u0002!\t\u0005\u0015\u0002\u0016\u000b:48+Z2sKR\u001ch)Z1ukJ,7\u000b^3q\u0015\tA\u0011\"\u0001\u0005gK\u0006$XO]3t\u0015\tQ1\"A\u0002lqMT!\u0001D\u0007\u0002\r\u0011,\u0007\u000f\\8z\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7c\u0001\u0001\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u000f\u000e\u0003\u001dI!!H\u0004\u00037-+(-\u001a:oKR,7OR3biV\u0014XmQ8oM&<7\u000b^3q\u00039YWOY3s]\u0016$Xm]\"p]\u001a\u001c\u0001\u0001\r\u0002\"OA\u0019!eI\u0013\u000e\u0003%I!\u0001J\u0005\u0003\u001d-+(-\u001a:oKR,7oQ8oMB\u0011ae\n\u0007\u0001\t%A\u0013!!A\u0001\u0002\u000b\u0005\u0011FA\u0002`IE\n\"AK\u0017\u0011\u0005UY\u0013B\u0001\u0017\u0017\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\t\u0018\n\u0005=J!AG&vE\u0016\u0014h.\u001a;fgJ{G.Z*qK\u000eLg-[2D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u00023gA\u00111\u0004\u0001\u0005\u0006=\t\u0001\r\u0001\u000e\u0019\u0003k]\u00022AI\u00127!\t1s\u0007B\u0005)g\u0005\u0005\t\u0011!B\u0001S\u0005a1m\u001c8gS\u001e,(/\u001a)pIR\u0011!(\u0010\t\u0003EmJ!\u0001P\u0005\u0003\u0011M\u0003\u0018M]6Q_\u0012DQAP\u0002A\u0002i\n1\u0001]8e\u0003\u0001:W\r^!eI&$\u0018n\u001c8bYB{GmU=ti\u0016l\u0007K]8qKJ$\u0018.Z:\u0015\u0003\u0005\u0003BAQ%M\u0019:\u00111i\u0012\t\u0003\tZi\u0011!\u0012\u0006\u0003\r~\ta\u0001\u0010:p_Rt\u0014B\u0001%\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0004\u001b\u0006\u0004(B\u0001%\u0017!\t\u0011U*\u0003\u0002O\u0017\n11\u000b\u001e:j]\u001e\f\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d7*\u001e2fe:,G/Z:SKN|WO]2fgR\t\u0011\u000bE\u0002S/js!aU+\u000f\u0005\u0011#\u0016\"A\f\n\u0005Y3\u0012a\u00029bG.\fw-Z\u0005\u00031f\u00131aU3r\u0015\t1f\u0003\u0005\u0002\\M6\tAL\u0003\u0002^=\u0006)Qn\u001c3fY*\u0011q\fY\u0001\u0004CBL'BA1c\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003G\u0012\fqAZ1ce&\u001c\u0007HC\u0001f\u0003\tIw.\u0003\u0002h9\nY\u0001*Y:NKR\fG-\u0019;b\u0001")
public class EnvSecretsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Iterable addedEnvSecrets = (Iterable)this.kubernetesConf.roleSecretEnvNamesToKeyRefs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String envName = (String)tuple2._1();
            String keyRef = (String)tuple2._2();
            String[] keyRefParts = keyRef.split(":");
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyRefParts)).size() == 2, (Function0 & Serializable & scala.Serializable)() -> "SecretKeyRef must be in the form name:key.");
            String name = keyRefParts[0];
            String key = keyRefParts[1];
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarFluentImpl)new EnvVarBuilder().withName(envName)).withNewValueFrom().withNewSecretKeyRef().withKey(key).withName(name)).endSecretKeyRef()).endValueFrom()).build();
            return envVar;
        }, Iterable$.MODULE$.canBuildFrom());
        Container containerWithEnvVars = ((ContainerBuilder)new ContainerBuilder(pod.container()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(addedEnvSecrets.toSeq()).asJava())).build();
        return new SparkPod(pod.pod(), containerWithEnvVars);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public EnvSecretsFeatureStep(KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

