/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.cache.Cache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%f!B\u0001\u0003\u0001!q!\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t1a\u001b\u001dt\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011!C:dQ\u0016$W\u000f\\3s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%a$\u0001\u0003d_:47\u0001\u0001\t\u0003?\u0001j\u0011\u0001C\u0005\u0003C!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nq\"\u001a=fGV$xN\u001d\"vS2$WM\u001d\t\u0003K\u0019j\u0011AA\u0005\u0003O\t\u0011\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u00111\u0006N\u0007\u0002Y)\u0011QFL\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0002\u0014AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0011GM\u0001\bM\u0006\u0014'/[29\u0015\u0005\u0019\u0014AA5p\u0013\t)DF\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\bt]\u0006\u00048\u000f[8ugN#xN]3\u0011\u0005\u0015J\u0014B\u0001\u001e\u0003\u0005i)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u0011!a\u0004A!A!\u0002\u0013i\u0014!\u0006:f[>4X\rZ#yK\u000e,Ho\u001c:t\u0007\u0006\u001c\u0007.\u001a\t\u0005}\u001dK\u0015*D\u0001@\u0015\t\u0001\u0015)A\u0003dC\u000eDWM\u0003\u0002C\u0007\u000611m\\7n_:T!\u0001R#\u0002\r\u001d|wn\u001a7f\u0015\u00051\u0015aA2p[&\u0011\u0001j\u0010\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u0011auN\\4\t\u000bI\u0003A\u0011A*\u0002\rqJg.\u001b;?)\u0019!VKV,Y3B\u0011Q\u0005\u0001\u0005\u00069E\u0003\rA\b\u0005\u0006GE\u0003\r\u0001\n\u0005\u0006SE\u0003\rA\u000b\u0005\u0006oE\u0003\r\u0001\u000f\u0005\u0006yE\u0003\r!\u0010\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003])g/\u001a8u!J|7-Z:tS:<\u0017J\u001c;feZ\fG.F\u0001^!\t\u0001b,\u0003\u0002Q#!1\u0001\r\u0001Q\u0001\nu\u000b\u0001$\u001a<f]R\u0004&o\\2fgNLgnZ%oi\u0016\u0014h/\u00197!\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u0015\u0019H/\u0019:u)\t!w\r\u0005\u0002\u0011K&\u0011a-\u0005\u0002\u0005+:LG\u000fC\u0003iC\u0002\u0007\u0011.\u0001\ttG\",G-\u001e7fe\n\u000b7m[3oIB\u0011QE[\u0005\u0003W\n\u0011\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012DQ!\u001c\u0001\u0005\n9\fab\u001c8OK^\u001cf.\u00199tQ>$8\u000fF\u0002e_BDQ\u0001\u001b7A\u0002%DQ!\u001d7A\u0002I\f\u0011b\u001d8baNDw\u000e^:\u0011\u0007M\\hP\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011q/H\u0001\u0007yI|w\u000e\u001e \n\u0003II!A_\t\u0002\u000fA\f7m[1hK&\u0011A0 \u0002\u0004'\u0016\f(B\u0001>\u0012!\t)s0C\u0002\u0002\u0002\t\u0011A#\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$\bbBA\u0003\u0001\u0011%\u0011qA\u0001\u0017_:4\u0015N\\1m\u001d>tG)\u001a7fi\u0016$7\u000b^1uKRIA-!\u0003\u0002\u0014\u0005]\u0011\u0011\u0004\u0005\t\u0003\u0017\t\u0019\u00011\u0001\u0002\u000e\u0005A\u0001o\u001c3Ti\u0006$X\rE\u0002&\u0003\u001fI1!!\u0005\u0003\u000551\u0015N\\1m!>$7\u000b^1uK\"9\u0011QCA\u0002\u0001\u0004i\u0016AB3yK\u000eLE\r\u0003\u0004i\u0003\u0007\u0001\r!\u001b\u0005\t\u00037\t\u0019\u00011\u0001\u0002\u001e\u0005)R\r_3d\u0013\u0012\u001c(+Z7pm\u0016$\u0017J\u001c*pk:$\u0007#BA\u0010\u0003SiVBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u000f5,H/\u00192mK*\u0019\u0011qE\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0005\"aA*fi\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012!\u0006:f[>4X-\u0012=fGV$xN\u001d$s_6\\\u0005h\u001d\u000b\u0004I\u0006M\u0002\u0002CA\u001b\u0003[\u0001\r!a\u000e\u0002\u0015U\u0004H-\u0019;fIB{G\r\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000b5|G-\u001a7\u000b\u0007\u0005\u0005c&A\u0002ba&LA!!\u0012\u0002<\t\u0019\u0001k\u001c3\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u00059\"/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n'B\f'o\u001b\u000b\bI\u00065\u0013qJA)\u0011\u0019A\u0017q\ta\u0001S\"A\u00111BA$\u0001\u0004\ti\u0001C\u0004\u0002\u0016\u0005\u001d\u0003\u0019A/\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005qa-\u001b8e\u000bbLGOU3bg>tGCBA-\u0003C\n\u0019\u0007\u0005\u0003\u0002\\\u0005uS\"\u0001\u0004\n\u0007\u0005}cA\u0001\bFq\u0016\u001cW\u000f^8s\u000bbLG/\u001a3\t\u0011\u0005-\u00111\u000ba\u0001\u0003\u001bAq!!\u0006\u0002T\u0001\u0007Q\fC\u0004\u0002h\u0001!I!!\u001b\u0002#\u0015D\u0018\u000e\u001e*fCN|g.T3tg\u0006<W\r\u0006\u0005\u0002l\u0005m\u0014QPA@!\u0011\ti'!\u001e\u000f\t\u0005=\u0014\u0011\u000f\t\u0003kFI1!a\u001d\u0012\u0003\u0019\u0001&/\u001a3fM&!\u0011qOA=\u0005\u0019\u0019FO]5oO*\u0019\u00111O\t\t\u0011\u0005-\u0011Q\ra\u0001\u0003\u001bAq!!\u0006\u0002f\u0001\u0007Q\f\u0003\u0005\u0002\u0002\u0006\u0015\u0004\u0019AAB\u0003!)\u00070\u001b;D_\u0012,\u0007c\u0001\t\u0002\u0006&\u0019\u0011qQ\t\u0003\u0007%sG\u000fC\u0004\u0002\f\u0002!I!!$\u0002\u0019\u0019Lg\u000eZ#ySR\u001cu\u000eZ3\u0015\t\u0005\r\u0015q\u0012\u0005\t\u0003\u0017\tI\t1\u0001\u0002\u000e\u001d9\u00111\u0013\u0002\t\n\u0005U\u0015\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\t\u0004K\u0005]eAB\u0001\u0003\u0011\u0013\tIjE\u0002\u0002\u0018>AqAUAL\t\u0003\ti\n\u0006\u0002\u0002\u0016\"Q\u0011\u0011UAL\u0005\u0004%\t!a)\u0002#Us5JT(X\u001d~+\u0005,\u0013+`\u0007>#U)\u0006\u0002\u0002\u0004\"I\u0011qUALA\u0003%\u00111Q\u0001\u0013+:[ejT,O?\u0016C\u0016\nV0D\u001f\u0012+\u0005\u0005")
public class ExecutorPodsLifecycleManager
implements Logging {
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Cache<Long, Long> removedExecutorsCache;
    private final long eventProcessingInterval;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long eventProcessingInterval() {
        return this.eventProcessingInterval;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        this.snapshotsStore.addSubscriber(this.eventProcessingInterval(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        block1: {
            HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
            snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
                return BoxedUnit.UNIT;
            });
            if (snapshots.nonEmpty()) {
                ExecutorPodsSnapshot latestSnapshot = (ExecutorPodsSnapshot)snapshots.last();
                ((IterableLike)((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$6(x$2)), Seq$.MODULE$.canBuildFrom())).toSet().$minus$minus((GenTraversableOnce)latestSnapshot.executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound)).foreach((Function1 & Serializable & scala.Serializable)missingExecutorId -> ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$7(this, schedulerBackend, execIdsRemovedInThisRound, BoxesRunTime.unboxToLong((Object)missingExecutorId)));
            }
            if (!execIdsRemovedInThisRound.nonEmpty()) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Removed executors with ids ").append(execIdsRemovedInThisRound.mkString(",")).append(" from Spark that were either found to be deleted or non-existent in the cluster.").toString());
        }
    }

    private void onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, Set<Object> execIdsRemovedInRound) {
        this.removeExecutorFromK8s(podState.pod());
        this.removeExecutorFromSpark(schedulerBackend, podState, execId);
        execIdsRemovedInRound.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
    }

    private void removeExecutorFromK8s(Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).delete());
    }

    private void removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        block0: {
            if (this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) != null) break block0;
            this.removedExecutorsCache.put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)execId)).toString(), (ExecutorLossReason)exitReason);
        }
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean exitCausedByApp = tuple22._1$mcZ$sp();
        String exitMessage = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        Tuple2 tuple24 = tuple23;
        boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
        String exitMessage2 = (String)tuple24._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n       |The executor with id ").append(execId).append(" exited with exit code ").append(exitCode).append(".\n       |The API gave the following brief reason: ").append(pod.getStatus().getReason()).append("\n       |The API gave the following message: ").append(pod.getStatus().getMessage()).append("\n       |The API gave the following container statuses:\n       |\n       |").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Buffer$.MODULE$.canBuildFrom())).mkString("\n===\n")).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(new StringBuilder(10).append(" pod name ").append(state.pod().getMetadata().getName()).toString()).toString());
                    $this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId);
                    boxedUnit = execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodFailed) {
                    PodFailed podFailed = (PodFailed)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Snapshot reported failed executor with id ").append(execId).append(",").append(new StringBuilder(10).append(" pod name ").append(state.pod().getMetadata().getName()).toString()).toString());
                    $this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (executorPodState instanceof PodSucceeded) {
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(new StringBuilder(45).append(" pod name ").append(state.pod().getMetadata().getName()).append(". Note that succeeded executors are").toString()).append(" unusual unless Spark specifically informed the executor to exit.").toString());
                    $this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$6(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ Object $anonfun$onNewSnapshots$7(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, long missingExecutorId) {
        BoxedUnit boxedUnit;
        if ($this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)missingExecutorId)) == null) {
            String exitReasonMessage = new StringBuilder(191).append("The executor with ID ").append(missingExecutorId).append(" was not found in the").append(" cluster but we didn't get a reason why. Marking the executor as failed. The").append(" executor may have been deleted but the driver missed the deletion event.").toString();
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
            ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
            schedulerBackend$2.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)missingExecutorId)).toString(), (ExecutorLossReason)exitReason);
            boxedUnit = execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)missingExecutorId));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Cache<Long, Long> removedExecutorsCache) {
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.removedExecutorsCache = removedExecutorsCache;
        Logging.$init$((Logging)this);
        this.eventProcessingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
    }
}

