/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Properties;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!B\u0001\u0003\u0001!q!AB\"mS\u0016tGO\u0003\u0002\u0004\t\u000511/\u001e2nSRT!!\u0002\u0004\u0002\u0007-D4O\u0003\u0002\b\u0011\u00051A-\u001a9m_fT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001b/\t9Aj\\4hS:<\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u000f\t,\u0018\u000e\u001c3fe\u000e\u0001\u0001CA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u0005]YUOY3s]\u0016$Xm\u001d#sSZ,'OQ;jY\u0012,'\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u00039YWOY3s]\u0016$Xm]\"p]\u001a\u00042!\n\u0014)\u001b\u0005!\u0011BA\u0014\u0005\u00059YUOY3s]\u0016$Xm]\"p]\u001a\u0004\"!J\u0015\n\u0005)\"!\u0001H&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s'B,7-\u001b4jG\u000e{gN\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003]]j\u0011a\f\u0006\u0003aE\naa\u00197jK:$(B\u0001\u001a4\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003iU\nqAZ1ce&\u001c\u0007HC\u00017\u0003\tIw.\u0003\u00029_\t\u00012*\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u0005!r/Y5u\r>\u0014\u0018\t\u001d9D_6\u0004H.\u001a;j_:\u0004\"\u0001\u0005\u001f\n\u0005u\n\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u00069\u0011\r\u001d9OC6,\u0007CA!I\u001d\t\u0011e\t\u0005\u0002D#5\tAI\u0003\u0002F;\u00051AH]8pizJ!aR\t\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000fFA\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!T\u0001\bo\u0006$8\r[3s!\tyb*\u0003\u0002P\u0005\t9Bj\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM\u001d\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0001\u0006a2.\u001e2fe:,G/Z:SKN|WO]2f\u001d\u0006lW\r\u0015:fM&D\b\"B*\u0001\t\u0003!\u0016A\u0002\u001fj]&$h\b\u0006\u0005V-^C\u0016LW.]!\ty\u0002\u0001C\u0003\u001d%\u0002\u0007a\u0004C\u0003$%\u0002\u0007A\u0005C\u0003-%\u0002\u0007Q\u0006C\u0003;%\u0002\u00071\bC\u0003@%\u0002\u0007\u0001\tC\u0003M%\u0002\u0007Q\nC\u0003R%\u0002\u0007\u0001\tC\u0003_\u0001\u0011\u0005q,A\u0002sk:$\u0012\u0001\u0019\t\u0003!\u0005L!AY\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\u0002!I!Z\u0001\u0018C\u0012$GI]5wKJ|uO\\3s%\u00164WM]3oG\u0016$2\u0001\u00194q\u0011\u001597\r1\u0001i\u0003%!'/\u001b<feB{G\r\u0005\u0002j]6\t!N\u0003\u0002lY\u0006)Qn\u001c3fY*\u0011Q.M\u0001\u0004CBL\u0017BA8k\u0005\r\u0001v\u000e\u001a\u0005\u0006c\u000e\u0004\rA]\u0001\ne\u0016\u001cx.\u001e:dKN\u00042a\u001d=|\u001d\t!hO\u0004\u0002Dk&\t!#\u0003\u0002x#\u00059\u0001/Y2lC\u001e,\u0017BA={\u0005\r\u0019V-\u001d\u0006\u0003oF\u0001\"!\u001b?\n\u0005uT'a\u0003%bg6+G/\u00193bi\u0006Daa \u0001\u0005\n\u0005\u0005\u0011A\u00042vS2$7i\u001c8gS\u001el\u0015\r\u001d\u000b\u0007\u0003\u0007\tI!!\u0004\u0011\u0007%\f)!C\u0002\u0002\b)\u0014\u0011bQ8oM&<W*\u00199\t\r\u0005-a\u00101\u0001A\u00035\u0019wN\u001c4jO6\u000b\u0007OT1nK\"9\u0011q\u0002@A\u0002\u0005E\u0011\u0001B2p]\u001a\u0004R!QA\n\u0001\u0002K1!!\u0006K\u0005\ri\u0015\r\u001d")
public class Client
implements Logging {
    private final KubernetesDriverBuilder builder;
    private final KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf;
    private final KubernetesClient kubernetesClient;
    private final boolean waitForAppCompletion;
    private final String appName;
    private final LoggingPodStatusWatcher watcher;
    private final String kubernetesResourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void run() {
        KubernetesDriverSpec resolvedDriverSpec = this.builder.buildFromFeatures(this.kubernetesConf);
        String configMapName = new StringBuilder(16).append(this.kubernetesResourceNamePrefix).append("-driver-conf-map").toString();
        ConfigMap configMap = this.buildConfigMap(configMapName, resolvedDriverSpec.systemProperties());
        Container resolvedDriverContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(resolvedDriverSpec.pod().container()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Pod resolvedDriverPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(resolvedDriverSpec.pod().pod()).editSpec().addToContainers(new Container[]{resolvedDriverContainer}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withNewConfigMap().withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (Watch)((Watchable)$this.kubernetesClient.pods().withName(resolvedDriverPod.getMetadata().getName())).watch((Object)$this.watcher), (Function1 & Serializable & scala.Serializable)x$1 -> {
            Client.$anonfun$run$2(this, resolvedDriverSpec, configMap, resolvedDriverPod, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void addDriverOwnerReference(Pod driverPod, Seq<HasMetadata> resources) {
        OwnerReference driverPodOwnerReference = ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withName(driverPod.getMetadata().getName())).withApiVersion(driverPod.getApiVersion())).withUid(driverPod.getMetadata().getUid())).withKind(driverPod.getKind())).withController(Predef$.MODULE$.boolean2Boolean(true))).build();
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            Client.$anonfun$addDriverOwnerReference$1(driverPodOwnerReference, resource);
            return BoxedUnit.UNIT;
        });
    }

    private ConfigMap buildConfigMap(String configMapName, Map<String, String> conf) {
        Properties properties = new Properties();
        conf.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = properties.setProperty(k, v);
            return object;
        });
        StringWriter propertiesWriter = new StringWriter();
        properties.store(propertiesWriter, new StringBuilder(60).append("Java properties built from Kubernetes config map with name: ").append(configMapName).toString());
        return ((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(Constants$.MODULE$.SPARK_CONF_FILE_NAME(), propertiesWriter.toString())).build();
    }

    public static final /* synthetic */ void $anonfun$run$2(Client $this, KubernetesDriverSpec resolvedDriverSpec$1, ConfigMap configMap$1, Pod resolvedDriverPod$1, Watch x$1) {
        Pod createdDriverPod = (Pod)$this.kubernetesClient.pods().create((Object[])new Pod[]{resolvedDriverPod$1});
        try {
            Seq otherKubernetesResources = (Seq)resolvedDriverSpec$1.driverKubernetesResources().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigMap[]{configMap$1})), Seq$.MODULE$.canBuildFrom());
            $this.addDriverOwnerReference(createdDriverPod, (Seq<HasMetadata>)otherKubernetesResources);
            $this.kubernetesClient.resourceList((HasMetadata[])otherKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdDriverPod});
                throw e;
            }
            throw throwable;
        }
        if ($this.waitForAppCompletion) {
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Waiting for application ").append($this.appName).append(" to finish...").toString());
            $this.watcher.awaitCompletion();
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Application ").append($this.appName).append(" finished.").toString());
        } else {
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Deployed Spark application ").append($this.appName).append(" into Kubernetes.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$addDriverOwnerReference$1(OwnerReference driverPodOwnerReference$1, HasMetadata resource) {
        ObjectMeta originalMetadata = resource.getMetadata();
        originalMetadata.setOwnerReferences(Collections.singletonList(driverPodOwnerReference$1));
    }

    public Client(KubernetesDriverBuilder builder, KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf, KubernetesClient kubernetesClient, boolean waitForAppCompletion, String appName, LoggingPodStatusWatcher watcher, String kubernetesResourceNamePrefix) {
        this.builder = builder;
        this.kubernetesConf = kubernetesConf;
        this.kubernetesClient = kubernetesClient;
        this.waitForAppCompletion = waitForAppCompletion;
        this.appName = appName;
        this.watcher = watcher;
        this.kubernetesResourceNamePrefix = kubernetesResourceNamePrefix;
        Logging.$init$((Logging)this);
    }
}

