/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!B\u0001\u0003\u0001!q!aF'pk:$hk\u001c7v[\u0016\u001ch)Z1ukJ,7\u000b^3q\u0015\t\u0019A!\u0001\u0005gK\u0006$XO]3t\u0015\t)a!A\u0002lqMT!a\u0002\u0005\u0002\r\u0011,\u0007\u000f\\8z\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u00037-+(-\u001a:oKR,7OR3biV\u0014XmQ8oM&<7\u000b^3q\u0011!Q\u0002A!A!\u0002\u0013a\u0012AD6vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u0002\u0001a\ti2\u0005E\u0002\u001f?\u0005j\u0011\u0001B\u0005\u0003A\u0011\u0011abS;cKJtW\r^3t\u0007>tg\r\u0005\u0002#G1\u0001A!\u0003\u0013\u001a\u0003\u0003\u0005\tQ!\u0001&\u0005\ryF%M\t\u0003M%\u0002\"\u0001E\u0014\n\u0005!\n\"a\u0002(pi\"Lgn\u001a\t\u0003=)J!a\u000b\u0003\u00035-+(-\u001a:oKR,7OU8mKN\u0003XmY5gS\u000e\u001cuN\u001c4\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0002\u0017\u0001!)!\u0004\fa\u0001cA\u0012!\u0007\u000e\t\u0004=}\u0019\u0004C\u0001\u00125\t%!\u0003'!A\u0001\u0002\u000b\u0005Q\u0005C\u00037\u0001\u0011\u0005s'\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u00029wA\u0011a$O\u0005\u0003u\u0011\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006yU\u0002\r\u0001O\u0001\u0004a>$\u0007\"\u0002 \u0001\t\u0003z\u0014\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\u0012\u0001\u0011\t\u0005\u0003\"[5J\u0004\u0002C\rB\u00111)E\u0007\u0002\t*\u0011QiG\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\u000b\u0012A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n\u0019Q*\u00199\u000b\u0005\u001d\u000b\u0002CA!M\u0013\ti%J\u0001\u0004TiJLgn\u001a\u0005\u0006\u001f\u0002!\t\u0005U\u0001!O\u0016$\u0018\t\u001a3ji&|g.\u00197Lk\n,'O\\3uKN\u0014Vm]8ve\u000e,7\u000fF\u0001R!\r\u0011vK\u0017\b\u0003'Vs!a\u0011+\n\u0003II!AV\t\u0002\u000fA\f7m[1hK&\u0011\u0001,\u0017\u0002\u0004'\u0016\f(B\u0001,\u0012!\tYf-D\u0001]\u0015\tif,A\u0003n_\u0012,GN\u0003\u0002`A\u0006\u0019\u0011\r]5\u000b\u0005\u0005\u0014\u0017AC6vE\u0016\u0014h.\u001a;fg*\u00111\rZ\u0001\bM\u0006\u0014'/[29\u0015\u0005)\u0017AA5p\u0013\t9GLA\u0006ICNlU\r^1eCR\f\u0007\"B5\u0001\t\u0013Q\u0017\u0001E2p]N$(/^2u->dW/\\3t)\tYw\u000fE\u0002SY:L!!\\-\u0003\u0011%#XM]1cY\u0016\u0004B\u0001E8ri&\u0011\u0001/\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005m\u0013\u0018BA:]\u0005-1v\u000e\\;nK6{WO\u001c;\u0011\u0005m+\u0018B\u0001<]\u0005\u00191v\u000e\\;nK\")\u0001\u0010\u001ba\u0001s\u0006Yao\u001c7v[\u0016\u001c\u0006/Z2t!\r\u0011FN\u001f\u0019\u0003w~\u00042A\b?\u007f\u0013\tiHA\u0001\u000bLk\n,'O\\3uKN4v\u000e\\;nKN\u0003Xm\u0019\t\u0003E}$1\"!\u0001x\u0003\u0003\u0005\tQ!\u0001\u0002\u0004\t\u0019q\f\n\u001a\u0012\u0007\u0019\n)\u0001E\u0002\u001f\u0003\u000fI1!!\u0003\u0005\u0005qYUOY3s]\u0016$Xm\u001d,pYVlWm\u00159fG&4\u0017nY\"p]\u001a\u0004")
public class MountVolumesFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Tuple2 tuple2 = this.constructVolumes(this.kubernetesConf.roleVolumes()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable volumeMounts = (Iterable)tuple2._1();
        Iterable volumes = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)volumeMounts, (Object)volumes);
        Tuple2 tuple23 = tuple22;
        Iterable volumeMounts2 = (Iterable)tuple23._1();
        Iterable volumes2 = (Iterable)tuple23._2();
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editSpec().addToVolumes((Volume[])volumes2.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        Container containerWithVolumeMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])volumeMounts2.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithVolumeMounts);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Iterable<Tuple2<VolumeMount, Volume>> constructVolumes(Iterable<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>> volumeSpecs) {
        return (Iterable)volumeSpecs.map((Function1 & Serializable & scala.Serializable)spec -> {
            VolumeBuilder volumeBuilder;
            VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withMountPath(spec.mountPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly()))).withName(spec.volumeName())).build();
            Object t = spec.volumeConf();
            if (t instanceof KubernetesHostPathVolumeConf) {
                KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)t;
                String hostPath = kubernetesHostPathVolumeConf.hostPath();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withHostPath(new HostPathVolumeSource(hostPath));
            } else if (t instanceof KubernetesPVCVolumeConf) {
                KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)t;
                String claimName = kubernetesPVCVolumeConf.claimName();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly())));
            } else if (t instanceof KubernetesEmptyDirVolumeConf) {
                KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)t;
                Option<String> medium = kubernetesEmptyDirVolumeConf.medium();
                Option<String> sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withEmptyDir(new EmptyDirVolumeSource((String)medium.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), new Quantity((String)sizeLimit.orNull(Predef$.MODULE$.$conforms()))));
            } else {
                throw new MatchError(t);
            }
            VolumeBuilder volumeBuilder2 = volumeBuilder;
            Volume volume = ((VolumeBuilder)volumeBuilder2.withName(spec.volumeName())).build();
            return new Tuple2((Object)volumeMount, (Object)volume);
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public MountVolumesFeatureStep(KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

