/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.spark_project.guava.io.BaseEncoding;
import org.spark_project.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0001!q!A\n#sSZ,'oS;cKJtW\r^3t\u0007J,G-\u001a8uS\u0006d7OR3biV\u0014Xm\u0015;fa*\u00111\u0001B\u0001\tM\u0016\fG/\u001e:fg*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u0019!W\r\u001d7ps*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005mYUOY3s]\u0016$Xm\u001d$fCR,(/Z\"p]\u001aLwm\u0015;fa\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\blk\n,'O\\3uKN\u001cuN\u001c4\u0004\u0001A\u0012Qd\t\t\u0004=}\tS\"\u0001\u0003\n\u0005\u0001\"!AD&vE\u0016\u0014h.\u001a;fg\u000e{gN\u001a\t\u0003E\rb\u0001\u0001B\u0005%3\u0005\u0005\t\u0011!B\u0001K\t\u0019q\fJ\u0019\u0012\u0005\u0019J\u0003C\u0001\t(\u0013\tA\u0013CA\u0004O_RD\u0017N\\4\u0011\u0005AQ\u0013BA\u0016\u0012\u0005\r\te.\u001f\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0002\u0004C\u0001\f\u0001\u0011\u0015QB\u00061\u00012a\t\u0011D\u0007E\u0002\u001f?M\u0002\"A\t\u001b\u0005\u0013\u0011\u0002\u0014\u0011!A\u0001\u0006\u0003)\u0003b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u001b[\u0006L(-Z'pk:$X\rZ(BkRDGk\\6f]\u001aKG.Z\u000b\u0002qA\u0019\u0001#O\u001e\n\u0005i\n\"AB(qi&|g\u000e\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}Ei\u0011a\u0010\u0006\u0003\u0001n\ta\u0001\u0010:p_Rt\u0014B\u0001\"\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u000b\u0002BB$\u0001A\u0003%\u0001(A\u000enCf\u0014W-T8v]R,GmT!vi\"$vn[3o\r&dW\r\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u00038\u0003ei\u0017-\u001f2f\u001b>,h\u000e^3e\u00072LWM\u001c;LKf4\u0015\u000e\\3\t\r-\u0003\u0001\u0015!\u00039\u0003ii\u0017-\u001f2f\u001b>,h\u000e^3e\u00072LWM\u001c;LKf4\u0015\u000e\\3!\u0011\u001di\u0005A1A\u0005\n]\n!$\\1zE\u0016lu.\u001e8uK\u0012\u001cE.[3oi\u000e+'\u000f\u001e$jY\u0016Daa\u0014\u0001!\u0002\u0013A\u0014aG7bs\n,Wj\\;oi\u0016$7\t\\5f]R\u001cUM\u001d;GS2,\u0007\u0005C\u0004R\u0001\t\u0007I\u0011B\u001c\u0002-5\f\u0017PY3N_VtG/\u001a3DC\u000e+'\u000f\u001e$jY\u0016Daa\u0015\u0001!\u0002\u0013A\u0014aF7bs\n,Wj\\;oi\u0016$7)Y\"feR4\u0015\u000e\\3!\u0011\u001d)\u0006A1A\u0005\n]\nA\u0003\u001a:jm\u0016\u00148+\u001a:wS\u000e,\u0017iY2pk:$\bBB,\u0001A\u0003%\u0001(A\u000bee&4XM]*feZL7-Z!dG>,h\u000e\u001e\u0011\t\u000fe\u0003!\u0019!C\u00055\u0006\u0001r.Y;uQR{7.\u001a8CCN,g\u0007N\u000b\u00027B\u0019\u0001#\u000f/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002E=\"1A\r\u0001Q\u0001\nm\u000b\u0011c\\1vi\"$vn[3o\u0005\u0006\u001cXM\u000e\u001b!\u0011\u001d1\u0007A1A\u0005\n]\n\u0001cY1DKJ$H)\u0019;b\u0005\u0006\u001cXM\u000e\u001b\t\r!\u0004\u0001\u0015!\u00039\u0003E\u0019\u0017mQ3si\u0012\u000bG/\u0019\"bg\u00164D\u0007\t\u0005\bU\u0002\u0011\r\u0011\"\u00038\u0003M\u0019G.[3oi.+\u0017\u0010R1uC\n\u000b7/\u001a\u001c5\u0011\u0019a\u0007\u0001)A\u0005q\u0005!2\r\\5f]R\\U-\u001f#bi\u0006\u0014\u0015m]37i\u0001BqA\u001c\u0001C\u0002\u0013%q'\u0001\u000bdY&,g\u000e^\"feR$\u0015\r^1CCN,g\u0007\u000e\u0005\u0007a\u0002\u0001\u000b\u0011\u0002\u001d\u0002+\rd\u0017.\u001a8u\u0007\u0016\u0014H\u000fR1uC\n\u000b7/\u001a\u001c5A!9!\u000f\u0001b\u0001\n\u0013\u0019\u0018!E:i_VdG-T8v]R\u001cVm\u0019:fiV\tA\u000f\u0005\u0002\u0011k&\u0011a/\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019A\b\u0001)A\u0005i\u0006\u00112\u000f[8vY\u0012lu.\u001e8u'\u0016\u001c'/\u001a;!\u0011\u001dQ\bA1A\u0005\nm\f1\u0004\u001a:jm\u0016\u00148I]3eK:$\u0018.\u00197t'\u0016\u001c'/\u001a;OC6,W#A\u001e\t\ru\u0004\u0001\u0015!\u0003<\u0003q!'/\u001b<fe\u000e\u0013X\rZ3oi&\fGn]*fGJ,GOT1nK\u0002Baa \u0001\u0005B\u0005\u0005\u0011\u0001D2p]\u001aLw-\u001e:f!>$G\u0003BA\u0002\u0003\u0013\u00012AHA\u0003\u0013\r\t9\u0001\u0002\u0002\t'B\f'o\u001b)pI\"9\u00111\u0002@A\u0002\u0005\r\u0011a\u00019pI\"9\u0011q\u0002\u0001\u0005B\u0005E\u0011\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\"!a\u0005\u0011\u000bq\n)bO\u001e\n\u0007\u0005]QIA\u0002NCBDq!a\u0007\u0001\t\u0003\ni\"\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\\&vE\u0016\u0014h.\u001a;fgJ+7o\\;sG\u0016\u001cHCAA\u0010!\u0019\t\t#a\u000b\u000229!\u00111EA\u0014\u001d\rq\u0014QE\u0005\u0002%%\u0019\u0011\u0011F\t\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005\r\u0019V-\u001d\u0006\u0004\u0003S\t\u0002\u0003BA\u001a\u0003\u0013j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003w\ti$A\u0002ba&TA!a\u0010\u0002B\u0005Q1.\u001e2fe:,G/Z:\u000b\t\u0005\r\u0013QI\u0001\bM\u0006\u0014'/[29\u0015\t\t9%\u0001\u0002j_&!\u00111JA\u001b\u0005-A\u0015m]'fi\u0006$\u0017\r^1\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R\u0005!2/\u00194f\r&dWmQ8oMR{')Y:fmQ\"R\u0001OA*\u0003/Bq!!\u0016\u0002N\u0001\u00071(\u0001\u0003d_:4\u0007bBA-\u0003\u001b\u0002\raO\u0001\tM&dW\rV=qK\"9\u0011Q\f\u0001\u0005\n\u0005}\u0013!\u0005:fg>dg/Z*fGJ,G\u000fR1uCR1\u00111CA1\u0003KBq!a\u0019\u0002\\\u0001\u0007\u0001(A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ\"sK\u0012,g\u000e^5bY\"9\u0011qMA.\u0001\u0004Y\u0014AC:fGJ,GOT1nK\"9\u00111\u000e\u0001\u0005\n\u00055\u0014!\u0006:fg>dg/Z*fGJ,G\u000fT8dCRLwN\u001c\u000b\bq\u0005=\u00141OA<\u0011\u001d\t\t(!\u001bA\u0002a\nA#\\8v]R,G-V:feN\u0003XmY5gS\u0016$\u0007bBA;\u0003S\u0002\r\u0001O\u0001\u001am\u0006dW/Z'pk:$X\r\u001a$s_6\u001cVOY7jiR,'\u000fC\u0004\u0002z\u0005%\u0004\u0019A\u001e\u000215|WO\u001c;fI\u000e\u000bgn\u001c8jG\u0006dGj\\2bi&|g\u000eC\u0004\u0002~\u0001!I!a \u0002/\r\u0014X-\u0019;f\u0007J,G-\u001a8uS\u0006d7oU3de\u0016$HCAAA!\u0011\t\u0019$a!\n\t\u0005\u0015\u0015Q\u0007\u0002\u0007'\u0016\u001c'/\u001a;")
public class DriverKubernetesCredentialsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<?> kubernetesConf;
    private final Option<String> maybeMountedOAuthTokenFile;
    private final Option<String> maybeMountedClientKeyFile;
    private final Option<String> maybeMountedClientCertFile;
    private final Option<String> maybeMountedCaCertFile;
    private final Option<String> driverServiceAccount;
    private final Option<String> oauthTokenBase64;
    private final Option<String> caCertDataBase64;
    private final Option<String> clientKeyDataBase64;
    private final Option<String> clientCertDataBase64;
    private final boolean shouldMountSecret;
    private final String driverCredentialsSecretName;

    private Option<String> maybeMountedOAuthTokenFile() {
        return this.maybeMountedOAuthTokenFile;
    }

    private Option<String> maybeMountedClientKeyFile() {
        return this.maybeMountedClientKeyFile;
    }

    private Option<String> maybeMountedClientCertFile() {
        return this.maybeMountedClientCertFile;
    }

    private Option<String> maybeMountedCaCertFile() {
        return this.maybeMountedCaCertFile;
    }

    private Option<String> driverServiceAccount() {
        return this.driverServiceAccount;
    }

    private Option<String> oauthTokenBase64() {
        return this.oauthTokenBase64;
    }

    private Option<String> caCertDataBase64() {
        return this.caCertDataBase64;
    }

    private Option<String> clientKeyDataBase64() {
        return this.clientKeyDataBase64;
    }

    private Option<String> clientCertDataBase64() {
        return this.clientCertDataBase64;
    }

    private boolean shouldMountSecret() {
        return this.shouldMountSecret;
    }

    private String driverCredentialsSecretName() {
        return this.driverCredentialsSecretName;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        SparkPod sparkPod;
        if (!this.shouldMountSecret()) {
            sparkPod = pod.copy((Pod)this.driverServiceAccount().map((Function1 & Serializable & scala.Serializable)account -> ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editOrNewSpec().withServiceAccount(account).withServiceAccountName(account)).endSpec()).build()).getOrElse((Function0 & Serializable & scala.Serializable)() -> pod.pod()), pod.copy$default$2());
        } else {
            Pod driverPodWithMountedKubernetesCredentials = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)new PodBuilder(pod.pod()).editOrNewSpec().addNewVolume().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withNewSecret().withSecretName(this.driverCredentialsSecretName())).endSecret()).endVolume()).endSpec()).build();
            Container driverContainerWithMountedSecretVolume = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(pod.container()).addNewVolumeMount().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withMountPath(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRETS_BASE_DIR())).endVolumeMount()).build();
            sparkPod = new SparkPod(driverPodWithMountedKubernetesCredentials, driverContainerWithMountedSecretVolume);
        }
        return sparkPod;
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        Option<String> resolvedMountedOAuthTokenFile = this.resolveSecretLocation(this.maybeMountedOAuthTokenFile(), this.oauthTokenBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_PATH());
        Option<String> resolvedMountedClientKeyFile = this.resolveSecretLocation(this.maybeMountedClientKeyFile(), this.clientKeyDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_PATH());
        Option<String> resolvedMountedClientCertFile = this.resolveSecretLocation(this.maybeMountedClientCertFile(), this.clientCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_PATH());
        Option<String> resolvedMountedCaCertFile = this.resolveSecretLocation(this.maybeMountedCaCertFile(), this.caCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_PATH());
        scala.collection.immutable.Map redactedTokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.kubernetesConf.sparkConf().getAll())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DriverKubernetesCredentialsFeatureStep.$anonfun$getAdditionalPodSystemProperties$1(x$1))))).toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> "<present_but_redacted>");
        return redactedTokens.$plus$plus((GenTraversableOnce)resolvedMountedCaCertFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)resolvedMountedClientKeyFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)resolvedMountedClientCertFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)resolvedMountedOAuthTokenFile.map((Function1 & Serializable & scala.Serializable)file -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString()), file)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return this.shouldMountSecret() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Secret[]{this.createCredentialsSecret()})) : (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> safeFileConfToBase64(String conf, String fileType) {
        return this.kubernetesConf.getOption(conf).map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3)).map((Function1 & Serializable & scala.Serializable)file -> {
            Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> String.format("%s provided at %s does not exist or is not a file.", fileType, file.getAbsolutePath()));
            return BaseEncoding.base64().encode(Files.toByteArray((File)file));
        });
    }

    private scala.collection.immutable.Map<String, String> resolveSecretData(Option<String> userSpecifiedCredential, String secretName) {
        return (scala.collection.immutable.Map)userSpecifiedCredential.map((Function1 & Serializable & scala.Serializable)valueBase64 -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)secretName), valueBase64)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private Option<String> resolveSecretLocation(Option<String> mountedUserSpecified, Option<String> valueMountedFromSubmitter, String mountedCanonicalLocation) {
        return mountedUserSpecified.orElse((Function0 & Serializable & scala.Serializable)() -> valueMountedFromSubmitter.map((Function1 & Serializable & scala.Serializable)x$4 -> mountedCanonicalLocation));
    }

    private Secret createCredentialsSecret() {
        scala.collection.immutable.Map allSecretData = this.resolveSecretData(this.clientKeyDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_SECRET_NAME()).$plus$plus(this.resolveSecretData(this.clientCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(this.caCertDataBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(this.oauthTokenBase64(), Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_SECRET_NAME()));
        return ((SecretBuilder)((SecretFluentImpl)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(this.driverCredentialsSecretName())).endMetadata()).withData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)allSecretData).asJava())).build();
    }

    public static final /* synthetic */ boolean $anonfun$getAdditionalPodSystemProperties$1(Tuple2 x$1) {
        return ((String)x$1._1()).endsWith(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX());
    }

    public DriverKubernetesCredentialsFeatureStep(KubernetesConf<?> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
        this.maybeMountedOAuthTokenFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString());
        this.maybeMountedClientKeyFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString());
        this.maybeMountedClientCertFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString());
        this.maybeMountedCaCertFile = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString());
        this.driverServiceAccount = (Option)kubernetesConf.get((ConfigEntry<?>)Config$.MODULE$.KUBERNETES_SERVICE_ACCOUNT_NAME());
        this.oauthTokenBase64 = kubernetesConf.getOption(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()).toString()).map((Function1 & Serializable & scala.Serializable)token -> BaseEncoding.base64().encode(token.getBytes(StandardCharsets.UTF_8)));
        this.caCertDataBase64 = this.safeFileConfToBase64(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString(), "Driver CA cert file");
        this.clientKeyDataBase64 = this.safeFileConfToBase64(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString(), "Driver client key file");
        this.clientCertDataBase64 = this.safeFileConfToBase64(new StringBuilder(1).append(Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString(), "Driver client cert file");
        this.shouldMountSecret = this.oauthTokenBase64().isDefined() || this.caCertDataBase64().isDefined() || this.clientKeyDataBase64().isDefined() || this.clientCertDataBase64().isDefined();
        this.driverCredentialsSecretName = new StringBuilder(23).append(kubernetesConf.appResourceNamePrefix()).append("-kubernetes-credentials").toString();
    }
}

