/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u0001\u0003\u0001!q!\u0001\u0007\"bg&\u001cW\t_3dkR|'OR3biV\u0014Xm\u0015;fa*\u00111\u0001B\u0001\tM\u0016\fG/\u001e:fg*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u0019!W\r\u001d7ps*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005mYUOY3s]\u0016$Xm\u001d$fCR,(/Z\"p]\u001aLwm\u0015;fa\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\blk\n,'O\\3uKN\u001cuN\u001c4\u0004\u0001A\u0019QD\b\u0011\u000e\u0003\u0011I!a\b\u0003\u0003\u001d-+(-\u001a:oKR,7oQ8oMB\u0011Q$I\u0005\u0003E\u0011\u0011adS;cKJtW\r^3t\u000bb,7-\u001e;peN\u0003XmY5gS\u000e\u001cuN\u001c4\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u0017\u0001!)!d\ta\u00019!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0013AF3yK\u000e,Ho\u001c:FqR\u0014\u0018m\u00117bgN\u0004\u0018\r\u001e5\u0016\u0003-\u00022\u0001\u0005\u0017/\u0013\ti\u0013C\u0001\u0004PaRLwN\u001c\t\u0003_Yr!\u0001\r\u001b\u0011\u0005E\nR\"\u0001\u001a\u000b\u0005MZ\u0012A\u0002\u001fs_>$h(\u0003\u00026#\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)\u0014\u0003\u0003\u0004;\u0001\u0001\u0006IaK\u0001\u0018Kb,7-\u001e;pe\u0016CHO]1DY\u0006\u001c8\u000f]1uQ\u0002Bq\u0001\u0010\u0001C\u0002\u0013%Q(\u0001\ffq\u0016\u001cW\u000f^8s\u0007>tG/Y5oKJLU.Y4f+\u0005q\u0003BB \u0001A\u0003%a&A\ffq\u0016\u001cW\u000f^8s\u0007>tG/Y5oKJLU.Y4fA!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0015\u0001\u00052m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:u+\u0005\u0019\u0005C\u0001\tE\u0013\t)\u0015CA\u0002J]RDaa\u0012\u0001!\u0002\u0013\u0019\u0015!\u00052m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:uA!9\u0011\n\u0001b\u0001\n\u0013i\u0014!F3yK\u000e,Ho\u001c:Q_\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002\u0018\u0002-\u0015DXmY;u_J\u0004v\u000e\u001a(b[\u0016\u0004&/\u001a4jq\u0002Bq!\u0014\u0001C\u0002\u0013%Q(A\u0005ee&4XM]+sY\"1q\n\u0001Q\u0001\n9\n!\u0002\u001a:jm\u0016\u0014XK\u001d7!\u0011\u001d\t\u0006A1A\u0005\nI\u000b\u0011#\u001a=fGV$xN]'f[>\u0014\u00180T5C+\u0005\u0019\u0006C\u0001\tU\u0013\t)\u0016C\u0001\u0003M_:<\u0007BB,\u0001A\u0003%1+\u0001\nfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=NS\n\u0003\u0003bB-\u0001\u0005\u0004%I!P\u0001\u0015Kb,7-\u001e;pe6+Wn\u001c:z'R\u0014\u0018N\\4\t\rm\u0003\u0001\u0015!\u0003/\u0003U)\u00070Z2vi>\u0014X*Z7pef\u001cFO]5oO\u0002Bq!\u0018\u0001C\u0002\u0013%!+A\tnK6|'/_(wKJDW-\u00193NS\nCaa\u0018\u0001!\u0002\u0013\u0019\u0016AE7f[>\u0014\u0018p\u0014<fe\",\u0017\rZ'j\u0005\u0002Bq!\u0019\u0001C\u0002\u0013%!+\u0001\u000efq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=XSRDwJ^3sQ\u0016\fG\r\u0003\u0004d\u0001\u0001\u0006IaU\u0001\u001cKb,7-\u001e;pe6+Wn\u001c:z/&$\bn\u0014<fe\",\u0017\r\u001a\u0011\t\u000f\u0015\u0004!\u0019!C\u0005%\u0006\u0019R\r_3dkR|'/T3n_JLHk\u001c;bY\"1q\r\u0001Q\u0001\nM\u000bA#\u001a=fGV$xN]'f[>\u0014\u0018\u0010V8uC2\u0004\u0003bB5\u0001\u0005\u0004%IAQ\u0001\u000eKb,7-\u001e;pe\u000e{'/Z:\t\r-\u0004\u0001\u0015!\u0003D\u00039)\u00070Z2vi>\u00148i\u001c:fg\u0002Bq!\u001c\u0001C\u0002\u0013%Q(\u0001\u000bfq\u0016\u001cW\u000f^8s\u0007>\u0014Xm\u001d*fcV,7\u000f\u001e\u0005\u0007_\u0002\u0001\u000b\u0011\u0002\u0018\u0002+\u0015DXmY;u_J\u001cuN]3t%\u0016\fX/Z:uA!9\u0011\u000f\u0001b\u0001\n\u0013Q\u0013AE3yK\u000e,Ho\u001c:MS6LGoQ8sKNDaa\u001d\u0001!\u0002\u0013Y\u0013aE3yK\u000e,Ho\u001c:MS6LGoQ8sKN\u0004\u0003\"B;\u0001\t\u00032\u0018\u0001D2p]\u001aLw-\u001e:f!>$GCA<{!\ti\u00020\u0003\u0002z\t\tA1\u000b]1sWB{G\rC\u0003|i\u0002\u0007q/A\u0002q_\u0012DQ! \u0001\u0005By\f\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d\u0007k\u001c3TsN$X-\u001c)s_B,'\u000f^5fgR\tq\u0010E\u00030\u0003\u0003qc&C\u0002\u0002\u0004a\u00121!T1q\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\t\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d7*\u001e2fe:,G/Z:SKN|WO]2fgR\u0011\u00111\u0002\t\u0007\u0003\u001b\t9\"!\b\u000f\t\u0005=\u00111\u0003\b\u0004c\u0005E\u0011\"\u0001\n\n\u0007\u0005U\u0011#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00111\u0004\u0002\u0004'\u0016\f(bAA\u000b#A!\u0011qDA\u001b\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!B7pI\u0016d'\u0002BA\u0014\u0003S\t1!\u00199j\u0015\u0011\tY#!\f\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0003\u00020\u0005E\u0012a\u00024bEJL7\r\u000f\u0006\u0003\u0003g\t!![8\n\t\u0005]\u0012\u0011\u0005\u0002\f\u0011\u0006\u001cX*\u001a;bI\u0006$\u0018\r")
public class BasicExecutorFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<KubernetesExecutorSpecificConf> kubernetesConf;
    private final Option<String> executorExtraClasspath;
    private final String executorContainerImage;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final String driverUrl;
    private final long executorMemoryMiB;
    private final String executorMemoryString;
    private final long memoryOverheadMiB;
    private final long executorMemoryWithOverhead;
    private final long executorMemoryTotal;
    private final int executorCores;
    private final String executorCoresRequest;
    private final Option<String> executorLimitCores;

    private Option<String> executorExtraClasspath() {
        return this.executorExtraClasspath;
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    private String driverUrl() {
        return this.driverUrl;
    }

    private long executorMemoryMiB() {
        return this.executorMemoryMiB;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long executorMemoryWithOverhead() {
        return this.executorMemoryWithOverhead;
    }

    private long executorMemoryTotal() {
        return this.executorMemoryTotal;
    }

    private int executorCores() {
        return this.executorCores;
    }

    private String executorCoresRequest() {
        return this.executorCoresRequest;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    @Override
    public SparkPod configurePod(SparkPod pod2) {
        String name = new StringBuilder(6).append(this.executorPodNamePrefix()).append("-exec-").append(this.kubernetesConf.roleSpecificConf().executorId()).toString();
        String hostname = name.substring(Math.max(0, name.length() - 63));
        Quantity executorMemoryQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringBuilder(2).append(this.executorMemoryTotal()).append("Mi").toString())).build();
        Quantity executorCpuQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(this.executorCoresRequest())).build();
        Option executorExtraClasspathEnv = this.executorExtraClasspath().map((Function1 & Serializable & scala.Serializable)cp -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_CLASSPATH())).withValue(cp)).build());
        Seq executorExtraJavaOptionsEnv = (Seq)((Option)this.kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).map((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpts = Utils$.MODULE$.substituteAppNExecIds(opts, $this.kubernetesConf.appId(), $this.kubernetesConf.roleSpecificConf().executorId());
            Seq delimitedOpts = Utils$.MODULE$.splitCommandString(subsOpts);
            return (Seq)((TraversableLike)delimitedOpts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String opt = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(index).toString())).withValue(opt)).build();
                return envVar;
            }, Seq$.MODULE$.canBuildFrom());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq executorEnv = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.ENV_DRIVER_URL(), (Object)this.driverUrl()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES(), (Object)((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY(), (Object)this.executorMemoryString()), new Tuple2((Object)Constants$.MODULE$.ENV_APPLICATION_ID(), (Object)this.kubernetesConf.appId()), new Tuple2((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR(), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_ID(), (Object)this.kubernetesConf.roleSpecificConf().executorId())}))).$plus$plus(this.kubernetesConf.roleEnvs(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)env -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_EXECUTOR_POD_IP())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).build()})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)executorExtraJavaOptionsEnv, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(executorExtraClasspathEnv).toSeq(), Seq$.MODULE$.canBuildFrom());
        Seq requiredPorts = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort()))}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
            return containerPort;
        }, Seq$.MODULE$.canBuildFrom());
        Container executorContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod2.container()).withName("executor")).withImage(this.executorContainerImage())).withImagePullPolicy(this.kubernetesConf.imagePullPolicy())).withNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryQuantity).addToRequests("cpu", executorCpuQuantity)).endResources()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(executorEnv).asJava())).withPorts((List)JavaConverters$.MODULE$.seqAsJavaListConverter(requiredPorts).asJava())).addToArgs(new String[]{"executor"})).build();
        Container containerWithLimitCores = (Container)this.executorLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> {
            Quantity executorCpuLimitQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(limitCores)).build();
            return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(executorContainer).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> executorContainer);
        Option<Pod> driverPod = this.kubernetesConf.roleSpecificConf().driverPod();
        Option ownerReference = driverPod.map((Function1 & Serializable & scala.Serializable)pod -> ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withController(Predef$.MODULE$.boolean2Boolean(true))).withApiVersion(pod.getApiVersion())).withKind(pod.getKind())).withName(pod.getMetadata().getName())).withUid(pod.getMetadata().getUid())).build());
        Pod executorPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod2.pod()).editOrNewMetadata().withName(name).withLabels((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.roleLabels()).asJava()).withAnnotations((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.roleAnnotations()).asJava()).addToOwnerReferences((OwnerReference[])Option$.MODULE$.option2Iterable(ownerReference).toSeq().toArray(ClassTag$.MODULE$.apply(OwnerReference.class)))).endMetadata()).editOrNewSpec().withHostname(hostname).withRestartPolicy("Never").withNodeSelector((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.kubernetesConf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        return new SparkPod(executorPod, containerWithLimitCores);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static final /* synthetic */ long $anonfun$executorMemoryTotal$1(BasicExecutorFeatureStep $this, String res) {
        String string = res;
        int n = "python".equals(string) ? BoxesRunTime.unboxToInt((Object)((Option)$this.kubernetesConf.sparkConf().get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PYSPARK_EXECUTOR_MEMORY())).map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$1 -> (int)x$1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) : 0;
        int additionalPySparkMemory = n;
        return $this.executorMemoryWithOverhead() + (long)additionalPySparkMemory;
    }

    public BasicExecutorFeatureStep(KubernetesConf<KubernetesExecutorSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
        this.executorExtraClasspath = (Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CLASS_PATH());
        this.executorContainerImage = (String)kubernetesConf.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the executor container image");
        });
        this.blockManagerPort = kubernetesConf.sparkConf().getInt("spark.blockmanager.port", Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        this.executorPodNamePrefix = kubernetesConf.appResourceNamePrefix();
        this.driverUrl = RpcEndpointAddress$.MODULE$.apply(kubernetesConf.get("spark.driver.host"), kubernetesConf.sparkConf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.executorMemoryMiB = BoxesRunTime.unboxToLong((Object)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        this.executorMemoryString = kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().defaultValueString());
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(BoxesRunTime.unboxToDouble((Object)$this.kubernetesConf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) * (double)this.executorMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.executorMemoryWithOverhead = this.executorMemoryMiB() + this.memoryOverheadMiB();
        this.executorMemoryTotal = BoxesRunTime.unboxToLong((Object)kubernetesConf.sparkConf().getOption(Config$.MODULE$.APP_RESOURCE_TYPE().key()).map((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToLong((long)BasicExecutorFeatureStep.$anonfun$executorMemoryTotal$1(this, res))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.executorMemoryWithOverhead()));
        this.executorCores = kubernetesConf.sparkConf().getInt("spark.executor.cores", 1);
        this.executorCoresRequest = kubernetesConf.sparkConf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES()) ? (String)((Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES())).get() : ((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString();
        this.executorLimitCores = (Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
    }
}

