/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc!\u0002\r\u001a\u0001m)\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b!\u0003A\u0011A%\t\u000f5\u0003!\u0019!C\u0005\u001d\"1q\u000b\u0001Q\u0001\n=Cq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004[\u0001\u0001\u0006I!\u0012\u0005\b7\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019a\u0006\u0001)A\u0005\u000b\"9Q\f\u0001b\u0001\n\u0013I\u0006B\u00020\u0001A\u0003%Q\tC\u0004`\u0001\t\u0007I\u0011B-\t\r\u0001\u0004\u0001\u0015!\u0003F\u0011\u001d\t\u0007A1A\u0005\neCaA\u0019\u0001!\u0002\u0013)\u0005bB2\u0001\u0005\u0004%I!\u0017\u0005\u0007I\u0002\u0001\u000b\u0011B#\t\u000b\u0015\u0004A\u0011\u00014\t\u000bq\u0004A\u0011B?\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\t\u0001\u0011%\u0011q\u0004\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\u00111\"\u00112ce\u00164\u0018.\u0019;pe*\u0011!dG\u0001\u0007G>lWn\u001c8\u000b\u0005qi\u0012aB2p]:,7\r\u001e\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7c\u0001\u0001'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u0004\"!\f\u001c\u000f\u00059\"dBA\u00184\u001b\u0005\u0001$BA\u00193\u0003\u0019a$o\\8u}\r\u0001\u0011\"A\u0015\n\u0005UB\u0013a\u00029bG.\fw-Z\u0005\u0003oa\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!!\u000e\u0015\u0002\u0015QD'/Z:i_2$7\u000f\u0005\u0003<\u007f\t+eB\u0001\u001f>!\ty\u0003&\u0003\u0002?Q\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\u00075\u000b\u0007O\u0003\u0002?QA\u00111hQ\u0005\u0003\t\u0006\u0013aa\u0015;sS:<\u0007CA\u0014G\u0013\t9\u0005FA\u0002J]R\fa\u0001P5oSRtDC\u0001&M!\tY\u0005!D\u0001\u001a\u0011\u0015I$\u00011\u0001;\u0003\u00191wN]7biV\tq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006!A/\u001a=u\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV)\u0003\u00199+XNY3s\r>\u0014X.\u0019;\u0002\u000f\u0019|'/\\1uA\u0005qQ*\u0011-`\u0005f#ViU0T\u0013j+U#A#\u0002\u001f5\u000b\u0005l\u0018\"Z)\u0016\u001bvlU%[\u000b\u0002\nq\"T!Y?N#&+\u0013(H?NK%,R\u0001\u0011\u001b\u0006Cvl\u0015+S\u0013:;ulU%[\u000b\u0002\n\u0011\"T!Y?2+e+\u0012'\u0002\u00155\u000b\u0005l\u0018'F-\u0016c\u0005%A\u0007nCb\u001cFO]5oONK'0Z\u0001\u000f[\u0006D8\u000b\u001e:j]\u001e\u001c\u0016N_3!\u00031i\u0017\r\u001f\"zi\u0016\u001c8+\u001b>f\u00035i\u0017\r\u001f\"zi\u0016\u001c8+\u001b>fA\u0005AQ.\u0019=MKZ,G.A\u0005nCbdUM^3mA\u0005Q\u0011M\u00192sKZL\u0017\r^3\u0016\u0005\u001dTGC\u00015{!\tI'\u000e\u0004\u0001\u0005\u000b-\f\"\u0019\u00017\u0003\u0003Q\u000b\"!\u001c9\u0011\u0005\u001dr\u0017BA8)\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u0011A\u0014x\u000e^8ck\u001aT!!\u001e<\u0002\r\u001d|wn\u001a7f\u0015\u00059\u0018aA2p[&\u0011\u0011P\u001d\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u0015Y\u0018\u00031\u0001i\u0003\u001diWm]:bO\u0016\f1#\u00192ce\u00164\u0018.\u0019;f%\u0016\u001cWO]:jm\u0016,2A`A\u0001)\u0015y\u00181AA\u0003!\rI\u0017\u0011\u0001\u0003\u0006WJ\u0011\r\u0001\u001c\u0005\u0006wJ\u0001\ra \u0005\u0007\u0003\u000f\u0011\u0002\u0019A#\u0002\u000b1,g/\u001a7\u0002\u001dQ\u0014XO\\2bi\u0016\u001cFO]5oOR\u0019!)!\u0004\t\r\u0005=1\u00031\u0001C\u0003\r\u0019HO]\u0001\u000eiJ,hnY1uK\nKH/Z:\u0015\t\u0005U\u00111\u0004\t\u0004c\u0006]\u0011bAA\re\nQ!)\u001f;f'R\u0014\u0018N\\4\t\u000f\u0005uA\u00031\u0001\u0002\u0016\u0005)!-\u001f;fgR!\u0011QCA\u0011\u0011\u001d\ti\"\u0006a\u0001\u0003G\u0001RaJA\u0013\u0003SI1!a\n)\u0005\u0015\t%O]1z!\r9\u00131F\u0005\u0004\u0003[A#\u0001\u0002\"zi\u0016\f\u0001CY=uKN#(/\u001b8h'V4g-\u001b=\u0015\t\u0005U\u00111\u0007\u0005\u0007\u0003k1\u0002\u0019A#\u0002\tML'0Z\u0001\u0010iJ,hnY1uK6+7o]1hKV!\u00111HA )\u0019\ti$!\u0011\u0002FA\u0019\u0011.a\u0010\u0005\u000b-<\"\u0019\u00017\t\u000f\u0005\rs\u00031\u0001\u0002>\u0005\u0019Qn]4\t\r\u0005\u001dq\u00031\u0001F\u0001")
public class Abbreviator
implements Serializable {
    private final NumberFormat format = NumberFormat.getInstance();
    private final int MAX_BYTES_SIZE;
    private final int MAX_STRING_SIZE;
    private final int MAX_LEVEL = Integer.MAX_VALUE;
    private final int maxStringSize;
    private final int maxBytesSize;
    private final int maxLevel;

    private NumberFormat format() {
        return this.format;
    }

    private int MAX_BYTES_SIZE() {
        return this.MAX_BYTES_SIZE;
    }

    private int MAX_STRING_SIZE() {
        return this.MAX_STRING_SIZE;
    }

    private int MAX_LEVEL() {
        return this.MAX_LEVEL;
    }

    private int maxStringSize() {
        return this.maxStringSize;
    }

    private int maxBytesSize() {
        return this.maxBytesSize;
    }

    private int maxLevel() {
        return this.maxLevel;
    }

    public <T extends Message> T abbreviate(T message) {
        return this.abbreviateRecursive(message, 0);
    }

    private <T extends Message> T abbreviateRecursive(T message, int level) {
        Message.Builder builder = message.toBuilder();
        CollectionConverters$.MODULE$.MapHasAsScala(message.getAllFields()).asScala().iterator().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object string = tuple2._2();
                if (string instanceof String) {
                    String string2 = (String)string;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType2 = Descriptors.FieldDescriptor.JavaType.STRING;
                    if (!(javaType != null ? !javaType.equals(javaType2) : javaType2 != null)) {
                        if (!field.isRepeated() && string2 != null && string2.length() > this.maxStringSize()) {
                            return builder.setField(field, (Object)this.truncateString(string2));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object strings = tuple2._2();
                if (strings instanceof List) {
                    List list = (List)strings;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType3 = Descriptors.FieldDescriptor.JavaType.STRING;
                    if (!(javaType != null ? !javaType.equals(javaType3) : javaType3 != null)) {
                        if (field.isRepeated() && list != null && !list.isEmpty()) {
                            CollectionConverters$.MODULE$.IteratorHasAsScala(list.iterator()).asScala().zipWithIndex().foreach((Function1 & Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String string;
                                    Object string2 = tuple2._1();
                                    int i = tuple2._2$mcI$sp();
                                    if (string2 instanceof String && (string = (String)string2) != null && string.length() > this.maxStringSize()) {
                                        return builder.setRepeatedField(field, i, (Object)this.truncateString(string));
                                    }
                                }
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object bytes = tuple2._2();
                if (bytes instanceof ByteString) {
                    ByteString byteString = (ByteString)bytes;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType4 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                    if (!(javaType != null ? !javaType.equals(javaType4) : javaType4 != null)) {
                        if (!field.isRepeated() && byteString != null && byteString.size() > this.maxBytesSize()) {
                            return builder.setField(field, (Object)this.truncateBytes(byteString));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object bytes = tuple2._2();
                if (bytes instanceof byte[]) {
                    byte[] byArray = (byte[])bytes;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType5 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                    if (!(javaType != null ? !javaType.equals(javaType5) : javaType5 != null)) {
                        if (!field.isRepeated() && byArray != null && byArray.length > this.maxBytesSize()) {
                            return builder.setField(field, (Object)this.truncateBytes(byArray));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object msg = tuple2._2();
                if (msg instanceof Message) {
                    Message message = (Message)msg;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType6 = Descriptors.FieldDescriptor.JavaType.MESSAGE;
                    if (!(javaType != null ? !javaType.equals(javaType6) : javaType6 != null)) {
                        if (!field.isRepeated() && message != null) {
                            return builder.setField(field, (Object)this.truncateMessage(message, level));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object msgs = tuple2._2();
                if (msgs instanceof List) {
                    List list = (List)msgs;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType7 = Descriptors.FieldDescriptor.JavaType.MESSAGE;
                    if (!(javaType != null ? !javaType.equals(javaType7) : javaType7 != null)) {
                        if (field.isRepeated() && list != null && !list.isEmpty()) {
                            CollectionConverters$.MODULE$.IteratorHasAsScala(list.iterator()).asScala().zipWithIndex().foreach((Function1 & Serializable)x0$3 -> {
                                Tuple2 tuple2 = x0$3;
                                if (tuple2 != null) {
                                    Message message;
                                    Object msg = tuple2._1();
                                    int i = tuple2._2$mcI$sp();
                                    if (msg instanceof Message && (message = (Message)msg) != null) {
                                        return builder.setRepeatedField(field, i, (Object)this.truncateMessage(message, level));
                                    }
                                }
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        }
                    }
                }
            }
            return BoxedUnit.UNIT;
        });
        return (T)builder.build();
    }

    private String truncateString(String str) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(str), this.maxStringSize()) + "[truncated(size=" + this.format().format(str.length()) + ")]";
    }

    private ByteString truncateBytes(ByteString bytes) {
        return bytes.substring(0, this.maxBytesSize()).concat(this.byteStringSuffix(bytes.size()));
    }

    private ByteString truncateBytes(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes, (int)0, (int)this.maxBytesSize()).concat(this.byteStringSuffix(bytes.length));
    }

    private ByteString byteStringSuffix(int size) {
        return ByteString.copyFromUtf8((String)("[truncated(size=" + this.format().format(size) + ")]"));
    }

    private <T extends Message> T truncateMessage(T msg, int level) {
        if (level == this.maxLevel()) {
            Message.Builder builder = msg.toBuilder();
            builder.clear();
            return (T)builder.buildPartial();
        }
        return this.abbreviateRecursive(msg, level + 1);
    }

    public Abbreviator(Map<String, Object> thresholds) {
        this.MAX_BYTES_SIZE = 8;
        this.MAX_STRING_SIZE = 1024;
        this.maxStringSize = BoxesRunTime.unboxToInt((Object)thresholds.getOrElse((Object)"STRING", (Function0)(JFunction0.mcI.sp & Serializable)() -> this.MAX_STRING_SIZE()));
        this.maxBytesSize = BoxesRunTime.unboxToInt((Object)thresholds.getOrElse((Object)"BYTES", (Function0)(JFunction0.mcI.sp & Serializable)() -> this.MAX_BYTES_SIZE()));
        this.maxLevel = BoxesRunTime.unboxToInt((Object)thresholds.getOrElse((Object)"MAX_LEVEL", (Function0)(JFunction0.mcI.sp & Serializable)() -> this.MAX_LEVEL()));
    }
}

