/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class GrpcRetryHandler$
implements Logging {
    public static final GrpcRetryHandler$ MODULE$ = new GrpcRetryHandler$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function1<Object, BoxedUnit> $lessinit$greater$default$2() {
        return (JFunction1.mcVJ.sp & Serializable)x$1 -> Thread.sleep(x$1);
    }

    public final <T> T retry(GrpcRetryHandler.RetryPolicy retryPolicy, Function1<Object, BoxedUnit> sleep, Function0<T> fn) {
        IntRef currentRetryNum = IntRef.create((int)0);
        Seq exceptionList = (Seq)package$.MODULE$.Seq().empty();
        FiniteDuration nextBackoff = retryPolicy.initialBackoff();
        if (retryPolicy.maxRetries() < 0) {
            throw new IllegalArgumentException("Can't have negative number of retries");
        }
        while (currentRetryNum.elem <= retryPolicy.maxRetries()) {
            if (currentRetryNum.elem != 0) {
                FiniteDuration currentBackoff = nextBackoff;
                nextBackoff = nextBackoff.$times(retryPolicy.backoffMultiplier()).min((Duration)retryPolicy.maxBackoff());
                if (currentBackoff.$greater$eq((Object)retryPolicy.minJitterThreshold())) {
                    currentBackoff = currentBackoff.$plus(package.DoubleMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.DoubleMult(Random$.MODULE$.nextDouble()), (Duration)retryPolicy.jitter()));
                }
                sleep.apply$mcVJ$sp(currentBackoff.toMillis());
            }
            try {
                return (T)fn.apply();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    if (BoxesRunTime.unboxToBoolean((Object)retryPolicy.canRetry().apply((Object)e)) && currentRetryNum.elem < retryPolicy.maxRetries()) {
                        BoxedUnit boxedUnit;
                        ++currentRetryNum.elem;
                        Throwable throwable3 = e;
                        exceptionList = (Seq)exceptionList.$plus$colon((Object)throwable3);
                        if (currentRetryNum.elem <= retryPolicy.maxRetries()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(40).append("Non-Fatal error during RPC execution: ").append(e).append(", ").toString()).append(new StringBuilder(27).append("retrying (currentRetryNum=").append(currentRetryNum$1.elem).append(")").toString()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(40).append("Non-Fatal error during RPC execution: ").append(e).append(", ").toString()).append(new StringBuilder(35).append("exceeded retries (currentRetryNum=").append(currentRetryNum$1.elem).append(")").toString()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        continue;
                    }
                }
                throw throwable;
            }
        }
        Throwable exception = (Throwable)exceptionList.head();
        ((IterableOnceOps)exceptionList.tail()).foreach((Function1 & Serializable)x$3 -> {
            exception.addSuppressed(x$3);
            return BoxedUnit.UNIT;
        });
        throw exception;
    }

    public final <T> Function1<Object, BoxedUnit> retry$default$2() {
        return (JFunction1.mcVJ.sp & Serializable)x$1 -> Thread.sleep(x$1);
    }

    public boolean retryException(Throwable e) {
        boolean bl;
        Throwable throwable = e;
        if (throwable instanceof StatusRuntimeException) {
            String msg;
            Status.Code statusCode;
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            Status.Code code = statusCode = statusRuntimeException.getStatus().getCode();
            Status.Code code2 = Status.Code.INTERNAL;
            if (!(code != null ? !code.equals(code2) : code2 != null) && (msg = statusRuntimeException.toString()).contains("INVALID_CURSOR.DISCONNECTED")) {
                return true;
            }
            Status.Code code3 = statusCode;
            Status.Code code4 = Status.Code.UNAVAILABLE;
            if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    private GrpcRetryHandler$() {
    }
}

