/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.test;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkBuildInfo$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.test.IntegrationTestUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

public final class SparkConnectServerUtils$ {
    public static final SparkConnectServerUtils$ MODULE$ = new SparkConnectServerUtils$();
    private static Process sparkConnect;
    private static final int port;
    private static volatile boolean stopped;
    private static OutputStream consoleOut;
    private static final String serverStopCommand;
    private static volatile boolean bitmap$0;

    static {
        port = ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT() + Random$.MODULE$.nextInt(1000);
        stopped = false;
        serverStopCommand = "q";
    }

    public int port() {
        return port;
    }

    private boolean stopped() {
        return stopped;
    }

    private void stopped_$eq(boolean x$1) {
        stopped = x$1;
    }

    private OutputStream consoleOut() {
        return consoleOut;
    }

    private void consoleOut_$eq(OutputStream x$1) {
        consoleOut = x$1;
    }

    private String serverStopCommand() {
        return serverStopCommand;
    }

    private Process sparkConnect$lzycompute() {
        SparkConnectServerUtils$ sparkConnectServerUtils$ = this;
        synchronized (sparkConnectServerUtils$) {
            if (!bitmap$0) {
                Object object;
                IntegrationTestUtils$.MODULE$.debug("Starting the Spark Connect Server...");
                String connectJar = IntegrationTestUtils$.MODULE$.findJar("connector/connect/server", "spark-connect-assembly", "spark-connect", IntegrationTestUtils$.MODULE$.findJar$default$4()).getCanonicalPath();
                Builder command = package$.MODULE$.Seq().newBuilder();
                command.$plus$eq((Object)"bin/spark-submit");
                command.$plus$eq((Object)"--driver-class-path").$plus$eq((Object)connectJar);
                command.$plus$eq((Object)"--class").$plus$eq((Object)"org.apache.spark.sql.connect.SimpleSparkConnectService");
                command.$plus$eq((Object)"--conf").$plus$eq((Object)new StringBuilder(32).append("spark.connect.grpc.binding.port=").append(this.port()).toString());
                command.$plus$plus$eq(this.testConfigs());
                command.$plus$plus$eq(IntegrationTestUtils$.MODULE$.debugConfigs());
                command.$plus$eq((Object)connectJar);
                ProcessBuilder builder = new ProcessBuilder((String[])((IterableOnceOps)command.result()).toArray(ClassTag$.MODULE$.apply(String.class)));
                builder.directory(new File(IntegrationTestUtils$.MODULE$.sparkHome()));
                Map<String, String> environment = builder.environment();
                environment.remove("SPARK_DIST_CLASSPATH");
                if (IntegrationTestUtils$.MODULE$.isDebug()) {
                    builder.redirectError(ProcessBuilder.Redirect.INHERIT);
                    object = builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                } else {
                    object = BoxedUnit.UNIT;
                }
                Process process = builder.start();
                this.consoleOut_$eq(process.getOutputStream());
                scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.stop());
                sparkConnect = process;
                bitmap$0 = true;
            }
        }
        return sparkConnect;
    }

    private Process sparkConnect() {
        return !bitmap$0 ? this.sparkConnect$lzycompute() : sparkConnect;
    }

    private Seq<String> testConfigs() {
        String string;
        String catalystTestJar = IntegrationTestUtils$.MODULE$.findJar("sql/catalyst", "spark-catalyst", "spark-catalyst", true).getCanonicalPath();
        if (IntegrationTestUtils$.MODULE$.isSparkHiveJarAvailable()) {
            string = "hive";
        } else {
            Predef$.MODULE$.println((Object)"Will start Spark Connect server with `spark.sql.catalogImplementation=in-memory`, some tests that rely on Hive will be ignored. If you don't want to skip them:\n1. Test with maven: run `build/mvn install -DskipTests -Phive` before testing\n2. Test with sbt: run test with `-Phive` profile");
            IntegrationTestUtils$.MODULE$.cleanUpHiveClassesDirIfNeeded();
            string = "in-memory";
        }
        String catalogImplementation = string;
        Seq confs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.catalog.testcat=org.apache.spark.sql.connector.catalog.InMemoryTableCatalog", new StringBuilder(32).append("spark.sql.catalogImplementation=").append(catalogImplementation).toString(), "spark.connect.execute.reattachable.senderMaxStreamDuration=1s", "spark.connect.execute.reattachable.senderMaxStreamSize=123", "spark.ui.enabled=false"}));
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--jars", catalystTestJar})).$plus$plus((IterableOnce)confs.flatMap((Function1 & Serializable)v -> {
            String string = v;
            return package$.MODULE$.Nil().$colon$colon((Object)string).$colon$colon((Object)"--conf");
        }));
    }

    public void start() {
        Predef$.MODULE$.assert(!this.stopped());
        this.sparkConnect();
    }

    /*
     * WARNING - void declaration
     */
    public int stop() {
        int n;
        this.stopped_$eq(true);
        IntegrationTestUtils$.MODULE$.debug("Stopping the Spark Connect Server...");
        try {
            void var2_1;
            this.consoleOut().write(this.serverStopCommand().getBytes());
            this.consoleOut().flush();
            this.consoleOut().close();
            Object object = !this.sparkConnect().waitFor(2L, TimeUnit.SECONDS) ? this.sparkConnect().destroyForcibly() : BoxedUnit.UNIT;
            int code = this.sparkConnect().exitValue();
            IntegrationTestUtils$.MODULE$.debug(new StringBuilder(48).append("Spark Connect Server is stopped with exit code: ").append(code).toString());
            n = var2_1;
        }
        catch (Throwable throwable) {
            IOException iOException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IOException) || !(iOException = (IOException)throwable2).getMessage().contains("Stream closed")) {
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    IntegrationTestUtils$.MODULE$.debug(throwable3);
                    this.sparkConnect().destroyForcibly();
                    throw throwable3;
                }
                throw throwable;
            }
            int n2 = -1;
            n = n2;
        }
        return n;
    }

    public void syncTestDependencies(SparkSession spark) {
        Path testClassesPath = Paths.get(IntegrationTestUtils$.MODULE$.connectClientTestClassDir(), new String[0]);
        spark.client().artifactManager().addClassDir(testClassesPath);
        URI[] jars = (URI[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(System.getProperty("java.class.path")), File.pathSeparatorChar)), (Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerUtils$.$anonfun$syncTestDependencies$1(e)))), (Function1 & Serializable)e -> Paths.get(e, new String[0]).toUri(), ClassTag$.MODULE$.apply(URI.class));
        spark.client().artifactManager().addArtifacts((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)jars));
    }

    /*
     * WARNING - void declaration
     */
    public SparkSession createSparkSession() {
        void var1_8;
        this.start();
        int x$1 = 7;
        FiniteDuration x$2 = FiniteDuration$.MODULE$.apply(10L, "s");
        FiniteDuration x$3 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2();
        double x$4 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4();
        FiniteDuration x$5 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5();
        FiniteDuration x$6 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6();
        Function1 x$7 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7();
        SparkSession spark = SparkSession$.MODULE$.builder().client(SparkConnectClient$.MODULE$.builder().userId("test").port(this.port()).retryPolicy(new GrpcRetryHandler.RetryPolicy(7, x$3, x$2, x$4, x$5, x$6, x$7)).build()).create();
        String string = spark.version();
        String string2 = SparkBuildInfo$.MODULE$.spark_version();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        this.syncTestDependencies(spark);
        return var1_8;
    }

    public static final /* synthetic */ boolean $anonfun$syncTestDependencies$1(String e) {
        String fileName = e.substring(e.lastIndexOf(File.separatorChar) + 1);
        return fileName.endsWith(".jar") && (fileName.startsWith("scalatest") || fileName.startsWith("scalactic"));
    }

    private SparkConnectServerUtils$() {
    }
}

