/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.ClientStreamingQuerySuite$;
import org.apache.spark.sql.streaming.EventCollector;
import org.apache.spark.sql.streaming.ForeachBatchFn;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.TestForeachWriter;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.test.QueryTest;
import org.apache.spark.sql.test.SQLHelper;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Futures$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.SpanSugar$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t2AAA\u0002\u0001\u001d!)a\u0004\u0001C\u0001?\tI2\t\\5f]R\u001cFO]3b[&tw-U;fef\u001cV/\u001b;f\u0015\t!Q!A\u0005tiJ,\u0017-\\5oO*\u0011aaB\u0001\u0004gFd'B\u0001\u0005\n\u0003\u0015\u0019\b/\u0019:l\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M!\u0001aD\u000b\u0019!\t\u00012#D\u0001\u0012\u0015\t\u0011R!\u0001\u0003uKN$\u0018B\u0001\u000b\u0012\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u0011-%\u0011q#\u0005\u0002\n'Fc\u0005*\u001a7qKJ\u0004\"!\u0007\u000f\u000e\u0003iQ!aG\u0004\u0002\u0011%tG/\u001a:oC2L!!\b\u000e\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011a\u0001")
public class ClientStreamingQuerySuite
extends QueryTest
implements SQLHelper,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLHelper.withTempDatabase$(this, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLHelper.withTable$(this, tableNames, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public static final /* synthetic */ void $anonfun$new$7(ClientStreamingQuerySuite $this, File ckpt) {
        StreamingQuery q1 = $this.spark().readStream().format("rate").load().writeStream().option("checkpointLocation", ckpt.getCanonicalPath()).toTable("my_table");
        StreamingQuery q2 = $this.spark().readStream().table("my_table").writeStream().format("memory").queryName("my_sink").start();
        try {
            q1.processAllAvailable();
            q2.processAllAvailable();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                long $org_scalatest_assert_macro_left = $this.spark().table("my_sink").count();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }
        finally {
            q1.stop();
            q2.stop();
            $this.spark().sql("DROP TABLE my_table");
        }
    }

    public ClientStreamingQuerySuite() {
        SQLHelper.$init$(this);
        Logging.$init$((Logging)this);
        this.test("Streaming API with windowed aggregate query", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.shuffle.partitions"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset readDF = this.spark().readStream().format("rate").option("rowsPerSecond", "10").option("numPartitions", "1").load();
            String $org_scalatest_assert_macro_left = readDF.schema().toDDL();
            String $org_scalatest_assert_macro_right = "timestamp TIMESTAMP,value BIGINT";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Dataset countsDF = readDF.withWatermark("timestamp", "10 seconds").groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.window(functions$.MODULE$.col("timestamp"), "5 seconds")})).count().selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"window.start as timestamp", "count as num_events"}));
            String $org_scalatest_assert_macro_left2 = countsDF.schema().toDDL();
            String $org_scalatest_assert_macro_right2 = "timestamp TIMESTAMP,num_events BIGINT NOT NULL";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            String queryName = "sparkConnectStreamingQuery";
            StreamingQuery query = countsDF.writeStream().format("memory").queryName(queryName).trigger(Trigger.ProcessingTime((String)"1 second")).start();
            try {
                StreamingQueryProgress lastProgress;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.status().isDataAvailable(), "query.status.isDataAvailable", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                    Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])query.recentProgress());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                StreamingQueryProgress $org_scalatest_assert_macro_left3 = lastProgress = query.lastProgress();
                Object $org_scalatest_assert_macro_right3 = null;
                StreamingQueryProgress streamingQueryProgress = $org_scalatest_assert_macro_left3;
                Object var18_17 = null;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, streamingQueryProgress == null ? var18_17 != null : !streamingQueryProgress.equals(var18_17), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                String $org_scalatest_assert_macro_left4 = lastProgress.name();
                String $org_scalatest_assert_macro_right4 = queryName;
                String string5 = $org_scalatest_assert_macro_left4;
                String string6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                Map $org_scalatest_assert_macro_left5 = lastProgress.durationMs();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                Map $org_scalatest_assert_macro_left6 = lastProgress.eventTime();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                Object $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])lastProgress.stateOperators());
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left7), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                Set $org_scalatest_assert_macro_left8 = (Set)JavaConverters$.MODULE$.asScalaSetConverter(((StateOperatorProgress)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])lastProgress.stateOperators()))).customMetrics().keySet()).asScala();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right5 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"loadedMapCacheHitCount", "loadedMapCacheMissCount", "stateOnCurrentVersionSizeBytes"}));
                Set set = $org_scalatest_assert_macro_left8;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right5, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
                Object $org_scalatest_assert_macro_left9 = Predef$.MODULE$.refArrayOps((Object[])lastProgress.sources());
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left9), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left9), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
                String $org_scalatest_assert_macro_left10 = lastProgress.sink().description();
                String $org_scalatest_assert_macro_right6 = "MemorySink";
                String string7 = $org_scalatest_assert_macro_left10;
                String string8 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                Map $org_scalatest_assert_macro_left11 = lastProgress.observedMetrics();
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> {
                    UUID $org_scalatest_assert_macro_left = p.id();
                    UUID $org_scalatest_assert_macro_right = lastProgress.id();
                    UUID uUID = $org_scalatest_assert_macro_left;
                    UUID uUID2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                    UUID $org_scalatest_assert_macro_left2 = p.runId();
                    UUID $org_scalatest_assert_macro_right2 = lastProgress.runId();
                    UUID uUID3 = $org_scalatest_assert_macro_left2;
                    UUID uUID4 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(uUID3 != null ? !((Object)uUID3).equals(uUID4) : uUID4 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
                    String $org_scalatest_assert_macro_left3 = p.name();
                    String $org_scalatest_assert_macro_right3 = lastProgress.name();
                    String string = $org_scalatest_assert_macro_left3;
                    String string2 = $org_scalatest_assert_macro_right3;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
                });
                query.explain();
            }
            finally {
                query.stop();
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                Object $org_scalatest_assert_macro_left12 = Predef$.MODULE$.refArrayOps((Object[])query.recentProgress());
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left12), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left12), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            }
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Streaming table API", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.shuffle.partitions"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("DROP TABLE IF EXISTS my_table").collect();
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)ckpt -> {
                ClientStreamingQuerySuite.$anonfun$new$7(this, ckpt);
                return BoxedUnit.UNIT;
            });
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("awaitTermination", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.shuffle.partitions"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            StreamingQuery q = this.spark().readStream().format("rate").load().writeStream().format("memory").queryName("test").start();
            long start = System.nanoTime();
            boolean terminated = q.awaitTermination(500L);
            long end = System.nanoTime();
            double $org_scalatest_assert_macro_left = (double)(end - start) / 1000000.0;
            int $org_scalatest_assert_macro_right = 500;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(terminated, "terminated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            q.stop();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute()), (Function0)(JFunction0.mcV.sp & Serializable)() -> q.awaitTermination(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("foreach Row", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TestForeachWriter writer = new TestForeachWriter();
            Dataset df = this.spark().readStream().format("rate").option("rowsPerSecond", "10").load();
            StreamingQuery query = df.writeStream().foreach(writer).outputMode("update").start();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            Option $org_scalatest_assert_macro_left = query.exception();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            query.stop();
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("foreach Int", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            TestForeachWriter writer = new TestForeachWriter();
            Dataset df = this.spark().readStream().format("rate").option("rowsPerSecond", "10").load();
            StreamingQuery query = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(value AS INT)"})).as(session.implicits().newIntEncoder()).writeStream().foreach(writer).outputMode("update").start();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            Option $org_scalatest_assert_macro_left = query.exception();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            query.stop();
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("foreach Custom class", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkSession session = this.spark();
            TestForeachWriter writer = new TestForeachWriter();
            Dataset df = this.spark().readStream().format("rate").option("rowsPerSecond", "10").load();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ClientStreamingQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_ClientStreamingQuerySuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.streaming.TestClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_streaming_ClientStreamingQuerySuite$$typecreator5$1(ClientStreamingQuerySuite $outer) {
                }
            }
            StreamingQuery query = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(value AS INT)"})).as(session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_ClientStreamingQuerySuite$$typecreator5$1(null)))).writeStream().foreach(writer).outputMode("update").start();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(query.isActive(), "query.isActive", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            Option $org_scalatest_assert_macro_left = query.exception();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            query.stop();
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("streaming query manager", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool bool;
            Bool bool2;
            Bool bool3;
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().streams().active());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            StreamingQuery q = this.spark().readStream().format("rate").load().writeStream().format("console").start();
            String $org_scalatest_assert_macro_left2 = q.name();
            Object $org_scalatest_assert_macro_right = null;
            String string = $org_scalatest_assert_macro_left2;
            Object var7_6 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string != null ? !string.equals(var7_6) : var7_6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            StreamingQuery q1 = this.spark().streams().get(q.id());
            StreamingQuery q2 = this.spark().streams().active()[0];
            UUID $org_scalatest_assert_macro_left3 = q.id();
            UUID $org_scalatest_assert_macro_right2 = q1.id();
            UUID uUID = $org_scalatest_assert_macro_left3;
            UUID uUID2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                UUID $org_scalatest_assert_macro_left5 = q.id();
                UUID $org_scalatest_assert_macro_right3 = q2.id();
                UUID uUID3 = $org_scalatest_assert_macro_left5;
                UUID uUID4 = $org_scalatest_assert_macro_right3;
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(uUID3 != null ? !((Object)uUID3).equals(uUID4) : uUID4 != null), Prettifier$.MODULE$.default());
            } else {
                bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right4 = bool3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            UUID $org_scalatest_assert_macro_left6 = q.runId();
            UUID $org_scalatest_assert_macro_right5 = q1.runId();
            UUID uUID5 = $org_scalatest_assert_macro_left6;
            UUID uUID6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(uUID5 != null ? !((Object)uUID5).equals(uUID6) : uUID6 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left7.value()) {
                UUID $org_scalatest_assert_macro_left8 = q.runId();
                UUID $org_scalatest_assert_macro_right6 = q2.runId();
                UUID uUID7 = $org_scalatest_assert_macro_left8;
                UUID uUID8 = $org_scalatest_assert_macro_right6;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(uUID7 != null ? !((Object)uUID7).equals(uUID8) : uUID8 != null), Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right7 = bool2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            String $org_scalatest_assert_macro_left9 = q1.name();
            Object $org_scalatest_assert_macro_right8 = null;
            String string2 = $org_scalatest_assert_macro_left9;
            Object var32_30 = null;
            Bool $org_scalatest_assert_macro_left10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", null, !(string2 != null ? !string2.equals(var32_30) : var32_30 != null), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left10.value()) {
                String $org_scalatest_assert_macro_left11 = q2.name();
                Object $org_scalatest_assert_macro_right9 = null;
                String string3 = $org_scalatest_assert_macro_left11;
                Object var36_34 = null;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", null, !(string3 != null ? !string3.equals(var36_34) : var36_34 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right10 = bool;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "&&", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            this.spark().streams().resetTerminated();
            long start = System.nanoTime();
            boolean terminated = this.spark().streams().awaitAnyTermination(2600L);
            long end = System.nanoTime();
            long $org_scalatest_assert_macro_left12 = end - start;
            long $org_scalatest_assert_macro_right11 = TimeUnit.MILLISECONDS.toNanos(2000L);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12 >= $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(terminated, "terminated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            q.stop();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(q1.isActive(), "q1.isActive", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            StreamingQuery $org_scalatest_assert_macro_left13 = this.spark().streams().get(q.id());
            Object $org_scalatest_assert_macro_right12 = null;
            StreamingQuery streamingQuery = $org_scalatest_assert_macro_left13;
            Object var52_47 = null;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", null, !(streamingQuery != null ? !streamingQuery.equals(var52_47) : var52_47 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("streaming query listener", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StreamingQueryListener[] listeners;
            StreamingQueryListener[] $org_scalatest_assert_macro_left = this.spark().streams().listListeners();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            EventCollector listener = new EventCollector();
            this.spark().streams().addListener((StreamingQueryListener)listener);
            StreamingQuery q = this.spark().readStream().format("rate").load().writeStream().format("console").start();
            try {
                q.processAllAvailable();
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.isActive(), "q.isActive", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table("my_listener_table").toDF(), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)5)}))}))));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            }
            finally {
                q.stop();
                this.spark().sql("DROP TABLE IF EXISTS my_listener_table");
            }
            StreamingQueryListener[] $org_scalatest_assert_macro_left2 = listeners = this.spark().streams().listListeners();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            EventCollector listener1 = new EventCollector();
            this.spark().streams().addListener((StreamingQueryListener)listener1);
            StreamingQueryListener[] $org_scalatest_assert_macro_left3 = this.spark().streams().listListeners();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            this.spark().streams().removeListener((StreamingQueryListener)listener1);
            StreamingQueryListener[] $org_scalatest_assert_macro_left4 = this.spark().streams().listListeners();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            this.spark().streams().addListener((StreamingQueryListener)listener);
            StreamingQueryListener[] $org_scalatest_assert_macro_left5 = this.spark().streams().listListeners();
            int $org_scalatest_assert_macro_right5 = 2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            this.spark().streams().removeListener((StreamingQueryListener)listener);
            StreamingQueryListener[] $org_scalatest_assert_macro_left6 = this.spark().streams().listListeners();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            this.spark().streams().removeListener((StreamingQueryListener)listener);
            StreamingQueryListener[] $org_scalatest_assert_macro_left7 = this.spark().streams().listListeners();
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("foreachBatch", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String viewName = "test_view";
            String tableName = new StringBuilder(12).append("global_temp.").append(viewName).toString();
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                StreamingQuery q = this.spark().readStream().format("rate").option("rowsPerSecond", "10").option("numPartitions", "1").load().writeStream().foreachBatch((VoidFunction2)new ForeachBatchFn(viewName)).start();
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                    StreamingQueryProgress $org_scalatest_assert_macro_left = q.lastProgress();
                    Object $org_scalatest_assert_macro_right = null;
                    StreamingQueryProgress streamingQueryProgress = $org_scalatest_assert_macro_left;
                    Object var4_3 = null;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingQueryProgress == null ? var4_3 != null : !streamingQueryProgress.equals(var4_3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Failed to make progress", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
                    long $org_scalatest_assert_macro_left2 = q.lastProgress().numInputRows();
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
                Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Seq rows = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).collect()));
                    int $org_scalatest_assert_macro_left = rows.size();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Rows in ").append(tableName).append(": ").append(rows).toString());
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
                q.stop();
            });
        }, new Position("ClientStreamingQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }
}

