/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.netty.NettyServerBuilder;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkException;
import org.apache.spark.connect.proto.AnalyzePlanRequest;
import org.apache.spark.connect.proto.AnalyzePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.client.DummySparkConnectService;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.apache.spark.sql.connect.client.GrpcRetryHandler$;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.SparkConnectClientSuite$DummyFn$;
import org.apache.spark.sql.connect.client.SparkConnectClientSuite$TestPackURI$;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.test.ConnectFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g\u0001\u0002 @\u00011CQa\u0018\u0001\u0005\u0002\u0001D\u0011\u0002\u0011\u0001A\u0002\u0003\u0007I\u0011B2\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0007\"C9\u0001\u0001\u0004\u0005\t\u0015)\u0003e\u0011%\u0011\b\u00011AA\u0002\u0013%1\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\"I!\u0010\u0001a\u0001\u0002\u0003\u0006K\u0001\u001e\u0005\nw\u0002\u0001\r\u00111A\u0005\nqD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e!Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015B?\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002bBA\u0013\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011%\tY\u0004AI\u0001\n\u0013\ti\u0004C\u0004\u0002T\u0001!I!!\u0016\u0007\r\u0005%\u0005\u0001RAF\u0011)\tY+\u0005BK\u0002\u0013\u0005\u0011Q\u0016\u0005\u000b\u0003_\u000b\"\u0011#Q\u0001\n\u0005M\u0004BCAY#\tU\r\u0011\"\u0001\u00024\"Q\u00111X\t\u0003\u0012\u0003\u0006I!!.\t\u0015\u0005u\u0016C!f\u0001\n\u0003\ty\f\u0003\u0006\u0002DF\u0011\t\u0012)A\u0005\u0003\u0003DaaX\t\u0005\u0002\u0005\u0015\u0007\"CAi#\u0005\u0005I\u0011AAj\u0011%\tY.EI\u0001\n\u0003\ti\u000eC\u0005\u0002bF\t\n\u0011\"\u0001\u0002d\"I\u0011q]\t\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003[\f\u0012\u0011!C!\u0003_D\u0011\"a@\u0012\u0003\u0003%\tA!\u0001\t\u0013\t\r\u0011#!A\u0005\u0002\t\u0015\u0001\"\u0003B\b#\u0005\u0005I\u0011\tB\t\u0011%\u0011y\"EA\u0001\n\u0003\u0011\t\u0003C\u0005\u0003&E\t\t\u0011\"\u0011\u0003(!I!1F\t\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005_\t\u0012\u0011!C!\u0005cA\u0011Ba\r\u0012\u0003\u0003%\tE!\u000e\b\u0013\te\u0002!!A\t\n\tmb!CAE\u0001\u0005\u0005\t\u0012\u0002B\u001f\u0011\u0019yv\u0005\"\u0001\u0003T!I!qF\u0014\u0002\u0002\u0013\u0015#\u0011\u0007\u0005\n\u0005+:\u0013\u0011!CA\u0005/B\u0011Ba\u0018(#\u0003%\t!!;\t\u0013\t\u0005t%!A\u0005\u0002\n\r\u0004\"\u0003B;OE\u0005I\u0011AAu\u0011%\u00119\b\u0001b\u0001\n\u0013\u0011I\b\u0003\u0005\u0003\b\u0002\u0001\u000b\u0011\u0002B>\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u00173aA!%\u0001\t\tM\u0005B\u0003BKc\t\u0015\r\u0011\"\u0001\u0003\u0018\"Q!qT\u0019\u0003\u0002\u0003\u0006IA!'\t\u0015\t\u0005\u0016G!A!\u0002\u0013\tY\u0002\u0003\u0004`c\u0011\u0005!1\u0015\u0005\n\u0005W\u000b\u0004\u0019!C\u0001\u0005\u0003A\u0011B!,2\u0001\u0004%\tAa,\t\u0011\tM\u0016\u0007)Q\u0005\u00037AqA!.2\t\u0003\u0011icB\u0005\u00038\u0002\t\t\u0011#\u0003\u0003:\u001aI!\u0011\u0013\u0001\u0002\u0002#%!1\u0018\u0005\u0007?n\"\tA!0\t\u0013\t}6(%A\u0005\u0002\u0005u\"aF*qCJ\\7i\u001c8oK\u000e$8\t\\5f]R\u001cV/\u001b;f\u0015\t\u0001\u0015)\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u0005\u000e\u000bqaY8o]\u0016\u001cGO\u0003\u0002E\u000b\u0006\u00191/\u001d7\u000b\u0005\u0019;\u0015!B:qCJ\\'B\u0001%J\u0003\u0019\t\u0007/Y2iK*\t!*A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001bV[\u0006C\u0001(T\u001b\u0005y%B\u0001)R\u0003!1WO\\:vSR,'B\u0001*J\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002U\u001f\nY\u0011I\\=Gk:\u001cV/\u001b;f!\t1\u0016,D\u0001X\u0015\tA6)\u0001\u0003uKN$\u0018B\u0001.X\u0005=\u0019uN\u001c8fGR4UO\\*vSR,\u0007C\u0001/^\u001b\u0005\t\u0016B\u00010R\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0002\rqJg.\u001b;?)\u0005\t\u0007C\u00012\u0001\u001b\u0005yT#\u00013\u0011\u0005\t,\u0017B\u00014@\u0005I\u0019\u0006/\u0019:l\u0007>tg.Z2u\u00072LWM\u001c;\u0002\u0015\rd\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002j_B\u0011!.\\\u0007\u0002W*\tA.A\u0003tG\u0006d\u0017-\u0003\u0002oW\n!QK\\5u\u0011\u001d\u00018!!AA\u0002\u0011\f1\u0001\u001f\u00132\u0003\u001d\u0019G.[3oi\u0002\nqa]3sm&\u001cW-F\u0001u!\t\u0011W/\u0003\u0002w\u007f\tAB)^7nsN\u0003\u0018M]6D_:tWm\u0019;TKJ4\u0018nY3\u0002\u0017M,'O^5dK~#S-\u001d\u000b\u0003SfDq\u0001\u001d\u0004\u0002\u0002\u0003\u0007A/\u0001\u0005tKJ4\u0018nY3!\u0003\u0019\u0019XM\u001d<feV\tQ\u0010E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003heB\u001c'BAA\u0003\u0003\tIw.C\u0002\u0002\n}\u0014aaU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0019\u0011.a\u0004\t\u000fAL\u0011\u0011!a\u0001{\u000691/\u001a:wKJ\u0004\u0013\u0001E:uCJ$H)^7nsN+'O^3s)\rI\u0017q\u0003\u0005\b\u00033Y\u0001\u0019AA\u000e\u0003\u0011\u0001xN\u001d;\u0011\u0007)\fi\"C\u0002\u0002 -\u00141!\u00138u\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002S\u0006I\u0011M\u001a;fe\u0016\u000b7\r[\u0001\u0015i\u0016\u001cHo\u00117jK:$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\t\u0005-\u0012q\u0007\u000b\u0004S\u00065\u0002bBA\u0018\u001d\u0001\u0007\u0011\u0011G\u0001\u000eG2LWM\u001c;Ck&dG-\u001a:\u0011\r)\f\u0019$a\u0007e\u0013\r\t)d\u001b\u0002\n\rVt7\r^5p]FB\u0011\"!\u000f\u000f!\u0003\u0005\r!a\u0007\u0002\u0015M,'O^3s!>\u0014H/\u0001\u0010uKN$8\t\\5f]R\u001cuN\u001c8fGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\b\u0016\u0005\u00037\t\te\u000b\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013!C;oG\",7m[3e\u0015\r\tie[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA)\u0003\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003!9\u0018\u000e\u001e5F]Z\u001cH\u0003BA,\u0003G\"2![A-\u0011!\tY\u0006\u0005CA\u0002\u0005u\u0013!\u00014\u0011\t)\fy&[\u0005\u0004\u0003CZ'\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005\u0015\u0004\u00031\u0001\u0002h\u0005)\u0001/Y5sgB)!.!\u001b\u0002n%\u0019\u00111N6\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0004k\u0003_\n\u0019(a\u001d\n\u0007\u0005E4N\u0001\u0004UkBdWM\r\t\u0005\u0003k\n\u0019I\u0004\u0003\u0002x\u0005}\u0004cAA=W6\u0011\u00111\u0010\u0006\u0004\u0003{Z\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0002.\fa\u0001\u0015:fI\u00164\u0017\u0002BAC\u0003\u000f\u0013aa\u0015;sS:<'bAAAW\nYA+Z:u!\u0006\u001c7.\u0016*J'\u001d\t\u0012QRAJ\u00033\u00032A[AH\u0013\r\t\tj\u001b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007)\f)*C\u0002\u0002\u0018.\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u001c\u0006\u0015f\u0002BAO\u0003CsA!!\u001f\u0002 &\tA.C\u0002\u0002$.\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002(\u0006%&\u0001D*fe&\fG.\u001b>bE2,'bAARW\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8TiJLgnZ\u000b\u0003\u0003g\n\u0011cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4!\u0003%I7oQ8se\u0016\u001cG/\u0006\u0002\u00026B\u0019!.a.\n\u0007\u0005e6NA\u0004C_>dW-\u00198\u0002\u0015%\u001c8i\u001c:sK\u000e$\b%A\u0006fqR\u0014\u0018m\u00115fG.\u001cXCAAa!\u0015Q\u00171\u00073j\u00031)\u0007\u0010\u001e:b\u0007\",7m[:!)!\t9-a3\u0002N\u0006=\u0007cAAe#5\t\u0001\u0001C\u0004\u0002,b\u0001\r!a\u001d\t\u000f\u0005E\u0006\u00041\u0001\u00026\"I\u0011Q\u0018\r\u0011\u0002\u0003\u0007\u0011\u0011Y\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002H\u0006U\u0017q[Am\u0011%\tY+\u0007I\u0001\u0002\u0004\t\u0019\bC\u0005\u00022f\u0001\n\u00111\u0001\u00026\"I\u0011QX\r\u0011\u0002\u0003\u0007\u0011\u0011Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyN\u000b\u0003\u0002t\u0005\u0005\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KTC!!.\u0002B\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAvU\u0011\t\t-!\u0011\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0010\u0005\u0003\u0002t\u0006uXBAA{\u0015\u0011\t90!?\u0002\t1\fgn\u001a\u0006\u0003\u0003w\fAA[1wC&!\u0011QQA{\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\"\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\u001d!Q\u0002\t\u0004U\n%\u0011b\u0001B\u0006W\n\u0019\u0011I\\=\t\u0011A|\u0012\u0011!a\u0001\u00037\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005'\u0001bA!\u0006\u0003\u001c\t\u001dQB\u0001B\f\u0015\r\u0011Ib[\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u000f\u0005/\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q\u0017B\u0012\u0011!\u0001\u0018%!AA\u0002\t\u001d\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!=\u0003*!A\u0001OIA\u0001\u0002\u0004\tY\"\u0001\u0005iCND7i\u001c3f)\t\tY\"\u0001\u0005u_N#(/\u001b8h)\t\t\t0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003k\u00139\u0004\u0003\u0005qK\u0005\u0005\t\u0019\u0001B\u0004\u0003-!Vm\u001d;QC\u000e\\WKU%\u0011\u0007\u0005%weE\u0003(\u0005\u007f\u0011Y\u0005\u0005\u0007\u0003B\t\u001d\u00131OA[\u0003\u0003\f9-\u0004\u0002\u0003D)\u0019!QI6\u0002\u000fI,h\u000e^5nK&!!\u0011\nB\"\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005\u001b\u0012\t&\u0004\u0002\u0003P)!\u0011QAA}\u0013\u0011\t9Ka\u0014\u0015\u0005\tm\u0012!B1qa2LH\u0003CAd\u00053\u0012YF!\u0018\t\u000f\u0005-&\u00061\u0001\u0002t!9\u0011\u0011\u0017\u0016A\u0002\u0005U\u0006\"CA_UA\u0005\t\u0019AAa\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005K\u0012\t\bE\u0003k\u0005O\u0012Y'C\u0002\u0003j-\u0014aa\u00149uS>t\u0007#\u00036\u0003n\u0005M\u0014QWAa\u0013\r\u0011yg\u001b\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tMD&!AA\u0002\u0005\u001d\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nA!\u0016*JgV\u0011!1\u0010\t\u0007\u0005{\u0012\u0019)a2\u000e\u0005\t}$\u0002\u0002BA\u0005/\t\u0011\"[7nkR\f'\r\\3\n\t\t\u0015%q\u0010\u0002\u0004'\u0016\f\u0018!B+S\u0013N\u0004\u0013!D2iK\u000e\\G+Z:u!\u0006\u001c7\u000eF\u0002j\u0005\u001bCqAa$1\u0001\u0004\t9-\u0001\u0005uKN$\b+Y2l\u0005\u001d!U/\\7z\r:\u001c2!MAG\u0003\u0005)WC\u0001BM!\u0011\tYJa'\n\t\tu\u0015\u0011\u0016\u0002\n)\"\u0014xn^1cY\u0016\f!!\u001a\u0011\u0002\u00119,XNR1jYN$bA!*\u0003(\n%\u0006cAAec!9!QS\u001bA\u0002\te\u0005\"\u0003BQkA\u0005\t\u0019AA\u000e\u0003\u001d\u0019w.\u001e8uKJ\f1bY8v]R,'o\u0018\u0013fcR\u0019\u0011N!-\t\u0011A<\u0014\u0011!a\u0001\u00037\t\u0001bY8v]R,'\u000fI\u0001\u0003M:\fq\u0001R;n[f4e\u000eE\u0002\u0002Jn\u001a2aOAG)\t\u0011I,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r")
public class SparkConnectClientSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterEach {
    private volatile SparkConnectClientSuite$TestPackURI$ TestPackURI$module;
    private volatile SparkConnectClientSuite$DummyFn$ DummyFn$module;
    private SparkConnectClient client;
    private DummySparkConnectService service;
    private Server server;
    private final Seq<TestPackURI> URIs;
    private Path baseResourcePath;
    private Path commonResourcePath;

    public /* synthetic */ org.scalatest.Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public org.scalatest.Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    private SparkConnectClientSuite$TestPackURI$ TestPackURI() {
        if (this.TestPackURI$module == null) {
            this.TestPackURI$lzycompute$1();
        }
        return this.TestPackURI$module;
    }

    private SparkConnectClientSuite$DummyFn$ DummyFn() {
        if (this.DummyFn$module == null) {
            this.DummyFn$lzycompute$1();
        }
        return this.DummyFn$module;
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private SparkConnectClient client() {
        return this.client;
    }

    private void client_$eq(SparkConnectClient x$1) {
        this.client = x$1;
    }

    private DummySparkConnectService service() {
        return this.service;
    }

    private void service_$eq(DummySparkConnectService x$1) {
        this.service = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private void startDummyServer(int port) {
        this.service_$eq(new DummySparkConnectService());
        this.server_$eq(((AbstractServerImplBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)this.service())).build());
        this.server().start();
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.client_$eq(null);
        this.server_$eq(null);
        this.service_$eq(null);
    }

    public void afterEach() {
        block2: {
            BoxedUnit boxedUnit;
            if (this.server() != null) {
                this.server().shutdownNow();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.server().awaitTermination(5L, TimeUnit.SECONDS), "SparkConnectClientSuite.this.server.awaitTermination(5L, SECONDS)", Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"server failed to shutdown", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (this.client() == null) break block2;
            this.client().shutdown();
        }
    }

    private void testClientConnection(int serverPort, Function1<Object, SparkConnectClient> clientBuilder) {
        this.startDummyServer(serverPort);
        this.client_$eq((SparkConnectClient)clientBuilder.apply((Object)BoxesRunTime.boxToInteger((int)this.server().getPort())));
        AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
        AnalyzePlanResponse response = this.client().analyze(request);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(response.getSessionId());
        String $org_scalatest_assert_macro_right = "abc123";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    private int testClientConnection$default$1() {
        return 0;
    }

    private void withEnvs(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Map<String, String> readonlyEnv = System.getenv();
        Field field = readonlyEnv.getClass().getDeclaredField("m");
        field.setAccessible(true);
        Map modifiableEnv = (Map)field.get(readonlyEnv);
        try {
            pairs.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$withEnvs$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(modifiableEnv.containsKey(k), "modifiableEnv.containsKey(k)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                String string = modifiableEnv.put(k, v);
                return string;
            });
            f.apply$mcV$sp();
        }
        finally {
            pairs.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$withEnvs$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String string = (String)modifiableEnv.remove(k);
                return string;
            });
        }
    }

    private Seq<TestPackURI> URIs() {
        return this.URIs;
    }

    private void checkTestPack(TestPackURI testPack) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().connectionString(testPack.connectionString()).build();
        testPack.extraChecks().apply((Object)client);
    }

    private final void TestPackURI$lzycompute$1() {
        SparkConnectClientSuite sparkConnectClientSuite = this;
        synchronized (sparkConnectClientSuite) {
            if (this.TestPackURI$module == null) {
                this.TestPackURI$module = new SparkConnectClientSuite$TestPackURI$(this);
            }
        }
    }

    private final void DummyFn$lzycompute$1() {
        SparkConnectClientSuite sparkConnectClientSuite = this;
        synchronized (sparkConnectClientSuite) {
            if (this.DummyFn$module == null) {
                this.DummyFn$module = new SparkConnectClientSuite$DummyFn$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$withEnvs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$withEnvs$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$3(int testPort) {
        return SparkConnectClient$.MODULE$.builder().port(testPort).build();
    }

    public static final /* synthetic */ SparkConnectClient $anonfun$new$5(int testPort) {
        return SparkConnectClient$.MODULE$.builder().connectionString(new StringBuilder(15).append("sc://localhost:").append(testPort).toString()).build();
    }

    public static final /* synthetic */ void $anonfun$URIs$3(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.configuration().host();
        String $org_scalatest_assert_macro_right = "localhost";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        int $org_scalatest_assert_macro_left2 = client.configuration().port();
        int $org_scalatest_assert_macro_right2 = 1234;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        String $org_scalatest_assert_macro_left3 = client.sessionId();
        Object $org_scalatest_assert_macro_right3 = null;
        String string3 = $org_scalatest_assert_macro_left3;
        Object var11_10 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, string3 == null ? var11_10 != null : !string3.equals(var11_10), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        UUID $org_scalatest_assert_macro_left4 = UUID.fromString(client.sessionId());
        Object $org_scalatest_assert_macro_right4 = null;
        UUID uUID = $org_scalatest_assert_macro_left4;
        Object var15_14 = null;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", null, uUID == null ? var15_14 != null : !((Object)uUID).equals(var15_14), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
    }

    public static final /* synthetic */ void $anonfun$URIs$4(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.configuration().host();
        String $org_scalatest_assert_macro_right = "localhost";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        int $org_scalatest_assert_macro_left2 = client.configuration().port();
        int $org_scalatest_assert_macro_right2 = ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
    }

    public static final /* synthetic */ void $anonfun$URIs$5(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userId();
        String $org_scalatest_assert_macro_right = "a94";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
    }

    public static final /* synthetic */ void $anonfun$URIs$6(SparkConnectClient client) {
        String $org_scalatest_assert_macro_left = client.userAgent();
        String $org_scalatest_assert_macro_right = "a945";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
    }

    private static final void sleep$1(long t, LongRef totalSleepMs$1) {
        totalSleepMs$1.elem += t;
    }

    public static final /* synthetic */ Assertion $anonfun$new$21(SparkConnectClientSuite $this, int x$8) {
        int n = x$8;
        LongRef totalSleepMs = LongRef.create((long)0L);
        DummyFn dummyFn = new DummyFn($this, (Throwable)new StatusRuntimeException(Status.UNAVAILABLE), 100);
        GrpcRetryHandler retryHandler = new GrpcRetryHandler(new GrpcRetryHandler.RetryPolicy(GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$1(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7()), (Function1)(JFunction1.mcVJ.sp & Serializable)t -> SparkConnectClientSuite.sleep$1(t, totalSleepMs));
        $this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        long $org_scalatest_assert_macro_left = totalSleepMs.elem;
        int $org_scalatest_assert_macro_right = 600000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        return assertion;
    }

    public static final /* synthetic */ boolean $anonfun$new$31(Throwable x$9) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$35(Throwable x$10) {
        return true;
    }

    public SparkConnectClientSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        this.test("Placeholder test: Create SparkConnectClient", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.client_$eq(SparkConnectClient$.MODULE$.builder().userId("abc123").build());
            String $org_scalatest_assert_macro_left = this.client().userId();
            String $org_scalatest_assert_macro_right = "abc123";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("Test connection", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("Test connection string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testClientConnection(this.testClientConnection$default$1(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)testPort -> SparkConnectClientSuite.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)testPort))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("Test encryption", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString(new StringBuilder(29).append("sc://localhost:").append(this.server().getPort()).append("/;use_ssl=true").toString()).retryPolicy(new GrpcRetryHandler.RetryPolicy(0, GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7())).build());
            AnalyzePlanRequest request = AnalyzePlanRequest.newBuilder().setSessionId("abc123").build();
            return this.assertThrows((Function0 & Serializable)() -> this.client().analyze(request), ClassTag$.MODULE$.apply(SparkException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("SparkSession create with SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)new StringBuilder(15).append("sc://localhost:").append(this.server().getPort()).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().create();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                SparkSession session2 = SparkSession$.MODULE$.builder().create();
                SparkSession $org_scalatest_assert_macro_left2 = session;
                SparkSession $org_scalatest_assert_macro_right2 = session2;
                SparkSession sparkSession = $org_scalatest_assert_macro_left2;
                SparkSession sparkSession2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, sparkSession == null ? sparkSession2 != null : !sparkSession.equals(sparkSession2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("SparkSession getOrCreate with SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)new StringBuilder(15).append("sc://localhost:").append(this.server().getPort()).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().getOrCreate();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
                SparkSession session2 = SparkSession$.MODULE$.builder().getOrCreate();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(session);
                SparkSession $org_scalatest_assert_macro_right2 = session2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("Builder.remote takes precedence over SPARK_REMOTE", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.startDummyServer(0);
            String incorrectUrl = new StringBuilder(15).append("sc://localhost:").append(this.server().getPort() + 1).toString();
            this.withEnvs((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_REMOTE"), (Object)incorrectUrl)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SparkSession session = SparkSession$.MODULE$.builder().remote(new StringBuilder(15).append("sc://localhost:").append(this.server().getPort()).toString()).getOrCreate();
                Dataset df = session.range(10L);
                df.analyze();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
                Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            });
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("SparkSession initialisation with connection string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString(new StringBuilder(15).append("sc://localhost:").append(this.server().getPort()).toString()).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            Dataset df = session.range(10L);
            df.analyze();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.plan());
            Plan $org_scalatest_assert_macro_right = this.service().getAndClearLatestInputPlan();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("Custom Interceptor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.startDummyServer(0);
            this.client_$eq(SparkConnectClient$.MODULE$.builder().connectionString(new StringBuilder(15).append("sc://localhost:").append(this.server().getPort()).toString()).interceptor(new ClientInterceptor(null){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                    throw new RuntimeException("Blocked");
                }
            }).build());
            SparkSession session = SparkSession$.MODULE$.builder().client(this.client()).create();
            return this.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> session.range(10L).count(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.URIs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestPackURI[]{new TestPackURI(this, "sc://host", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://localhost/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            this.testClientConnection(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT(), (Function1<Object, SparkConnectClient>)(Function1 & Serializable)x$7 -> client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost:1234/", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$3(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://localhost/;", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$4(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;user_id=a94", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$5(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "sc://host:123/;user_agent=a945", true, (Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            SparkConnectClientSuite.$anonfun$URIs$6(client);
            return BoxedUnit.UNIT;
        }), new TestPackURI(this, "scc://host:12", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "http://host", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:/host:1234/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/path", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host/;parm1;param2", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123;user_id=a94", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc:///user_id=123", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:-4", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://:123/", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;session_id=abcdefgh", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, new StringBuilder(26).append("sc://host:123/;session_id=").append(UUID.randomUUID().toString()).toString(), true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=true;token=mySecretToken", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=true", true, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;use_ssl=false;token=mySecretToken", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;token=mySecretToken;use_ssl=false", false, this.TestPackURI().apply$default$3()), new TestPackURI(this, "sc://host:123/;param1=value1;param2=value2", true, this.TestPackURI().apply$default$3())}));
        this.URIs().foreach((Function1 & Serializable)testPack -> {
            this.test(new StringBuilder(24).append("Check URI: ").append(testPack.connectionString()).append(", isCorrect: ").append(testPack.isCorrect()).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                BoxedUnit boxedUnit;
                if (!testPack.isCorrect()) {
                    boxedUnit = $this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.checkTestPack(testPack), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
                } else {
                    $this.checkTestPack(testPack);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-44721: Retries run for a minimum period", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable)x$8 -> SparkConnectClientSuite.$anonfun$new$21(this, BoxesRunTime.unboxToInt((Object)x$8))), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("SPARK-44275: retry actually retries", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int result;
            DummyFn dummyFn = new DummyFn(this, (Throwable)new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            GrpcRetryHandler.RetryPolicy retryPolicy = new GrpcRetryHandler.RetryPolicy(GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$1(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7());
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy, GrpcRetryHandler$.MODULE$.$lessinit$greater$default$2());
            int $org_scalatest_assert_macro_left = result = BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn()));
            int $org_scalatest_assert_macro_right = 42;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            int $org_scalatest_assert_macro_left2 = dummyFn.counter();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        this.test("SPARK-44275: default retryException retries only on UNAVAILABLE", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Throwable)new StatusRuntimeException(Status.ABORTED), this.DummyFn().$lessinit$greater$default$2());
            GrpcRetryHandler.RetryPolicy retryPolicy = new GrpcRetryHandler.RetryPolicy(GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$1(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7());
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy, GrpcRetryHandler$.MODULE$.$lessinit$greater$default$2());
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("SPARK-44275: retry uses canRetry to filter exceptions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Throwable)new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Function1 & Serializable x$1 = (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$31(x$9));
            int x$2 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$1();
            FiniteDuration x$3 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2();
            FiniteDuration x$4 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3();
            double x$5 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$6 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$7 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6();
            GrpcRetryHandler.RetryPolicy retryPolicy = new GrpcRetryHandler.RetryPolicy(x$2, x$3, x$4, x$5, x$6, x$7, (Function1)x$1);
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy, GrpcRetryHandler$.MODULE$.$lessinit$greater$default$2());
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("SPARK-44275: retry does not exceed maxRetries", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DummyFn dummyFn = new DummyFn(this, (Throwable)new StatusRuntimeException(Status.UNAVAILABLE), this.DummyFn().$lessinit$greater$default$2());
            Function1 & Serializable x$8 = (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectClientSuite.$anonfun$new$35(x$10));
            boolean x$9 = true;
            FiniteDuration x$102 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2();
            FiniteDuration x$11 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3();
            double x$12 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4();
            FiniteDuration x$13 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5();
            FiniteDuration x$14 = GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6();
            GrpcRetryHandler.RetryPolicy retryPolicy = new GrpcRetryHandler.RetryPolicy(1, x$102, x$11, x$12, x$13, x$14, (Function1)x$8);
            GrpcRetryHandler retryHandler = new GrpcRetryHandler(retryPolicy, GrpcRetryHandler$.MODULE$.$lessinit$greater$default$2());
            this.assertThrows((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)retryHandler.retry((Function0)(JFunction0.mcI.sp & Serializable)() -> dummyFn.fn())), ClassTag$.MODULE$.apply(StatusRuntimeException.class), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            int $org_scalatest_assert_macro_left = dummyFn.counter();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        }, new Position("SparkConnectClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        Statics.releaseFence();
    }

    private class DummyFn {
        private final Throwable e;
        private final int numFails;
        private int counter;
        public final /* synthetic */ SparkConnectClientSuite $outer;

        public Throwable e() {
            return this.e;
        }

        public int counter() {
            return this.counter;
        }

        public void counter_$eq(int x$1) {
            this.counter = x$1;
        }

        public int fn() {
            if (this.counter() < this.numFails) {
                this.counter_$eq(this.counter() + 1);
                throw this.e();
            }
            return 42;
        }

        public /* synthetic */ SparkConnectClientSuite org$apache$spark$sql$connect$client$SparkConnectClientSuite$DummyFn$$$outer() {
            return this.$outer;
        }

        public DummyFn(SparkConnectClientSuite $outer, Throwable e, int numFails) {
            this.e = e;
            this.numFails = numFails;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.counter = 0;
        }
    }

    private class TestPackURI
    implements Product,
    Serializable {
        private final String connectionString;
        private final boolean isCorrect;
        private final Function1<SparkConnectClient, BoxedUnit> extraChecks;
        public final /* synthetic */ SparkConnectClientSuite $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String connectionString() {
            return this.connectionString;
        }

        public boolean isCorrect() {
            return this.isCorrect;
        }

        public Function1<SparkConnectClient, BoxedUnit> extraChecks() {
            return this.extraChecks;
        }

        public TestPackURI copy(String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            return new TestPackURI(this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer(), connectionString, isCorrect, extraChecks);
        }

        public String copy$default$1() {
            return this.connectionString();
        }

        public boolean copy$default$2() {
            return this.isCorrect();
        }

        public Function1<SparkConnectClient, BoxedUnit> copy$default$3() {
            return this.extraChecks();
        }

        public String productPrefix() {
            return "TestPackURI";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.connectionString();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isCorrect());
                    break;
                }
                case 2: {
                    object = this.extraChecks();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestPackURI;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "connectionString";
                    break;
                }
                case 1: {
                    string = "isCorrect";
                    break;
                }
                case 2: {
                    string = "extraChecks";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.connectionString()));
            n = Statics.mix((int)n, (int)(this.isCorrect() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.extraChecks()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestPackURI)) return false;
            if (((TestPackURI)object).org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() != this.org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestPackURI testPackURI = (TestPackURI)x$1;
            if (this.isCorrect() != testPackURI.isCorrect()) return false;
            String string = this.connectionString();
            String string2 = testPackURI.connectionString();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Function1<SparkConnectClient, BoxedUnit> function1 = this.extraChecks();
            Function1<SparkConnectClient, BoxedUnit> function12 = testPackURI.extraChecks();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!testPackURI.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SparkConnectClientSuite org$apache$spark$sql$connect$client$SparkConnectClientSuite$TestPackURI$$$outer() {
            return this.$outer;
        }

        public TestPackURI(SparkConnectClientSuite $outer, String connectionString, boolean isCorrect, Function1<SparkConnectClient, BoxedUnit> extraChecks) {
            this.connectionString = connectionString;
            this.isCorrect = isCorrect;
            this.extraChecks = extraChecks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

