/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public final class RecordingUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private boolean recording = false;
    public final BlockingQueue<UpdateCommand> commandQueue = new LinkedBlockingQueue<UpdateCommand>();

    public synchronized void startRecording() {
        this.recording = true;
    }

    public synchronized void stopRecording() {
        this.recording = false;
    }

    public synchronized UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return this.recording ? new RecordingUpdateRequestProcessor(this.commandQueue, next) : next;
    }

    private static final class RecordingUpdateRequestProcessor
    extends UpdateRequestProcessor {
        private final BlockingQueue<UpdateCommand> commandQueue;

        public RecordingUpdateRequestProcessor(BlockingQueue<UpdateCommand> commandQueue, UpdateRequestProcessor next) {
            super(next);
            this.commandQueue = commandQueue;
        }

        private void record(UpdateCommand cmd) {
            if (!this.commandQueue.offer(cmd)) {
                throw new RuntimeException("WTF: commandQueue should be unbounded but offer failed: " + String.valueOf(cmd));
            }
        }

        public void processAdd(AddUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processAdd(cmd);
        }

        public void processDelete(DeleteUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processDelete(cmd);
        }

        public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processMergeIndexes(cmd);
        }

        public void processCommit(CommitUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processCommit(cmd);
        }

        public void processRollback(RollbackUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processRollback(cmd);
        }
    }
}

