/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.AbstractDistribZkTestBase;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.cloud.api.collections.AbstractCloudBackupRestoreTestCase;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.TrackingBackupRepository;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.BackupProperties;
import org.apache.solr.core.backup.Checksum;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.ShardBackupMetadata;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.embedded.JettySolrRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIncrementalBackupTest
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static long docsSeed;
    protected static final int NUM_NODES = 2;
    protected static final int NUM_SHARDS = 2;
    protected static final int LARGE_NUM_SHARDS = 11;
    protected static final int REPL_FACTOR = 2;
    protected static final String BACKUPNAME_PREFIX = "mytestbackup";
    protected static final String BACKUP_REPO_NAME = "trackingBackupRepository";
    protected String testSuffix = "test1";

    @BeforeClass
    public static void createCluster() throws Exception {
        docsSeed = AbstractIncrementalBackupTest.random().nextLong();
        System.setProperty("solr.directoryFactory", "solr.StandardDirectoryFactory");
    }

    @Before
    public void setUpTrackingRepo() {
        TrackingBackupRepository.clear();
    }

    public abstract String getCollectionNamePrefix();

    public String getCollectionName() {
        return this.getCollectionNamePrefix() + "_" + this.testSuffix;
    }

    public void setTestSuffix(String testSuffix) {
        this.testSuffix = testSuffix;
    }

    public abstract String getBackupLocation();

    @Test
    public void testSimple() throws Exception {
        this.setTestSuffix("testbackupincsimple");
        String backupCollectionName = this.getCollectionName();
        String restoreCollectionName = backupCollectionName + "_restore";
        int randomizedNumShards = AbstractIncrementalBackupTest.rarely() ? 11 : 2;
        CloudSolrClient solrClient = cluster.getSolrClient();
        CollectionAdminRequest.createCollection((String)backupCollectionName, (String)"conf1", (int)randomizedNumShards, (int)1).process((SolrClient)solrClient);
        int totalIndexedDocs = this.indexDocs(backupCollectionName, true);
        String backupName = BACKUPNAME_PREFIX + this.testSuffix;
        try (BackupRepository repository = cluster.getJettySolrRunner(0).getCoreContainer().newBackupRepository(BACKUP_REPO_NAME);){
            String backupLocation = repository.getBackupLocation(this.getBackupLocation());
            long t = System.nanoTime();
            int expectedDocsForFirstBackup = totalIndexedDocs;
            CollectionAdminRequest.backupCollection((String)backupCollectionName, (String)backupName).setLocation(backupLocation).setIncremental(true).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)cluster.getSolrClient(), 100L);
            long timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            log.info("Created backup with {} docs, took {}ms", (Object)totalIndexedDocs, (Object)timeTaken);
            totalIndexedDocs += this.indexDocs(backupCollectionName, true);
            t = System.nanoTime();
            CollectionAdminRequest.backupCollection((String)backupCollectionName, (String)backupName).setLocation(backupLocation).setIncremental(true).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)cluster.getSolrClient(), 100L);
            timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            long numFound = cluster.getSolrClient().query(backupCollectionName, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
            log.info("Created backup with {} docs, took {}ms", (Object)numFound, (Object)timeTaken);
            t = System.nanoTime();
            this.randomlyPrecreateRestoreCollection(restoreCollectionName, "conf1", randomizedNumShards, 1);
            CollectionAdminRequest.restoreCollection((String)restoreCollectionName, (String)backupName).setBackupId(0).setLocation(backupLocation).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)solrClient, 500L);
            timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            log.info("Restored from backup, took {}ms", (Object)timeTaken);
            t = System.nanoTime();
            AbstractDistribZkTestBase.waitForRecoveriesToFinish(restoreCollectionName, ZkStateReader.from((CloudSolrClient)solrClient), log.isDebugEnabled(), false, 3L);
            timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            log.info("Restored collection healthy, took {}ms", (Object)timeTaken);
            numFound = cluster.getSolrClient().query(restoreCollectionName, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
            AbstractIncrementalBackupTest.assertEquals((long)expectedDocsForFirstBackup, (long)numFound);
        }
    }

    @Test
    public void testRestoreToOriginalCollection() throws Exception {
        this.setTestSuffix("testbackuprestoretooriginal");
        String backupCollectionName = this.getCollectionName();
        String backupName = BACKUPNAME_PREFIX + this.testSuffix;
        CollectionAdminRequest.createCollection((String)backupCollectionName, (String)"conf1", (int)2, (int)2).process((SolrClient)cluster.getSolrClient());
        int firstBatchNumDocs = this.indexDocs(backupCollectionName, true);
        try (BackupRepository repository = cluster.getJettySolrRunner(0).getCoreContainer().newBackupRepository(BACKUP_REPO_NAME);){
            String backupLocation = repository.getBackupLocation(this.getBackupLocation());
            RequestStatusState result = CollectionAdminRequest.backupCollection((String)backupCollectionName, (String)backupName).setLocation(backupLocation).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)cluster.getSolrClient(), 20L);
            AbstractIncrementalBackupTest.assertEquals((Object)RequestStatusState.COMPLETED, (Object)result);
        }
        int secondBatchNumDocs = this.indexDocs(backupCollectionName, true);
        int maxDocs = secondBatchNumDocs + firstBatchNumDocs;
        AbstractIncrementalBackupTest.assertEquals((long)maxDocs, (long)this.getNumDocsInCollection(backupCollectionName));
        try (BackupRepository repository = cluster.getJettySolrRunner(0).getCoreContainer().newBackupRepository(BACKUP_REPO_NAME);){
            String backupLocation = repository.getBackupLocation(this.getBackupLocation());
            RequestStatusState result = CollectionAdminRequest.restoreCollection((String)backupCollectionName, (String)backupName).setLocation(backupLocation).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)cluster.getSolrClient(), 30L);
            AbstractIncrementalBackupTest.assertEquals((Object)RequestStatusState.COMPLETED, (Object)result);
        }
        AbstractIncrementalBackupTest.assertEquals((long)firstBatchNumDocs, (long)this.getNumDocsInCollection(backupCollectionName));
    }

    @Test
    @LuceneTestCase.Nightly
    public void testBackupIncremental() throws Exception {
        block11: {
            this.setTestSuffix("testbackupinc");
            CloudSolrClient solrClient = cluster.getSolrClient();
            CollectionAdminRequest.createCollection((String)this.getCollectionName(), (String)"conf1", (int)2, (int)2).process((SolrClient)solrClient);
            this.indexDocs(this.getCollectionName(), false);
            String backupName = BACKUPNAME_PREFIX + this.testSuffix;
            try (BackupRepository repository = cluster.getJettySolrRunner(0).getCoreContainer().newBackupRepository(BACKUP_REPO_NAME);){
                String backupLocation = repository.getBackupLocation(this.getBackupLocation());
                URI fullBackupLocationURI = repository.resolveDirectory(repository.createDirectoryURI(backupLocation), new String[]{backupName, this.getCollectionName()});
                BackupFilePaths backupPaths = new BackupFilePaths(repository, fullBackupLocationURI);
                IncrementalBackupVerifier verifier = new IncrementalBackupVerifier(repository, backupLocation, backupName, this.getCollectionName(), 3);
                this.backupRestoreThenCheck(solrClient, verifier);
                this.indexDocs(this.getCollectionName(), false);
                this.backupRestoreThenCheck(solrClient, verifier);
                for (int i = 0; i < 15; ++i) {
                    this.indexDocs(this.getCollectionName(), 5, false);
                }
                this.backupRestoreThenCheck(solrClient, verifier);
                this.indexDocs(this.getCollectionName(), false);
                this.backupRestoreThenCheck(solrClient, verifier);
                CollectionAdminResponse resp = (CollectionAdminResponse)CollectionAdminRequest.listBackup((String)backupName).setBackupLocation(backupLocation).setBackupRepository(BACKUP_REPO_NAME).process((SolrClient)cluster.getSolrClient());
                List backups = (List)resp.getResponse().get("backups");
                AbstractIncrementalBackupTest.assertEquals((long)3L, (long)backups.size());
                resp = (CollectionAdminResponse)CollectionAdminRequest.deleteBackupByRecency((String)backupName, (int)4).setRepositoryName(BACKUP_REPO_NAME).setLocation(backupLocation).process((SolrClient)cluster.getSolrClient());
                AbstractIncrementalBackupTest.assertNull((Object)resp.getResponse().get("deleted"));
                resp = (CollectionAdminResponse)CollectionAdminRequest.deleteBackupByRecency((String)backupName, (int)3).setRepositoryName(BACKUP_REPO_NAME).setLocation(backupLocation).process((SolrClient)cluster.getSolrClient());
                AbstractIncrementalBackupTest.assertNull((Object)resp.getResponse().get("deleted"));
                resp = (CollectionAdminResponse)CollectionAdminRequest.deleteBackupByRecency((String)backupName, (int)2).setRepositoryName(BACKUP_REPO_NAME).setLocation(backupLocation).process((SolrClient)cluster.getSolrClient());
                AbstractIncrementalBackupTest.assertEquals((Object)1, (Object)resp.getResponse()._get("deleted[0]/backupId"));
                resp = (CollectionAdminResponse)CollectionAdminRequest.deleteBackupById((String)backupName, (int)3).setRepositoryName(BACKUP_REPO_NAME).setLocation(backupLocation).process((SolrClient)cluster.getSolrClient());
                AbstractIncrementalBackupTest.assertEquals((Object)3, (Object)resp.getResponse()._get("deleted[0]/backupId"));
                this.simpleRestoreAndCheckDocCount(solrClient, backupLocation, backupName);
                resp = (CollectionAdminResponse)CollectionAdminRequest.deleteBackupPurgeUnusedFiles((String)backupName).setRepositoryName(BACKUP_REPO_NAME).setLocation(backupLocation).process((SolrClient)cluster.getSolrClient());
                this.addDummyFileToIndex(repository, backupPaths.getIndexDir(), "dummy-files-1");
                this.addDummyFileToIndex(repository, backupPaths.getIndexDir(), "dummy-files-2");
                resp = (CollectionAdminResponse)CollectionAdminRequest.deleteBackupPurgeUnusedFiles((String)backupName).setRepositoryName(BACKUP_REPO_NAME).setLocation(backupLocation).process((SolrClient)cluster.getSolrClient());
                AbstractIncrementalBackupTest.assertEquals((Object)2, ((Map)resp.getResponse().get("deleted")).get("numIndexFiles"));
                new UpdateRequest().deleteByQuery("*:*").commit((SolrClient)cluster.getSolrClient(), this.getCollectionName());
                this.indexDocs(this.getCollectionName(), false);
                this.corruptIndexFiles();
                try {
                    log.info("Create backup after corrupt index files");
                    CollectionAdminRequest.Backup backup = CollectionAdminRequest.backupCollection((String)this.getCollectionName(), (String)backupName).setLocation(backupLocation).setIncremental(true).setMaxNumberBackupPoints(3).setRepositoryName(BACKUP_REPO_NAME);
                    if (AbstractIncrementalBackupTest.random().nextBoolean()) {
                        RequestStatusState state = backup.processAndWait((SolrClient)cluster.getSolrClient(), 1000L);
                        if (state != RequestStatusState.FAILED) {
                            AbstractIncrementalBackupTest.fail((String)"This backup should be failed");
                        }
                        break block11;
                    }
                    CollectionAdminResponse rsp = (CollectionAdminResponse)backup.process((SolrClient)cluster.getSolrClient());
                    AbstractIncrementalBackupTest.fail((String)"This backup should be failed");
                }
                catch (Exception e) {
                    log.error("expected", (Throwable)e);
                }
            }
        }
    }

    @Test
    public void testSkipConfigset() throws Exception {
        String backupLocation;
        this.setTestSuffix("testskipconfigset");
        String backupCollectionName = this.getCollectionName();
        String restoreCollectionName = backupCollectionName + "-restore";
        CloudSolrClient solrClient = cluster.getSolrClient();
        CollectionAdminRequest.createCollection((String)backupCollectionName, (String)"conf1", (int)2, (int)1).process((SolrClient)solrClient);
        int numDocs = this.indexDocs(backupCollectionName, true);
        String backupName = BACKUPNAME_PREFIX + this.testSuffix;
        try (BackupRepository repository = cluster.getJettySolrRunner(0).getCoreContainer().newBackupRepository(BACKUP_REPO_NAME);){
            backupLocation = repository.getBackupLocation(this.getBackupLocation());
            CollectionAdminRequest.backupCollection((String)backupCollectionName, (String)backupName).setLocation(backupLocation).setBackupConfigset(false).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)cluster.getSolrClient(), 100L);
            AbstractIncrementalBackupTest.assertFalse((String)("Configset shouldn't be part of the backup but found:\n" + TrackingBackupRepository.directoriesCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.directoriesCreated().stream().anyMatch(f -> f.getPath().contains("configs/conf1")));
            AbstractIncrementalBackupTest.assertFalse((String)("Configset shouldn't be part of the backup but found:\n" + TrackingBackupRepository.outputsCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.outputsCreated().stream().anyMatch(f -> f.getPath().contains("configs/conf1")));
            AbstractIncrementalBackupTest.assertFalse((String)("solrconfig.xml shouldn't be part of the backup but found:\n" + TrackingBackupRepository.outputsCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.outputsCreated().stream().anyMatch(f -> f.getPath().contains("solrconfig.xml")));
            AbstractIncrementalBackupTest.assertFalse((String)("schema.xml shouldn't be part of the backup but found:\n" + TrackingBackupRepository.outputsCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.outputsCreated().stream().anyMatch(f -> f.getPath().contains("schema.xml")));
            CollectionAdminRequest.restoreCollection((String)restoreCollectionName, (String)backupName).setLocation(backupLocation).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)solrClient, 500L);
            AbstractDistribZkTestBase.waitForRecoveriesToFinish(restoreCollectionName, ZkStateReader.from((CloudSolrClient)solrClient), log.isDebugEnabled(), false, 3L);
            AbstractIncrementalBackupTest.assertEquals((long)numDocs, (long)cluster.getSolrClient().query(restoreCollectionName, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
        }
        TrackingBackupRepository.clear();
        repository = cluster.getJettySolrRunner(0).getCoreContainer().newBackupRepository(BACKUP_REPO_NAME);
        try {
            backupLocation = repository.getBackupLocation(this.getBackupLocation());
            CollectionAdminRequest.backupCollection((String)backupCollectionName, (String)backupName).setLocation(backupLocation).setBackupConfigset(true).setRepositoryName(BACKUP_REPO_NAME).processAndWait((SolrClient)cluster.getSolrClient(), 100L);
            AbstractIncrementalBackupTest.assertTrue((String)("Configset should be part of the backup but not found:\n" + TrackingBackupRepository.directoriesCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.directoriesCreated().stream().anyMatch(f -> f.getPath().contains("configs/conf1")));
            AbstractIncrementalBackupTest.assertTrue((String)("Configset should be part of the backup but not found:\n" + TrackingBackupRepository.outputsCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.outputsCreated().stream().anyMatch(f -> f.getPath().contains("configs/conf1")));
            AbstractIncrementalBackupTest.assertTrue((String)("solrconfig.xml should be part of the backup but not found:\n" + TrackingBackupRepository.outputsCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.outputsCreated().stream().anyMatch(f -> f.getPath().contains("solrconfig.xml")));
            AbstractIncrementalBackupTest.assertTrue((String)("schema.xml should be part of the backup but not found:\n" + TrackingBackupRepository.outputsCreated().stream().map(URI::toString).collect(Collectors.joining("\n"))), (boolean)TrackingBackupRepository.outputsCreated().stream().anyMatch(f -> f.getPath().contains("schema.xml")));
        }
        finally {
            if (repository != null) {
                repository.close();
            }
        }
    }

    public void testBackupProperties() throws IOException {
        BackupProperties p = BackupProperties.create((String)"backupName", (String)"collection1", (String)"collection1-ext", (String)"conf1", Map.of("foo", "bar", "aaa", "bbb"));
        try (BackupRepository repository = cluster.getJettySolrRunner(0).getCoreContainer().newBackupRepository(BACKUP_REPO_NAME);){
            String backupLocation = repository.getBackupLocation(this.getBackupLocation());
            URI dest = repository.resolve(repository.createURI(backupLocation), new String[]{"props-file.properties"});
            try (OutputStreamWriter propsWriter = new OutputStreamWriter(repository.createOutput(dest), StandardCharsets.UTF_8);){
                p.store((Writer)propsWriter);
            }
            BackupProperties propsRead = BackupProperties.readFrom((BackupRepository)repository, (URI)repository.createURI(backupLocation), (String)"props-file.properties");
            AbstractIncrementalBackupTest.assertEquals((Object)p.getCollection(), (Object)propsRead.getCollection());
            AbstractIncrementalBackupTest.assertEquals((Object)p.getCollectionAlias(), (Object)propsRead.getCollectionAlias());
            AbstractIncrementalBackupTest.assertEquals((Object)p.getConfigName(), (Object)propsRead.getConfigName());
            AbstractIncrementalBackupTest.assertEquals((Object)p.getIndexVersion(), (Object)propsRead.getIndexVersion());
            AbstractIncrementalBackupTest.assertEquals((Object)p.getExtraProperties(), (Object)propsRead.getExtraProperties());
            AbstractIncrementalBackupTest.assertEquals((Object)p.getBackupName(), (Object)propsRead.getBackupName());
        }
    }

    protected void corruptIndexFiles() throws IOException {
        Path fileToCorrupt;
        ArrayList slices = new ArrayList(AbstractIncrementalBackupTest.getCollectionState(this.getCollectionName()).getSlices());
        Replica leader = ((Slice)slices.get(AbstractIncrementalBackupTest.random().nextInt(slices.size()))).getLeader();
        JettySolrRunner leaderNode = cluster.getReplicaJetty(leader);
        try (SolrCore solrCore = leaderNode.getCoreContainer().getCore(leader.getCoreName());){
            List indexFiles;
            HashSet fileNames = new HashSet(solrCore.getDeletionPolicy().getLatestCommit().getFileNames());
            try (Stream<Path> indexFolderFiles = Files.list(Path.of(solrCore.getIndexDir(), new String[0]));){
                indexFiles = indexFolderFiles.filter(x -> fileNames.contains(x.getFileName().toString())).sorted().collect(Collectors.toList());
            }
            if (indexFiles.isEmpty()) {
                return;
            }
            fileToCorrupt = (Path)indexFiles.get(AbstractIncrementalBackupTest.random().nextInt(indexFiles.size()));
        }
        byte[] contents = Files.readAllBytes(fileToCorrupt);
        for (int i = 1; i < 5; ++i) {
            int key = contents.length - CodecUtil.footerLength() - i;
            if (key < 0) continue;
            contents[key] = (byte)(contents[key] + 1);
        }
        Files.write(fileToCorrupt, contents, new OpenOption[0]);
    }

    private void addDummyFileToIndex(BackupRepository repository, URI indexDir, String fileName) throws IOException {
        try (OutputStream os = repository.createOutput(repository.resolve(indexDir, new String[]{fileName}));){
            os.write(100);
            os.write(101);
            os.write(102);
        }
    }

    private void backupRestoreThenCheck(CloudSolrClient solrClient, IncrementalBackupVerifier verifier) throws Exception {
        verifier.incrementalBackupThenVerify();
        if (AbstractIncrementalBackupTest.random().nextBoolean()) {
            this.simpleRestoreAndCheckDocCount(solrClient, verifier.backupLocation, verifier.backupName);
        }
    }

    private void simpleRestoreAndCheckDocCount(CloudSolrClient solrClient, String backupLocation, String backupName) throws Exception {
        Map<String, Integer> origShardToDocCount = AbstractCloudBackupRestoreTestCase.getShardToDocCountMap(solrClient, AbstractIncrementalBackupTest.getCollectionState(this.getCollectionName()));
        String restoreCollectionName = this.getCollectionName() + "_restored";
        this.randomlyPrecreateRestoreCollection(restoreCollectionName, "conf1", 2, 2);
        CollectionAdminRequest.restoreCollection((String)restoreCollectionName, (String)backupName).setLocation(backupLocation).setRepositoryName(BACKUP_REPO_NAME).process((SolrClient)solrClient);
        AbstractDistribZkTestBase.waitForRecoveriesToFinish(restoreCollectionName, ZkStateReader.from((CloudSolrClient)solrClient), log.isDebugEnabled(), true, 30L);
        AbstractIncrementalBackupTest.assertEquals(origShardToDocCount, AbstractCloudBackupRestoreTestCase.getShardToDocCountMap(solrClient, AbstractIncrementalBackupTest.getCollectionState(restoreCollectionName)));
        CollectionAdminRequest.deleteCollection((String)restoreCollectionName).process((SolrClient)solrClient);
    }

    private void indexDocs(String collectionName, int numDocs, boolean useUUID) throws Exception {
        Random random = new Random(docsSeed);
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(numDocs);
        for (int i = 0; i < numDocs; ++i) {
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("id", useUUID ? UUID.randomUUID().toString() : Integer.valueOf(i));
            doc.addField("shard_s", (Object)("shard" + (1 + random.nextInt(2))));
            docs.add(doc);
        }
        CloudSolrClient client = cluster.getSolrClient();
        client.add(collectionName, docs);
        client.commit(collectionName);
        log.info("Indexed {} docs to collection: {}", (Object)numDocs, (Object)collectionName);
    }

    protected int indexDocs(String collectionName, boolean useUUID) throws Exception {
        Random random = new Random(docsSeed);
        int numDocs = random.nextInt(100) + 5;
        this.indexDocs(collectionName, numDocs, useUUID);
        return numDocs;
    }

    private void randomlyPrecreateRestoreCollection(String restoreCollectionName, String configName, int numShards, int numReplicas) throws Exception {
        if (AbstractIncrementalBackupTest.random().nextBoolean()) {
            CollectionAdminRequest.createCollection((String)restoreCollectionName, (String)configName, (int)numShards, (int)numReplicas).process((SolrClient)cluster.getSolrClient());
            cluster.waitForActiveCollection(restoreCollectionName, numShards, numShards * numReplicas);
        }
    }

    private long getNumDocsInCollection(String collectionName) throws Exception {
        return ((QueryResponse)new QueryRequest((SolrParams)new SolrQuery("*:*")).process((SolrClient)cluster.getSolrClient(), collectionName)).getResults().getNumFound();
    }

    private class IncrementalBackupVerifier {
        private BackupRepository repository;
        private URI backupURI;
        private String backupLocation;
        private String backupName;
        private BackupFilePaths incBackupFiles;
        private Map<String, Collection<String>> lastShardCommitToBackupFiles = new HashMap<String, Collection<String>>();
        private int numBackup = -1;
        private int maxNumberOfBackupToKeep = 4;

        IncrementalBackupVerifier(BackupRepository repository, String backupLocation, String backupName, String collection, int maxNumberOfBackupToKeep) {
            this.repository = repository;
            this.backupLocation = backupLocation;
            this.backupURI = repository.resolveDirectory(repository.createURI(backupLocation), new String[]{backupName, collection});
            this.incBackupFiles = new BackupFilePaths(repository, this.backupURI);
            this.backupName = backupName;
            this.maxNumberOfBackupToKeep = maxNumberOfBackupToKeep;
        }

        private void backupThenWait() throws SolrServerException, IOException {
            CollectionAdminRequest.Backup backup = CollectionAdminRequest.backupCollection((String)AbstractIncrementalBackupTest.this.getCollectionName(), (String)this.backupName).setLocation(this.backupLocation).setIncremental(true).setMaxNumberBackupPoints(this.maxNumberOfBackupToKeep).setRepositoryName(AbstractIncrementalBackupTest.BACKUP_REPO_NAME);
            if (LuceneTestCase.random().nextBoolean()) {
                try {
                    RequestStatusState state = backup.processAndWait((SolrClient)cluster.getSolrClient(), 1000L);
                    Assert.assertEquals((Object)RequestStatusState.COMPLETED, (Object)state);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("interrupted", (Throwable)e);
                }
                ++this.numBackup;
            } else {
                CollectionAdminResponse rsp = (CollectionAdminResponse)backup.process((SolrClient)cluster.getSolrClient());
                Assert.assertEquals((long)0L, (long)rsp.getStatus());
                Map resp = (Map)rsp.getResponse().get("response");
                ++this.numBackup;
                Assert.assertEquals((Object)this.numBackup, resp.get("backupId"));
            }
        }

        void incrementalBackupThenVerify() throws IOException, SolrServerException {
            int numCopiedFiles = TrackingBackupRepository.copiedFiles().size();
            this.backupThenWait();
            List<URI> newFilesCopiedOver = TrackingBackupRepository.copiedFiles().subList(numCopiedFiles, TrackingBackupRepository.copiedFiles().size());
            this.verify(newFilesCopiedOver);
        }

        ShardBackupMetadata getLastShardBackupId(String shardName) throws IOException {
            ShardBackupId shardBackupId = (ShardBackupId)BackupProperties.readFromLatest((BackupRepository)this.repository, (URI)this.backupURI).flatMap(bp -> bp.getShardBackupIdFor(shardName)).get();
            return ShardBackupMetadata.from((BackupRepository)this.repository, (URI)new BackupFilePaths(this.repository, this.backupURI).getShardBackupMetadataDir(), (ShardBackupId)shardBackupId);
        }

        private void assertIndexInputEquals(IndexInput in1, IndexInput in2) throws IOException {
            Assert.assertEquals((long)in1.length(), (long)in2.length());
            int i = 0;
            while ((long)i < in1.length()) {
                Assert.assertEquals((long)in1.readByte(), (long)in2.readByte());
                ++i;
            }
        }

        private void assertFolderAreSame(URI uri1, URI uri2) throws IOException {
            Object[] files1 = this.repository.listAll(uri1);
            Object[] files2 = this.repository.listAll(uri2);
            Arrays.sort(files1);
            Arrays.sort(files2);
            Assert.assertArrayEquals((Object[])files1, (Object[])files2);
            for (int i = 0; i < files1.length; ++i) {
                URI file1Uri = this.repository.resolve(uri1, new String[]{files1[i]});
                URI file2Uri = this.repository.resolve(uri2, new String[]{files2[i]});
                Assert.assertEquals((Object)this.repository.getPathType(file1Uri), (Object)this.repository.getPathType(file2Uri));
                if (this.repository.getPathType(file1Uri) == BackupRepository.PathType.DIRECTORY) {
                    this.assertFolderAreSame(file1Uri, file2Uri);
                    continue;
                }
                try (IndexInput in1 = this.repository.openInput(uri1, (String)files1[i], IOContext.READONCE);
                     IndexInput in2 = this.repository.openInput(uri1, (String)files1[i], IOContext.READONCE);){
                    this.assertIndexInputEquals(in1, in2);
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verify(List<URI> newFilesCopiedOver) throws IOException {
            BackupId prevBackupId = new BackupId(Math.max(0, this.numBackup - 1));
            URI backupPropertiesFile = this.repository.resolve(this.backupURI, new String[]{"backup_" + this.numBackup + ".properties"});
            URI zkBackupFolder = this.repository.resolveDirectory(this.backupURI, new String[]{"zk_backup_" + this.numBackup});
            Assert.assertTrue((boolean)this.repository.exists(backupPropertiesFile));
            Assert.assertTrue((boolean)this.repository.exists(zkBackupFolder));
            this.assertFolderAreSame(this.repository.resolveDirectory(this.backupURI, new String[]{BackupFilePaths.getZkStateDir((BackupId)prevBackupId)}), zkBackupFolder);
            for (Slice slice : AbstractIncrementalBackupTest.getCollectionState(AbstractIncrementalBackupTest.this.getCollectionName()).getSlices()) {
                Replica leader = slice.getLeader();
                ShardBackupMetadata shardBackupMetadata = this.getLastShardBackupId(slice.getName());
                Assert.assertNotNull((Object)shardBackupMetadata);
                SolrCore solrCore = cluster.getReplicaJetty(leader).getCoreContainer().getCore(leader.getCoreName());
                try {
                    Directory dir = solrCore.getDirectoryFactory().get(solrCore.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, solrCore.getSolrConfig().indexConfig.lockType);
                    try {
                        URI indexDir = this.incBackupFiles.getIndexDir();
                        IndexCommit lastCommit = solrCore.getDeletionPolicy().getLatestCommit();
                        Collection newBackupFiles = this.newIndexFilesComparedToLastBackup(slice.getName(), lastCommit).stream().map(indexFile -> {
                            Optional backedFile = shardBackupMetadata.getFile(indexFile);
                            Assert.assertTrue((boolean)backedFile.isPresent());
                            return ((ShardBackupMetadata.BackedFile)backedFile.get()).uniqueFileName;
                        }).collect(Collectors.toList());
                        lastCommit.getFileNames().forEach(f -> {
                            Optional backedFile = shardBackupMetadata.getFile(f);
                            Assert.assertTrue((boolean)backedFile.isPresent());
                            String uniqueFileName = ((ShardBackupMetadata.BackedFile)backedFile.get()).uniqueFileName;
                            if (newBackupFiles.contains(uniqueFileName)) {
                                Assert.assertTrue((boolean)newFilesCopiedOver.contains(this.repository.resolve(indexDir, new String[]{uniqueFileName})));
                            }
                            try {
                                Checksum localChecksum = this.repository.checksum(dir, f);
                                Checksum remoteChecksum = ((ShardBackupMetadata.BackedFile)backedFile.get()).fileChecksum;
                                Assert.assertEquals((long)localChecksum.checksum, (long)remoteChecksum.checksum);
                                Assert.assertEquals((long)localChecksum.size, (long)remoteChecksum.size);
                            }
                            catch (IOException e) {
                                throw new AssertionError((Object)e);
                            }
                        });
                        Assert.assertEquals((String)"Incremental backup stored more files than needed", (long)lastCommit.getFileNames().size(), (long)shardBackupMetadata.listOriginalFileNames().size());
                    }
                    finally {
                        solrCore.getDirectoryFactory().release(dir);
                    }
                }
                finally {
                    if (solrCore == null) continue;
                    solrCore.close();
                }
            }
        }

        private Collection<String> newIndexFilesComparedToLastBackup(String shardName, IndexCommit currentCommit) throws IOException {
            Collection<String> oldFiles = this.lastShardCommitToBackupFiles.put(shardName, currentCommit.getFileNames());
            if (oldFiles == null) {
                oldFiles = new ArrayList<String>();
            }
            ArrayList<String> newFiles = new ArrayList<String>(currentCommit.getFileNames());
            newFiles.removeAll(oldFiles);
            return newFiles;
        }
    }
}

