/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.DigestZkACLProvider;
import org.apache.solr.common.cloud.DigestZkCredentialsProvider;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.VMParamsZkCredentialsInjector;
import org.apache.solr.common.cloud.ZkCredentialsInjector;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDigestZkACLAndCredentialsProvidersTestBase
extends SolrTestCaseJ4 {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Charset DATA_ENCODING = StandardCharsets.UTF_8;
    private static final String ALL_USERNAME = "connectAndAllACLUsername";
    private static final String ALL_PASSWORD = "connectAndAllACLPassword";
    private static final String READONLY_USERNAME = "readonlyACLUsername";
    private static final String READONLY_PASSWORD = "readonlyACLPassword";
    public static final String SECRET_NAME = "zkCredentialsSecret";
    protected ZkTestServer zkServer;
    protected Path zkDir;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("solrcloud.skip.autorecovery", "true");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("solrcloud.skip.autorecovery");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (log.isInfoEnabled()) {
            log.info("####SETUP_START {}", (Object)this.getTestName());
        }
        AbstractDigestZkACLAndCredentialsProvidersTestBase.createTempDir();
        this.zkDir = AbstractDigestZkACLAndCredentialsProvidersTestBase.createTempDir().resolve("zookeeper/server1/data");
        log.info("ZooKeeper dataDir:{}", (Object)this.zkDir);
        this.setSecuritySystemProperties();
        this.zkServer = new ZkTestServer(this.zkDir);
        this.zkServer.run(false);
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        this.setDigestZkSystemProps();
        System.setProperty("zkCredentialsInjector", AllAndReadonlyCredentialZkCredentialsInjector.class.getName());
        SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 45000, 45000);
        zkClient.makePath("/solr", false, true);
        zkClient.close();
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        zkClient.create("/protectedCreateNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.makePath("/protectedMakePathNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.create("/security", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.close();
        this.clearSecuritySystemProperties();
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        zkClient.getZooKeeper().addAuthInfo("digest", "connectAndAllACLUsername:connectAndAllACLPassword".getBytes(StandardCharsets.UTF_8));
        zkClient.create("/unprotectedCreateNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.makePath("/unprotectedMakePathNode", "content".getBytes(DATA_ENCODING), CreateMode.PERSISTENT, false);
        zkClient.close();
        this.setDigestZkSystemProps();
        if (log.isInfoEnabled()) {
            log.info("####SETUP_END {}", (Object)this.getTestName());
        }
    }

    private void setDigestZkSystemProps() {
        System.setProperty("zkCredentialsProvider", DigestZkCredentialsProvider.class.getName());
        System.setProperty("zkACLProvider", DigestZkACLProvider.class.getName());
    }

    @Override
    public void tearDown() throws Exception {
        this.zkServer.shutdown();
        this.clearSecuritySystemProperties();
        super.tearDown();
    }

    @Test
    public void testNoCredentials() throws Exception {
        ArrayList<TestZkCredentialsInjector> testZkCredentialsInjectors = new ArrayList<TestZkCredentialsInjector>(){
            {
                this.add(new TestZkCredentialsInjector(NoCredentialZkCredentialsInjector.class));
                this.add(new TestZkCredentialsInjector(VMParamsZkCredentialsInjector.class));
            }
        };
        this.testInjectors((List<TestZkCredentialsInjector>)testZkCredentialsInjectors, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void testWrongCredentials() throws Exception {
        ArrayList<TestZkCredentialsInjector> testZkCredentialsInjectors = new ArrayList<TestZkCredentialsInjector>(){
            {
                this.add(new TestZkCredentialsInjector(WrongAllCredentialZkCredentialsInjector.class));
                this.add(new TestZkCredentialsInjector(VMParamsZkCredentialsInjector.class, Arrays.asList("zkDigestUsername", "zkDigestPassword"), Arrays.asList(AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_USERNAME, "connectAndAllACLPasswordWrong")));
            }
        };
        this.testInjectors((List<TestZkCredentialsInjector>)testZkCredentialsInjectors, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void testAllCredentials() throws Exception {
        ArrayList<TestZkCredentialsInjector> testZkCredentialsInjectors = new ArrayList<TestZkCredentialsInjector>(){
            {
                this.add(new TestZkCredentialsInjector(AllCredentialZkCredentialsInjector.class));
                this.add(new TestZkCredentialsInjector(VMParamsZkCredentialsInjector.class, Arrays.asList("zkDigestUsername", "zkDigestPassword"), Arrays.asList(AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_USERNAME, AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_PASSWORD)));
            }
        };
        this.testInjectors((List<TestZkCredentialsInjector>)testZkCredentialsInjectors, true, true, true, true, true, true, true, true, true, true);
    }

    @Test
    public void testReadonlyCredentials() throws Exception {
        ArrayList<TestZkCredentialsInjector> testZkCredentialsInjectors = new ArrayList<TestZkCredentialsInjector>(){
            {
                this.add(new TestZkCredentialsInjector(ConnectWithReadonlyCredsInjector.class));
                this.add(new TestZkCredentialsInjector(VMParamsZkCredentialsInjector.class, Arrays.asList("zkDigestUsername", "zkDigestPassword"), Arrays.asList(AbstractDigestZkACLAndCredentialsProvidersTestBase.READONLY_USERNAME, AbstractDigestZkACLAndCredentialsProvidersTestBase.READONLY_PASSWORD)));
            }
        };
        this.testInjectors((List<TestZkCredentialsInjector>)testZkCredentialsInjectors, true, true, false, false, false, false, false, false, false, false);
    }

    protected void testInjectors(List<TestZkCredentialsInjector> testZkCredentialsInjectors, boolean getData, boolean list, boolean create, boolean setData, boolean delete, boolean secureGet, boolean secureList, boolean secureCreate, boolean secureSet, boolean secureDelete) throws Exception {
        for (TestZkCredentialsInjector testZkCredentialsInjector : testZkCredentialsInjectors) {
            this.tearDown();
            this.setUp();
            testZkCredentialsInjector.setSystemProps();
            try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
                AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, getData, list, create, setData, delete, secureGet, secureList, secureCreate, secureSet, secureDelete);
            }
        }
    }

    @Test
    public void testRepairACL() throws Exception {
        this.clearSecuritySystemProperties();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            zkClient.getZooKeeper().addAuthInfo("digest", "connectAndAllACLUsername:connectAndAllACLPassword".getBytes(StandardCharsets.UTF_8));
            zkClient.create("/security.json", "{}".getBytes(StandardCharsets.UTF_8), CreateMode.PERSISTENT, false);
            AbstractDigestZkACLAndCredentialsProvidersTestBase.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)zkClient.getACL("/security.json", null, false));
        }
        this.setSecuritySystemProperties();
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        try {
            ZkController.createClusterZkNodes((SolrZkClient)zkClient);
            AbstractDigestZkACLAndCredentialsProvidersTestBase.assertNotEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)zkClient.getACL("/security.json", null, false));
        }
        finally {
            zkClient.close();
        }
        this.useZkCredentialsInjector(ConnectWithReadonlyCredsInjector.class);
        zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);
        try {
            KeeperException.NoAuthException e = (KeeperException.NoAuthException)AbstractDigestZkACLAndCredentialsProvidersTestBase.assertThrows(KeeperException.NoAuthException.class, () -> zkClient.getData("/security.json", null, null, false));
            AbstractDigestZkACLAndCredentialsProvidersTestBase.assertEquals((Object)"/security.json", (Object)e.getPath());
        }
        finally {
            zkClient.close();
        }
    }

    private void useZkCredentialsInjector(Class<?> zkCredentialsInjectorClass) {
        this.clearSecuritySystemProperties();
        this.setDigestZkSystemProps();
        System.setProperty("zkCredentialsInjector", zkCredentialsInjectorClass.getName());
    }

    private void setSecuritySystemProperties() {
        System.setProperty("zkCredentialsProvider", DigestZkCredentialsProvider.class.getName());
        System.setProperty("zkACLProvider", DigestZkACLProvider.class.getName());
        System.setProperty("zkCredentialsInjector", AllAndReadonlyCredentialZkCredentialsInjector.class.getName());
    }

    private void clearSecuritySystemProperties() {
        System.clearProperty("zkCredentialsProvider");
        System.clearProperty("zkACLProvider");
        System.clearProperty("zkCredentialsInjector");
    }

    public static void doTest(SolrZkClient zkClient, boolean getData, boolean list, boolean create, boolean setData, boolean delete, boolean secureGet, boolean secureList, boolean secureCreate, boolean secureSet, boolean secureDelete) throws Exception {
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/protectedCreateNode", getData, list, create, setData, delete);
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/protectedMakePathNode", getData, list, create, setData, delete);
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/unprotectedCreateNode", true, true, true, true, delete);
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/unprotectedMakePathNode", true, true, true, true, delete);
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, "/security", secureGet, secureList, secureCreate, secureSet, secureDelete);
    }

    protected static void doTest(SolrZkClient zkClient, String path, boolean getData, boolean list, boolean create, boolean setData, boolean delete) throws Exception {
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(getData, () -> zkClient.getData(path, null, null, false));
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(list, () -> zkClient.getChildren(path, null, false));
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(create, () -> {
            zkClient.create(path + "/subnode", null, CreateMode.PERSISTENT, false);
            zkClient.delete(path + "/subnode", -1, false);
        });
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(create, () -> {
            zkClient.makePath(path + "/subnode/subsubnode", false);
            zkClient.delete(path + "/subnode/subsubnode", -1, false);
            zkClient.delete(path + "/subnode", -1, false);
        });
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(setData, () -> zkClient.setData(path, (byte[])null, false));
        AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(delete, () -> zkClient.delete(path, -1, false));
    }

    private static void doTest(boolean shouldSucceed, ExceptingRunnable action) throws Exception {
        if (shouldSucceed) {
            action.run();
        } else {
            AbstractDigestZkACLAndCredentialsProvidersTestBase.expectThrows(KeeperException.NoAuthException.class, action::run);
        }
    }

    @Test
    public void testVMParamsAllCredentialsFromFile() throws Exception {
        this.useVMParamsAllCredentialsFromFile();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, true, true, true, true, true, true, true, true, true, true);
        }
    }

    @Test
    public void testVMParamsReadonlyCredentialsFromFile() throws Exception {
        this.useVMParamsReadonlyCredentialsFromFile();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000);){
            AbstractDigestZkACLAndCredentialsProvidersTestBase.doTest(zkClient, true, true, false, false, false, false, false, false, false, false);
        }
    }

    private void useVMParamsAllCredentialsFromFile() throws IOException {
        this.useVMParamsCredentialsFromFile(ALL_USERNAME, ALL_PASSWORD);
    }

    private void useVMParamsReadonlyCredentialsFromFile() throws IOException {
        this.useVMParamsCredentialsFromFile(READONLY_USERNAME, READONLY_PASSWORD);
    }

    private void useVMParamsCredentialsFromFile(String username, String password) throws IOException {
        Properties props = new Properties();
        props.setProperty("zkDigestUsername", username);
        props.setProperty("zkDigestPassword", password);
        String credsFile = this.saveCredentialsFile(props);
        this.useZkCredentialsInjector(VMParamsZkCredentialsInjector.class);
        System.setProperty("zkDigestCredentialsFile", credsFile);
    }

    private String saveCredentialsFile(Properties props) throws IOException {
        Path tmp = AbstractDigestZkACLAndCredentialsProvidersTestBase.createTempFile((String)"zk-creds", (String)"properties");
        try (FileWriter w = new FileWriter(tmp.toFile(), StandardCharsets.UTF_8);){
            props.store(w, "test");
        }
        return tmp.toAbsolutePath().toString();
    }

    class TestZkCredentialsInjector {
        private final Class<?> zkCredentialsInjectorClass;
        private final List<String> systemPropsKeys;
        private final List<String> systemPropsValues;

        public TestZkCredentialsInjector(Class<?> zkCredentialsInjectorClass) {
            this(zkCredentialsInjectorClass, Collections.emptyList(), Collections.emptyList());
        }

        public TestZkCredentialsInjector(Class<?> zkCredentialsInjectorClass, List<String> systemPropsKeys, List<String> systemPropsValues) {
            this.zkCredentialsInjectorClass = zkCredentialsInjectorClass;
            this.systemPropsKeys = systemPropsKeys;
            this.systemPropsValues = systemPropsValues;
        }

        private void setSystemProps() {
            AbstractDigestZkACLAndCredentialsProvidersTestBase.this.clearSecuritySystemProperties();
            AbstractDigestZkACLAndCredentialsProvidersTestBase.this.setDigestZkSystemProps();
            System.setProperty("zkCredentialsInjector", this.zkCredentialsInjectorClass.getName());
            int i = 0;
            for (String key : this.systemPropsKeys) {
                System.setProperty(key, this.systemPropsValues.get(i++));
            }
        }
    }

    public static class WrongAllCredentialZkCredentialsInjector
    implements ZkCredentialsInjector {
        public List<ZkCredentialsInjector.ZkCredential> getZkCredentials() {
            return new ArrayList<ZkCredentialsInjector.ZkCredential>(){
                {
                    this.add(new ZkCredentialsInjector.ZkCredential(AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_USERNAME, "connectAndAllACLPasswordWrong", ZkCredentialsInjector.ZkCredential.Perms.ALL));
                }
            };
        }
    }

    public static class AllCredentialZkCredentialsInjector
    implements ZkCredentialsInjector {
        public List<ZkCredentialsInjector.ZkCredential> getZkCredentials() {
            return new ArrayList<ZkCredentialsInjector.ZkCredential>(){
                {
                    this.add(new ZkCredentialsInjector.ZkCredential(AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_USERNAME, AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_PASSWORD, ZkCredentialsInjector.ZkCredential.Perms.ALL));
                }
            };
        }
    }

    public static class ConnectWithReadonlyCredsInjector
    implements ZkCredentialsInjector {
        public List<ZkCredentialsInjector.ZkCredential> getZkCredentials() {
            return new ArrayList<ZkCredentialsInjector.ZkCredential>(){
                {
                    this.add(new ZkCredentialsInjector.ZkCredential(AbstractDigestZkACLAndCredentialsProvidersTestBase.READONLY_USERNAME, AbstractDigestZkACLAndCredentialsProvidersTestBase.READONLY_PASSWORD, ZkCredentialsInjector.ZkCredential.Perms.ALL));
                }
            };
        }
    }

    public static class AllAndReadonlyCredentialZkCredentialsInjector
    implements ZkCredentialsInjector {
        public List<ZkCredentialsInjector.ZkCredential> getZkCredentials() {
            return new ArrayList<ZkCredentialsInjector.ZkCredential>(){
                {
                    this.add(new ZkCredentialsInjector.ZkCredential(AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_USERNAME, AbstractDigestZkACLAndCredentialsProvidersTestBase.ALL_PASSWORD, ZkCredentialsInjector.ZkCredential.Perms.ALL));
                    this.add(new ZkCredentialsInjector.ZkCredential(AbstractDigestZkACLAndCredentialsProvidersTestBase.READONLY_USERNAME, AbstractDigestZkACLAndCredentialsProvidersTestBase.READONLY_PASSWORD, ZkCredentialsInjector.ZkCredential.Perms.READ));
                }
            };
        }
    }

    public static class NoCredentialZkCredentialsInjector
    implements ZkCredentialsInjector {
        public List<ZkCredentialsInjector.ZkCredential> getZkCredentials() {
            return Collections.emptyList();
        }
    }

    static interface ExceptingRunnable {
        public void run() throws Exception;
    }
}

