/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ChaosMonkey;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniSolrCloudCluster {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_CLOUD_SOLR_XML = "<solr>\n\n  <str name=\"shareSchema\">${shareSchema:false}</str>\n  <str name=\"configSetBaseDir\">${configSetBaseDir:configsets}</str>\n  <str name=\"coreRootDirectory\">${coreRootDirectory:.}</str>\n  <str name=\"collectionsHandler\">${collectionsHandler:solr.CollectionsHandler}</str>\n\n  <shardHandlerFactory name=\"shardHandlerFactory\" class=\"HttpShardHandlerFactory\">\n    <str name=\"urlScheme\">${urlScheme:}</str>\n    <int name=\"socketTimeout\">${socketTimeout:90000}</int>\n    <int name=\"connTimeout\">${connTimeout:15000}</int>\n  </shardHandlerFactory>\n\n  <solrcloud>\n    <str name=\"host\">127.0.0.1</str>\n    <int name=\"hostPort\">${hostPort:8983}</int>\n    <str name=\"hostContext\">${hostContext:solr}</str>\n    <int name=\"zkClientTimeout\">${solr.zkclienttimeout:30000}</int>\n    <bool name=\"genericCoreNodeNames\">${genericCoreNodeNames:true}</bool>\n    <int name=\"leaderVoteWait\">10000</int>\n    <int name=\"distribUpdateConnTimeout\">${distribUpdateConnTimeout:45000}</int>\n    <int name=\"distribUpdateSoTimeout\">${distribUpdateSoTimeout:340000}</int>\n    <str name=\"zkCredentialsProvider\">${zkCredentialsProvider:org.apache.solr.common.cloud.DefaultZkCredentialsProvider}</str> \n    <str name=\"zkACLProvider\">${zkACLProvider:org.apache.solr.common.cloud.DefaultZkACLProvider}</str> \n  </solrcloud>\n  \n</solr>\n";
    private ZkTestServer zkServer;
    private final boolean externalZkServer;
    private final List<JettySolrRunner> jettys = new CopyOnWriteArrayList<JettySolrRunner>();
    private final Path baseDir;
    private final CloudSolrClient solrClient;
    private final JettyConfig jettyConfig;
    private final ExecutorService executorLauncher = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("jetty-launcher"));
    private final ExecutorService executorCloser = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("jetty-closer"));
    private final AtomicInteger nodeIds = new AtomicInteger();

    public MiniSolrCloudCluster(int numServers, Path baseDir, JettyConfig jettyConfig) throws Exception {
        this(numServers, baseDir, DEFAULT_CLOUD_SOLR_XML, jettyConfig, null);
    }

    public MiniSolrCloudCluster(int numServers, String hostContext, Path baseDir, String solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        this(numServers, hostContext, baseDir, solrXml, extraServlets, extraRequestFilters, null);
    }

    public MiniSolrCloudCluster(int numServers, String hostContext, Path baseDir, String solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        this(numServers, baseDir, solrXml, JettyConfig.builder().setContext(hostContext).withSSLConfig(sslConfig).withFilters(extraRequestFilters).withServlets(extraServlets).build());
    }

    public MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, null);
    }

    public MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, zkTestServer, Optional.empty());
    }

    MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer, Optional<String> securityJson) throws Exception {
        Objects.requireNonNull(securityJson);
        this.baseDir = Objects.requireNonNull(baseDir);
        this.jettyConfig = Objects.requireNonNull(jettyConfig);
        log.info("Starting cluster of {} servers in {}", (Object)numServers, (Object)baseDir);
        Files.createDirectories(baseDir, new FileAttribute[0]);
        boolean bl = this.externalZkServer = zkTestServer != null;
        if (!this.externalZkServer) {
            String zkDir = baseDir.resolve("zookeeper/server1/data").toString();
            zkTestServer = new ZkTestServer(zkDir);
            zkTestServer.run();
        }
        this.zkServer = zkTestServer;
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 45000);){
            zkClient.makePath("/solr/solr.xml", solrXml.getBytes(Charset.defaultCharset()), true);
            if (jettyConfig.sslConfig != null && jettyConfig.sslConfig.isSSLMode()) {
                zkClient.makePath("/solr/clusterprops.json", "{'urlScheme':'https'}".getBytes(StandardCharsets.UTF_8), true);
            }
            if (securityJson.isPresent()) {
                zkClient.makePath("/solr/security.json", securityJson.get().getBytes(Charset.defaultCharset()), true);
            }
        }
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        ArrayList<Callable<JettySolrRunner>> startups = new ArrayList<Callable<JettySolrRunner>>(numServers);
        for (int i = 0; i < numServers; ++i) {
            startups.add(() -> this.startJettySolrRunner(this.newNodeName(), jettyConfig.context, jettyConfig));
        }
        List<Future<JettySolrRunner>> futures = this.executorLauncher.invokeAll(startups);
        Exception startupError = this.checkForExceptions("Error starting up MiniSolrCloudCluster", futures);
        if (startupError != null) {
            try {
                this.shutdown();
            }
            catch (Throwable t) {
                startupError.addSuppressed(t);
            }
            throw startupError;
        }
        this.waitForAllNodes(numServers, 60);
        this.solrClient = this.buildSolrClient();
    }

    private void waitForAllNodes(int numServers, int timeout) throws IOException, InterruptedException {
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 45000);){
            int numliveNodes = 0;
            int retries = timeout;
            String liveNodesPath = "/solr/live_nodes";
            do {
                if (zkClient.exists(liveNodesPath, true).booleanValue() && (numliveNodes = zkClient.getChildren(liveNodesPath, null, true).size()) == numServers) {
                    break;
                }
                if (--retries == 0) {
                    throw new IllegalStateException("Solr servers failed to register with ZK. Current count: " + numliveNodes + "; Expected count: " + numServers);
                }
                Thread.sleep(1000L);
            } while (numliveNodes != numServers);
        }
        catch (KeeperException e) {
            throw new IOException("Error communicating with zookeeper", e);
        }
    }

    public void waitForAllNodes(int timeout) throws IOException, InterruptedException {
        this.waitForAllNodes(this.jettys.size(), timeout);
    }

    private String newNodeName() {
        return "node" + this.nodeIds.incrementAndGet();
    }

    private Path createInstancePath(String name) throws IOException {
        Path instancePath = this.baseDir.resolve(name);
        Files.createDirectory(instancePath, new FileAttribute[0]);
        return instancePath;
    }

    public ZkTestServer getZkServer() {
        return this.zkServer;
    }

    public List<JettySolrRunner> getJettySolrRunners() {
        return Collections.unmodifiableList(this.jettys);
    }

    public JettySolrRunner getRandomJetty(Random random) {
        int index = random.nextInt(this.jettys.size());
        return this.jettys.get(index);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        return this.startJettySolrRunner(name, hostContext, extraServlets, extraRequestFilters, null);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        return this.startJettySolrRunner(name, hostContext, JettyConfig.builder().withServlets(extraServlets).withFilters(extraRequestFilters).withSSLConfig(sslConfig).build());
    }

    public JettySolrRunner getJettySolrRunner(int index) {
        return this.jettys.get(index);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, JettyConfig config) throws Exception {
        Path runnerPath = this.createInstancePath(name);
        String context = MiniSolrCloudCluster.getHostContextSuitableForServletContext(hostContext);
        JettyConfig newConfig = JettyConfig.builder((JettyConfig)config).setContext(context).build();
        JettySolrRunner jetty = new JettySolrRunner(runnerPath.toString(), newConfig);
        jetty.start();
        this.jettys.add(jetty);
        return jetty;
    }

    public JettySolrRunner startJettySolrRunner() throws Exception {
        return this.startJettySolrRunner(this.newNodeName(), this.jettyConfig.context, this.jettyConfig);
    }

    public JettySolrRunner stopJettySolrRunner(int index) throws Exception {
        JettySolrRunner jetty = this.jettys.get(index);
        jetty.stop();
        this.jettys.remove(index);
        return jetty;
    }

    public JettySolrRunner startJettySolrRunner(JettySolrRunner jetty) throws Exception {
        jetty.start(false);
        this.jettys.add(jetty);
        return jetty;
    }

    protected JettySolrRunner stopJettySolrRunner(JettySolrRunner jetty) throws Exception {
        jetty.stop();
        return jetty;
    }

    @Deprecated
    public void uploadConfigDir(File configDir, String configName) throws IOException, KeeperException, InterruptedException {
        this.uploadConfigSet(configDir.toPath(), configName);
    }

    public void uploadConfigSet(Path configDir, String configName) throws IOException, KeeperException, InterruptedException {
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000, 45000, null);){
            ZkConfigManager manager = new ZkConfigManager(zkClient);
            manager.uploadConfigDir(configDir, configName);
        }
    }

    public void deleteAllCollections() throws Exception {
        try (ZkStateReader reader = new ZkStateReader(this.solrClient.getZkStateReader().getZkClient());){
            reader.createClusterStateWatchersAndUpdate();
            for (String collection : reader.getClusterState().getCollectionStates().keySet()) {
                CollectionAdminRequest.deleteCollection((String)collection).process((SolrClient)this.solrClient);
            }
        }
    }

    @Deprecated
    public NamedList<Object> createCollection(String name, int numShards, int replicationFactor, String configName, Map<String, String> collectionProperties) throws SolrServerException, IOException {
        return this.createCollection(name, numShards, replicationFactor, configName, null, null, collectionProperties);
    }

    @Deprecated
    public NamedList<Object> createCollection(String name, int numShards, int replicationFactor, String configName, String createNodeSet, String asyncId, Map<String, String> collectionProperties) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.name()});
        params.set("name", new String[]{name});
        params.set("numShards", numShards);
        params.set("replicationFactor", replicationFactor);
        params.set("collection.configName", new String[]{configName});
        if (null != createNodeSet) {
            params.set("createNodeSet", new String[]{createNodeSet});
        }
        if (null != asyncId) {
            params.set("async", new String[]{asyncId});
        }
        if (collectionProperties != null) {
            for (Map.Entry<String, String> property : collectionProperties.entrySet()) {
                params.set("property." + property.getKey(), new String[]{property.getValue()});
            }
        }
        return this.makeCollectionsRequest(params);
    }

    @Deprecated
    public NamedList<Object> deleteCollection(String name) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.DELETE.name()});
        params.set("name", new String[]{name});
        return this.makeCollectionsRequest(params);
    }

    private NamedList<Object> makeCollectionsRequest(ModifiableSolrParams params) throws SolrServerException, IOException {
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        return this.solrClient.request((SolrRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        try {
            IOUtils.closeQuietly((Closeable)this.solrClient);
            this.executorLauncher.shutdown();
            ArrayList<Callable<JettySolrRunner>> shutdowns = new ArrayList<Callable<JettySolrRunner>>(this.jettys.size());
            for (JettySolrRunner jetty : this.jettys) {
                shutdowns.add(() -> this.stopJettySolrRunner(jetty));
            }
            this.jettys.clear();
            List<Future<JettySolrRunner>> futures = this.executorCloser.invokeAll(shutdowns);
            Exception shutdownError = this.checkForExceptions("Error shutting down MiniSolrCloudCluster", futures);
            if (shutdownError != null) {
                throw shutdownError;
            }
        }
        finally {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.executorLauncher);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.executorCloser);
            try {
                if (!this.externalZkServer) {
                    this.zkServer.shutdown();
                }
            }
            finally {
                System.clearProperty("zkHost");
            }
        }
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public CloudSolrClient getSolrClient() {
        return this.solrClient;
    }

    public SolrZkClient getZkClient() {
        return this.solrClient.getZkStateReader().getZkClient();
    }

    protected CloudSolrClient buildSolrClient() {
        return new CloudSolrClient.Builder().withZkHost(this.getZkServer().getZkAddress()).build();
    }

    private static String getHostContextSuitableForServletContext(String ctx) {
        if (ctx == null || "".equals(ctx)) {
            ctx = "/solr";
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    private Exception checkForExceptions(String message, Collection<Future<JettySolrRunner>> futures) throws InterruptedException {
        Exception parsed = new Exception(message);
        boolean ok = true;
        for (Future<JettySolrRunner> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                parsed.addSuppressed(e.getCause());
                ok = false;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw e;
            }
        }
        return ok ? null : parsed;
    }

    public JettySolrRunner getReplicaJetty(Replica replica) {
        for (JettySolrRunner jetty : this.jettys) {
            if (!replica.getCoreUrl().startsWith(jetty.getBaseUrl().toString())) continue;
            return jetty;
        }
        throw new IllegalArgumentException("Cannot find Jetty for a replica with core url " + replica.getCoreUrl());
    }

    public void expireZkSession(JettySolrRunner jetty) {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null) {
            SolrZkClient zkClient = cores.getZkController().getZkClient();
            zkClient.getSolrZooKeeper().closeCnxn();
            long sessionId = zkClient.getSolrZooKeeper().getSessionId();
            this.zkServer.expire(sessionId);
            log.info("Expired zookeeper session {} from node {}", (Object)sessionId, (Object)jetty.getBaseUrl());
        }
    }

    public void injectChaos(Random random) throws Exception {
        JettySolrRunner jetty;
        if (random.nextBoolean()) {
            jetty = this.jettys.get(random.nextInt(this.jettys.size()));
            ChaosMonkey.stop(jetty);
            log.info("============ Restarting jetty");
            ChaosMonkey.start(jetty);
        }
        if (random.nextBoolean()) {
            this.zkServer.shutdown();
            log.info("============ Restarting zookeeper");
            this.zkServer = new ZkTestServer(this.zkServer.getZkDir(), this.zkServer.getPort());
            this.zkServer.run();
        }
        if (random.nextBoolean()) {
            jetty = this.jettys.get(random.nextInt(this.jettys.size()));
            ChaosMonkey.causeConnectionLoss(jetty);
        }
    }
}

