/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.llm.textvectorisation.search;

import java.io.IOException;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.llm.textvectorisation.model.SolrTextToVectorModel;
import org.apache.solr.llm.textvectorisation.store.rest.ManagedTextToVectorModelStore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.neural.KnnQParser;

public class TextToVectorQParserPlugin
extends QParserPlugin
implements ResourceLoaderAware,
ManagedResourceObserver {
    public static final String EMBEDDING_MODEL_PARAM = "model";
    private ManagedTextToVectorModelStore modelStore = null;

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new TextToVectorQParser(qstr, localParams, params, req);
    }

    public void inform(ResourceLoader loader) throws IOException {
        SolrResourceLoader solrResourceLoader = (SolrResourceLoader)loader;
        ManagedTextToVectorModelStore.registerManagedTextToVectorModelStore(solrResourceLoader, this);
    }

    public void onManagedResourceInitialized(NamedList<?> args, ManagedResource res) throws SolrException {
        if (res instanceof ManagedTextToVectorModelStore) {
            this.modelStore = (ManagedTextToVectorModelStore)res;
        }
        if (this.modelStore != null) {
            this.modelStore.loadStoredModels();
        }
    }

    private void checkVectorDimension(int inputVectorDimension, int fieldVectorDimension) {
        if (inputVectorDimension != fieldVectorDimension) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector dimension. The vector value has size " + inputVectorDimension + " while it is expected a vector with size " + fieldVectorDimension);
        }
    }

    private void checkParam(String value, String message) {
        if (value == null || value.isBlank()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
        }
    }

    public class TextToVectorQParser
    extends KnnQParser {
        public TextToVectorQParser(String queryString, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(queryString, localParams, params, req);
        }

        public Query parse() throws SyntaxError {
            TextToVectorQParserPlugin.this.checkParam(this.qstr, "Query string is empty, nothing to vectorise");
            String embeddingModelName = this.localParams.get(TextToVectorQParserPlugin.EMBEDDING_MODEL_PARAM);
            TextToVectorQParserPlugin.this.checkParam(embeddingModelName, "The 'model' parameter is missing");
            SolrTextToVectorModel textToVector = TextToVectorQParserPlugin.this.modelStore.getModel(embeddingModelName);
            if (textToVector != null) {
                SchemaField schemaField = this.req.getCore().getLatestSchema().getField(this.getFieldName());
                DenseVectorField denseVectorType = TextToVectorQParser.getCheckedFieldType((SchemaField)schemaField);
                int fieldDimensions = denseVectorType.getDimension();
                VectorEncoding vectorEncoding = denseVectorType.getVectorEncoding();
                int topK = this.localParams.getInt("topK", 10);
                switch (vectorEncoding) {
                    case FLOAT32: {
                        float[] vectorToSearch = textToVector.vectorise(this.qstr);
                        TextToVectorQParserPlugin.this.checkVectorDimension(vectorToSearch.length, fieldDimensions);
                        return new KnnFloatVectorQuery(schemaField.getName(), vectorToSearch, topK, this.getFilterQuery());
                    }
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Vector Encoding not supported : " + vectorEncoding);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The model requested '" + embeddingModelName + "' can't be found in the store: /schema/text-to-vector-model-store");
        }
    }
}

