/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrEntityProcessor
extends EntityProcessorBase {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOLR_SERVER = "url";
    public static final String QUERY = "query";
    public static final String TIMEOUT = "timeout";
    public static final int TIMEOUT_SECS = 300;
    public static final int ROWS_DEFAULT = 50;
    private SolrClient solrClient = null;
    private String queryString;
    private int rows = 50;
    private String[] filterQueries;
    private String[] fields;
    private String requestHandler;
    private int timeout = 300;

    @Override
    public void destroy() {
        try {
            this.solrClient.close();
        }
        catch (IOException iOException) {
        }
        finally {
            HttpClientUtil.close((HttpClient)((HttpSolrClient)this.solrClient).getHttpClient());
        }
    }

    protected HttpClient getHttpClient() {
        return HttpClientUtil.createClient(null);
    }

    @Override
    protected void firstInit(Context context) {
        super.firstInit(context);
        try {
            String serverPath = context.getResolvedEntityAttribute(SOLR_SERVER);
            if (serverPath == null) {
                throw new DataImportHandlerException(500, "SolrEntityProcessor: parameter 'url' is required");
            }
            HttpClient client = this.getHttpClient();
            URL url = new URL(serverPath);
            if ("xml".equals(context.getResolvedEntityAttribute("wt"))) {
                this.solrClient = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(url.toExternalForm()).withHttpClient(client)).withResponseParser((ResponseParser)new XMLResponseParser())).build();
                LOG.info("using XMLResponseParser");
            } else {
                this.solrClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(url.toExternalForm()).withHttpClient(client)).build();
                LOG.info("using BinaryResponseParser");
            }
        }
        catch (MalformedURLException e) {
            throw new DataImportHandlerException(500, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> nextRow() {
        this.buildIterator();
        return this.getNext();
    }

    protected void buildIterator() {
        if (this.rowIterator != null) {
            SolrDocumentListIterator documentListIterator = (SolrDocumentListIterator)this.rowIterator;
            if (!documentListIterator.hasNext() && documentListIterator.hasMoreRows()) {
                this.nextPage();
            }
        } else {
            Boolean cursor = new Boolean(this.context.getResolvedEntityAttribute("cursorMark"));
            this.rowIterator = cursor == false ? new SolrDocumentListIterator(new SolrDocumentList()) : new SolrDocumentListCursor(new SolrDocumentList(), "*");
            this.nextPage();
        }
    }

    protected void nextPage() {
        ((SolrDocumentListIterator)this.rowIterator).doQuery();
    }

    static /* synthetic */ String[] access$202(SolrEntityProcessor x0, String[] x1) {
        x0.filterQueries = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(SolrEntityProcessor x0, String[] x1) {
        x0.fields = x1;
        return x1;
    }

    class SolrDocumentListIterator
    implements Iterator<Map<String, Object>> {
        private final int start;
        private final int size;
        private final long numFound;
        private final Iterator<SolrDocument> solrDocumentIterator;

        public SolrDocumentListIterator(SolrDocumentList solrDocumentList) {
            this.solrDocumentIterator = solrDocumentList.iterator();
            this.numFound = solrDocumentList.getNumFound();
            this.start = (int)solrDocumentList.getStart();
            this.size = solrDocumentList.size();
        }

        protected QueryResponse doQuery() {
            QueryResponse response;
            block11: {
                String fieldsAsString;
                SolrEntityProcessor.this.queryString = SolrEntityProcessor.this.context.getResolvedEntityAttribute(SolrEntityProcessor.QUERY);
                if (SolrEntityProcessor.this.queryString == null) {
                    throw new DataImportHandlerException(500, "SolrEntityProcessor: parameter 'query' is required");
                }
                String rowsP = SolrEntityProcessor.this.context.getResolvedEntityAttribute("rows");
                if (rowsP != null) {
                    SolrEntityProcessor.this.rows = Integer.parseInt(rowsP);
                }
                String sortParam = SolrEntityProcessor.this.context.getResolvedEntityAttribute("sort");
                String fqAsString = SolrEntityProcessor.this.context.getResolvedEntityAttribute("fq");
                if (fqAsString != null) {
                    SolrEntityProcessor.access$202(SolrEntityProcessor.this, fqAsString.split(","));
                }
                if ((fieldsAsString = SolrEntityProcessor.this.context.getResolvedEntityAttribute("fl")) != null) {
                    SolrEntityProcessor.access$302(SolrEntityProcessor.this, fieldsAsString.split(","));
                }
                SolrEntityProcessor.this.requestHandler = SolrEntityProcessor.this.context.getResolvedEntityAttribute("qt");
                SolrQuery solrQuery = new SolrQuery(SolrEntityProcessor.this.queryString);
                solrQuery.setRows(Integer.valueOf(SolrEntityProcessor.this.rows));
                if (sortParam != null) {
                    solrQuery.setParam("sort", new String[]{sortParam});
                }
                this.passNextPage(solrQuery);
                if (SolrEntityProcessor.this.fields != null) {
                    for (String field : SolrEntityProcessor.this.fields) {
                        solrQuery.addField(field);
                    }
                }
                solrQuery.setRequestHandler(SolrEntityProcessor.this.requestHandler);
                solrQuery.setFilterQueries(SolrEntityProcessor.this.filterQueries);
                response = null;
                try {
                    response = SolrEntityProcessor.this.solrClient.query((SolrParams)solrQuery);
                }
                catch (IOException | SolrServerException | SolrException e) {
                    if ("abort".equals(SolrEntityProcessor.this.onError)) {
                        DataImportHandlerException.wrapAndThrow(500, (Exception)e);
                    }
                    if (!"skip".equals(SolrEntityProcessor.this.onError)) break block11;
                    DataImportHandlerException.wrapAndThrow(301, (Exception)e);
                }
            }
            if (response != null) {
                SolrEntityProcessor.this.rowIterator = this.createNextPageIterator(response);
            }
            return response;
        }

        protected Iterator<Map<String, Object>> createNextPageIterator(QueryResponse response) {
            return new SolrDocumentListIterator(response.getResults());
        }

        protected void passNextPage(SolrQuery solrQuery) {
            String timeoutAsString = SolrEntityProcessor.this.context.getResolvedEntityAttribute(SolrEntityProcessor.TIMEOUT);
            if (timeoutAsString != null) {
                SolrEntityProcessor.this.timeout = Integer.parseInt(timeoutAsString);
            }
            solrQuery.setTimeAllowed(Integer.valueOf(SolrEntityProcessor.this.timeout * 1000));
            solrQuery.setStart(Integer.valueOf(this.getStart() + this.getSize()));
        }

        @Override
        public boolean hasNext() {
            return this.solrDocumentIterator.hasNext();
        }

        @Override
        public Map<String, Object> next() {
            SolrDocument solrDocument = this.solrDocumentIterator.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            Collection fields = solrDocument.getFieldNames();
            for (String field : fields) {
                Object fieldValue = solrDocument.getFieldValue(field);
                map.put(field, fieldValue);
            }
            return map;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }

        public boolean hasMoreRows() {
            return this.numFound > (long)(this.start + this.size);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class SolrDocumentListCursor
    extends SolrDocumentListIterator {
        private final String cursorMark;

        public SolrDocumentListCursor(SolrDocumentList solrDocumentList, String cursorMark) {
            super(solrDocumentList);
            this.cursorMark = cursorMark;
        }

        @Override
        protected void passNextPage(SolrQuery solrQuery) {
            String timeoutAsString = SolrEntityProcessor.this.context.getResolvedEntityAttribute(SolrEntityProcessor.TIMEOUT);
            if (timeoutAsString != null) {
                throw new DataImportHandlerException(500, "cursorMark can't be used with timeout");
            }
            solrQuery.set("cursorMark", new String[]{this.cursorMark});
        }

        @Override
        protected Iterator<Map<String, Object>> createNextPageIterator(QueryResponse response) {
            return new SolrDocumentListCursor(response.getResults(), response.getNextCursorMark());
        }
    }
}

