/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataSource
extends DataSource<Iterator<Map<String, Object>>> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDataSource.class);
    protected Callable<Connection> factory;
    private long connLastUsed = 0L;
    private Connection conn;
    private Map<String, Integer> fieldNameVsType = new HashMap<String, Integer>();
    private boolean convertType = false;
    private int batchSize = 500;
    private int maxRows = 0;
    private boolean isClosed = false;
    private static final long CONN_TIME_OUT = 10000L;
    private static final int FETCH_SIZE = 500;
    public static final String URL = "url";
    public static final String JNDI_NAME = "jndiName";
    public static final String DRIVER = "driver";
    public static final String CONVERT_TYPE = "convertType";

    @Override
    public void init(Context context, Properties initProps) {
        Object o = initProps.get(CONVERT_TYPE);
        if (o != null) {
            this.convertType = Boolean.parseBoolean(o.toString());
        }
        this.factory = this.createConnectionFactory(context, initProps);
        String bsz = initProps.getProperty("batchSize");
        if (bsz != null) {
            bsz = context.replaceTokens(bsz);
            try {
                this.batchSize = Integer.parseInt(bsz);
                if (this.batchSize == -1) {
                    this.batchSize = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid batch size: " + bsz);
            }
        }
        for (Map<String, String> map : context.getAllEntityFields()) {
            String n = map.get("column");
            String t = map.get("type");
            if ("sint".equals(t) || "integer".equals(t)) {
                this.fieldNameVsType.put(n, 4);
                continue;
            }
            if ("slong".equals(t) || "long".equals(t)) {
                this.fieldNameVsType.put(n, -5);
                continue;
            }
            if ("float".equals(t) || "sfloat".equals(t)) {
                this.fieldNameVsType.put(n, 6);
                continue;
            }
            if ("double".equals(t) || "sdouble".equals(t)) {
                this.fieldNameVsType.put(n, 8);
                continue;
            }
            if ("date".equals(t)) {
                this.fieldNameVsType.put(n, 91);
                continue;
            }
            if ("boolean".equals(t)) {
                this.fieldNameVsType.put(n, 16);
                continue;
            }
            if ("binary".equals(t)) {
                this.fieldNameVsType.put(n, 2004);
                continue;
            }
            this.fieldNameVsType.put(n, 12);
        }
    }

    protected Callable<Connection> createConnectionFactory(final Context context, final Properties initProps) {
        String s;
        this.resolveVariables(context, initProps);
        final String jndiName = initProps.getProperty(JNDI_NAME);
        final String url = initProps.getProperty(URL);
        final String driver = initProps.getProperty(DRIVER);
        if (url == null && jndiName == null) {
            throw new DataImportHandlerException(500, "JDBC URL or JNDI name has to be specified");
        }
        if (driver != null) {
            try {
                DocBuilder.loadClass(driver, context.getSolrCore());
            }
            catch (ClassNotFoundException e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Could not load driver: " + driver);
            }
        } else if (jndiName == null) {
            throw new DataImportHandlerException(500, "One of driver or jndiName must be specified in the data source");
        }
        if ((s = initProps.getProperty("maxRows")) != null) {
            this.maxRows = Integer.parseInt(s);
        }
        this.factory = new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                LOG.info("Creating a connection for entity " + context.getEntityAttribute("name") + " with URL: " + url);
                long start = System.currentTimeMillis();
                Connection c = null;
                if (jndiName != null) {
                    c = this.getFromJndi(initProps, jndiName);
                } else if (url != null) {
                    try {
                        c = DriverManager.getConnection(url, initProps);
                    }
                    catch (SQLException e) {
                        Driver d = (Driver)DocBuilder.loadClass(driver, context.getSolrCore()).newInstance();
                        c = d.connect(url, initProps);
                    }
                }
                if (c != null) {
                    try {
                        this.initializeConnection(c, initProps);
                    }
                    catch (SQLException e) {
                        try {
                            c.close();
                        }
                        catch (SQLException e2) {
                            LOG.warn("Exception closing connection during cleanup", (Throwable)e2);
                        }
                        throw new DataImportHandlerException(500, "Exception initializing SQL connection", e);
                    }
                }
                LOG.info("Time taken for getConnection(): " + (System.currentTimeMillis() - start));
                return c;
            }

            private void initializeConnection(Connection c, Properties initProps2) throws SQLException {
                String transactionIsolation;
                if (Boolean.parseBoolean(initProps2.getProperty("readOnly"))) {
                    c.setReadOnly(true);
                    c.setAutoCommit(true);
                    c.setTransactionIsolation(1);
                    c.setHoldability(2);
                }
                if (!Boolean.parseBoolean(initProps2.getProperty("autoCommit"))) {
                    c.setAutoCommit(false);
                }
                if ("TRANSACTION_READ_UNCOMMITTED".equals(transactionIsolation = initProps2.getProperty("transactionIsolation"))) {
                    c.setTransactionIsolation(1);
                } else if ("TRANSACTION_READ_COMMITTED".equals(transactionIsolation)) {
                    c.setTransactionIsolation(2);
                } else if ("TRANSACTION_REPEATABLE_READ".equals(transactionIsolation)) {
                    c.setTransactionIsolation(4);
                } else if ("TRANSACTION_SERIALIZABLE".equals(transactionIsolation)) {
                    c.setTransactionIsolation(8);
                } else if ("TRANSACTION_NONE".equals(transactionIsolation)) {
                    c.setTransactionIsolation(0);
                }
                String holdability = initProps2.getProperty("holdability");
                if ("CLOSE_CURSORS_AT_COMMIT".equals(holdability)) {
                    c.setHoldability(2);
                } else if ("HOLD_CURSORS_OVER_COMMIT".equals(holdability)) {
                    c.setHoldability(1);
                }
            }

            private Connection getFromJndi(Properties initProps2, String jndiName2) throws NamingException, SQLException {
                Connection c = null;
                InitialContext ctx = new InitialContext();
                Object jndival = ctx.lookup(jndiName2);
                if (jndival instanceof javax.sql.DataSource) {
                    javax.sql.DataSource dataSource = (javax.sql.DataSource)jndival;
                    String user = (String)initProps2.get("user");
                    String pass = (String)initProps2.get("password");
                    c = user == null || user.trim().equals("") ? dataSource.getConnection() : dataSource.getConnection(user, pass);
                } else {
                    throw new DataImportHandlerException(500, "the jndi name : '" + jndiName2 + "' is not a valid javax.sql.DataSource");
                }
                return c;
            }
        };
        return this.factory;
    }

    private void resolveVariables(Context ctx, Properties initProps) {
        for (Map.Entry<Object, Object> entry : initProps.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.setValue(ctx.replaceTokens((String)entry.getValue()));
        }
    }

    @Override
    public Iterator<Map<String, Object>> getData(String query) {
        ResultSetIterator r = new ResultSetIterator(query);
        return r.getIterator();
    }

    private void logError(String msg, Exception e) {
        LOG.warn(msg, (Throwable)e);
    }

    private List<String> readFieldNames(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> colNames = new ArrayList<String>();
        int count = metaData.getColumnCount();
        for (int i = 0; i < count; ++i) {
            colNames.add(metaData.getColumnLabel(i + 1));
        }
        return colNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws Exception {
        long currTime = System.currentTimeMillis();
        if (currTime - this.connLastUsed > 10000L) {
            JdbcDataSource jdbcDataSource = this;
            synchronized (jdbcDataSource) {
                Connection tmpConn = this.factory.call();
                this.closeConnection();
                this.connLastUsed = System.currentTimeMillis();
                this.conn = tmpConn;
                return this.conn;
            }
        }
        this.connLastUsed = currTime;
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                LOG.error("JdbcDataSource was not closed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.closeConnection();
        }
        finally {
            this.isClosed = true;
        }
    }

    private void closeConnection() {
        block4: {
            try {
                if (this.conn == null) break block4;
                try {
                    this.conn.commit();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.conn.close();
            }
            catch (Exception e) {
                LOG.error("Ignoring Error when closing connection", (Throwable)e);
            }
        }
    }

    private class ResultSetIterator {
        ResultSet resultSet;
        Statement stmt = null;
        List<String> colNames;
        Iterator<Map<String, Object>> rSetIterator;

        public ResultSetIterator(String query) {
            try {
                Connection c = JdbcDataSource.this.getConnection();
                this.stmt = c.createStatement(1003, 1007);
                this.stmt.setFetchSize(JdbcDataSource.this.batchSize);
                this.stmt.setMaxRows(JdbcDataSource.this.maxRows);
                LOG.debug("Executing SQL: " + query);
                long start = System.currentTimeMillis();
                if (this.stmt.execute(query)) {
                    this.resultSet = this.stmt.getResultSet();
                }
                LOG.trace("Time taken for sql :" + (System.currentTimeMillis() - start));
                this.colNames = JdbcDataSource.this.readFieldNames(this.resultSet.getMetaData());
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to execute query: " + query);
            }
            if (this.resultSet == null) {
                this.rSetIterator = new ArrayList().iterator();
                return;
            }
            this.rSetIterator = new Iterator<Map<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return ResultSetIterator.this.hasnext();
                }

                @Override
                public Map<String, Object> next() {
                    return ResultSetIterator.this.getARow();
                }

                @Override
                public void remove() {
                }
            };
        }

        private Iterator<Map<String, Object>> getIterator() {
            return this.rSetIterator;
        }

        private Map<String, Object> getARow() {
            if (this.resultSet == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String colName : this.colNames) {
                try {
                    if (!JdbcDataSource.this.convertType) {
                        result.put(colName, this.resultSet.getObject(colName));
                        continue;
                    }
                    Integer type = (Integer)JdbcDataSource.this.fieldNameVsType.get(colName);
                    if (type == null) {
                        type = 12;
                    }
                    switch (type) {
                        case 4: {
                            result.put(colName, this.resultSet.getInt(colName));
                            break;
                        }
                        case 6: {
                            result.put(colName, Float.valueOf(this.resultSet.getFloat(colName)));
                            break;
                        }
                        case -5: {
                            result.put(colName, this.resultSet.getLong(colName));
                            break;
                        }
                        case 8: {
                            result.put(colName, this.resultSet.getDouble(colName));
                            break;
                        }
                        case 91: {
                            result.put(colName, this.resultSet.getTimestamp(colName));
                            break;
                        }
                        case 16: {
                            result.put(colName, this.resultSet.getBoolean(colName));
                            break;
                        }
                        case 2004: {
                            result.put(colName, this.resultSet.getBytes(colName));
                            break;
                        }
                        default: {
                            result.put(colName, this.resultSet.getString(colName));
                            break;
                        }
                    }
                }
                catch (SQLException e) {
                    JdbcDataSource.this.logError("Error reading data ", e);
                    DataImportHandlerException.wrapAndThrow(500, e, "Error reading data from database");
                }
            }
            return result;
        }

        private boolean hasnext() {
            if (this.resultSet == null) {
                return false;
            }
            try {
                if (this.resultSet.next()) {
                    return true;
                }
                this.close();
                return false;
            }
            catch (SQLException e) {
                this.close();
                DataImportHandlerException.wrapAndThrow(500, e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception e) {
                JdbcDataSource.this.logError("Exception while closing result set", e);
            }
            finally {
                this.resultSet = null;
                this.stmt = null;
            }
        }
    }
}

