/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.SchemaInfoResponse;
import org.apache.solr.client.api.model.SchemaNameResponse;
import org.apache.solr.client.api.model.SchemaSimilarityResponse;
import org.apache.solr.client.api.model.SchemaUniqueKeyResponse;
import org.apache.solr.client.api.model.SchemaVersionResponse;
import org.apache.solr.client.api.model.SchemaZkVersionResponse;
import org.apache.solr.client.api.util.StoreApiParameters;

@Path(value="/{indexType:cores|collections}/{indexName}/schema")
public interface GetSchemaApi {
    @GET
    @StoreApiParameters
    @Operation(summary="Fetch the entire schema of the specified core or collection", tags={"schema"})
    public SchemaInfoResponse getSchemaInfo();

    @GET
    @Path(value="/name")
    @StoreApiParameters
    @Operation(summary="Get the name of the schema used by the specified core or collection", tags={"schema"})
    public SchemaNameResponse getSchemaName() throws Exception;

    @GET
    @Path(value="/similarity")
    @StoreApiParameters
    @Operation(summary="Get the default similarity configuration used by the specified core or collection", tags={"schema"})
    public SchemaSimilarityResponse getSchemaSimilarity();

    @GET
    @Path(value="/uniquekey")
    @StoreApiParameters
    @Operation(summary="Fetch the uniquekey of the specified core or collection", tags={"schema"})
    public SchemaUniqueKeyResponse getSchemaUniqueKey();

    @GET
    @Path(value="/version")
    @StoreApiParameters
    @Operation(summary="Fetch the schema version currently used by the specified core or collection", tags={"schema"})
    public SchemaVersionResponse getSchemaVersion();

    @GET
    @Path(value="/zkversion")
    @StoreApiParameters
    @Operation(summary="Fetch the schema version currently used by the specified core or collection", tags={"schema"})
    public SchemaZkVersionResponse getSchemaZkVersion(@DefaultValue(value="-1") @QueryParam(value="refreshIfBelowVersion") Integer var1) throws Exception;
}

