/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.apache.solr.client.api.model.SchemaChange;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UpsertDynamicFieldOperation;
import org.apache.solr.client.api.model.UpsertFieldOperation;
import org.apache.solr.client.api.model.UpsertFieldTypeOperation;
import org.apache.solr.client.api.util.StoreApiParameters;

@Path(value="/{indexType:cores|collections}/{indexName}/schema")
public interface UpdateSchemaApi {
    @PUT
    @Path(value="/fields/{fieldName}")
    @StoreApiParameters
    @Operation(summary="Add a standard (i.e. non-dynamic) field with the specified name.", tags={"schema"})
    public SolrJerseyResponse addField(@PathParam(value="fieldName") String var1, @RequestBody(extensions={@Extension(properties={@ExtensionProperty(name="hasAdditionalFields", value="true")})}) UpsertFieldOperation var2) throws Exception;

    @DELETE
    @Path(value="/fields/{fieldName}")
    @StoreApiParameters
    @Operation(summary="Remove the non-dynamic field with the specified name.", tags={"schema"})
    public SolrJerseyResponse deleteField(@PathParam(value="fieldName") String var1) throws Exception;

    @PUT
    @Path(value="/dynamicfields/{dynamicFieldName}")
    @StoreApiParameters
    @Operation(summary="Create a new dynamic field with the specified name.", tags={"schema"})
    public SolrJerseyResponse addDynamicField(@PathParam(value="dynamicFieldName") String var1, @RequestBody(extensions={@Extension(properties={@ExtensionProperty(name="hasAdditionalFields", value="true")})}) UpsertDynamicFieldOperation var2) throws Exception;

    @DELETE
    @Path(value="/dynamicfields/{dynamicFieldName}")
    @StoreApiParameters
    @Operation(summary="Remove the dynamic field with the specified name.", tags={"schema"})
    public SolrJerseyResponse deleteDynamicField(@PathParam(value="dynamicFieldName") String var1) throws Exception;

    @PUT
    @Path(value="/fieldtypes/{fieldTypeName}")
    @StoreApiParameters
    @Operation(summary="Add a new field-type with the specified name.", tags={"schema"})
    public SolrJerseyResponse addFieldType(@PathParam(value="fieldTypeName") String var1, @RequestBody(extensions={@Extension(properties={@ExtensionProperty(name="hasAdditionalFields", value="true")})}) UpsertFieldTypeOperation var2) throws Exception;

    @DELETE
    @Path(value="/fieldtypes/{fieldTypeName}")
    @StoreApiParameters
    @Operation(summary="Remove the field type with the specified name.", tags={"schema"})
    public SolrJerseyResponse deleteFieldType(@PathParam(value="fieldTypeName") String var1) throws Exception;

    @POST
    @Path(value="/bulk")
    @StoreApiParameters
    @Operation(summary="Perform the specified schema modifications.", tags={"schema"})
    public SolrJerseyResponse bulkSchemaModification(List<SchemaChange> var1) throws Exception;
}

