/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.util;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableTypeException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.apache.jackrabbit.util.Text;

public final class UserUtil
implements UserConstants {
    private UserUtil() {
    }

    public static boolean isAdmin(@Nonnull ConfigurationParameters parameters, @Nonnull String userId) {
        return UserUtil.getAdminId(parameters).equals(userId);
    }

    @Nonnull
    public static String getAdminId(@Nonnull ConfigurationParameters parameters) {
        return parameters.getConfigValue("adminId", "admin");
    }

    @Nonnull
    public static String getAnonymousId(@Nonnull ConfigurationParameters parameters) {
        return parameters.getConfigValue("anonymousId", "anonymous");
    }

    public static boolean isType(@Nullable Tree authorizableTree, @Nonnull AuthorizableType type) {
        if (authorizableTree != null) {
            String ntName = TreeUtil.getPrimaryTypeName(authorizableTree);
            switch (type) {
                case GROUP: {
                    return "rep:Group".equals(ntName);
                }
                case USER: {
                    return "rep:User".equals(ntName) || "rep:SystemUser".equals(ntName);
                }
            }
            return "rep:User".equals(ntName) || "rep:Group".equals(ntName) || "rep:SystemUser".equals(ntName);
        }
        return false;
    }

    @CheckForNull
    public static AuthorizableType getType(@Nonnull Tree authorizableNode) {
        String ntName = TreeUtil.getPrimaryTypeName(authorizableNode);
        return UserUtil.getType(ntName);
    }

    @CheckForNull
    public static AuthorizableType getType(@CheckForNull String primaryTypeName) {
        if (primaryTypeName != null) {
            if ("rep:Group".equals(primaryTypeName)) {
                return AuthorizableType.GROUP;
            }
            if ("rep:User".equals(primaryTypeName)) {
                return AuthorizableType.USER;
            }
            if ("rep:SystemUser".equals(primaryTypeName)) {
                return AuthorizableType.USER;
            }
        }
        return null;
    }

    public static boolean isSystemUser(@Nullable Tree authorizableTree) {
        return authorizableTree != null && "rep:SystemUser".equals(TreeUtil.getPrimaryTypeName(authorizableTree));
    }

    @CheckForNull
    public static String getAuthorizableRootPath(@Nonnull ConfigurationParameters parameters, @Nullable AuthorizableType type) {
        String path = null;
        if (type != null) {
            switch (type) {
                case USER: {
                    path = parameters.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
                    break;
                }
                case GROUP: {
                    path = parameters.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
                    break;
                }
                default: {
                    path = parameters.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
                    String groupRoot = parameters.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
                    while (!Text.isDescendantOrEqual(path, groupRoot)) {
                        path = Text.getRelativeParent(path, 1);
                    }
                    break block0;
                }
            }
        }
        return path;
    }

    @CheckForNull
    public static String getAuthorizableId(@Nonnull Tree authorizableTree) {
        Preconditions.checkNotNull((Object)authorizableTree);
        if (UserUtil.isType(authorizableTree, AuthorizableType.AUTHORIZABLE)) {
            PropertyState idProp = authorizableTree.getProperty("rep:authorizableId");
            if (idProp != null) {
                return idProp.getValue(Type.STRING);
            }
            return Text.unescapeIllegalJcrChars(authorizableTree.getName());
        }
        return null;
    }

    @Nonnull
    public static String getAuthorizableId(@Nonnull Tree authorizableTree, @Nonnull AuthorizableType type) {
        Preconditions.checkArgument((boolean)UserUtil.isType(authorizableTree, type));
        PropertyState idProp = authorizableTree.getProperty("rep:authorizableId");
        if (idProp != null) {
            return idProp.getValue(Type.STRING);
        }
        return Text.unescapeIllegalJcrChars(authorizableTree.getName());
    }

    @CheckForNull
    public static <T extends Authorizable> T castAuthorizable(@Nullable Authorizable authorizable, Class<T> authorizableClass) throws AuthorizableTypeException {
        if (authorizable == null) {
            return null;
        }
        if (authorizableClass != null && authorizableClass.isInstance(authorizable)) {
            return (T)((Authorizable)authorizableClass.cast(authorizable));
        }
        throw new AuthorizableTypeException("Invalid authorizable type '" + (authorizableClass == null ? "null" : authorizableClass) + '\'');
    }

    public static int getImportBehavior(@Nonnull ConfigurationParameters config) {
        String importBehaviorStr = config.getConfigValue("importBehavior", "ignore");
        return ImportBehavior.valueFromString(importBehaviorStr);
    }
}

