/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.credentials;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;

public final class CompositeCredentialsSupport
implements CredentialsSupport {
    @Nonnull
    private final Supplier<Collection<CredentialsSupport>> credentialSupplier;

    private CompositeCredentialsSupport(@Nonnull Supplier<Collection<CredentialsSupport>> credentialSupplier) {
        this.credentialSupplier = credentialSupplier;
    }

    public static CredentialsSupport newInstance(@Nonnull Supplier<Collection<CredentialsSupport>> credentialSupplier) {
        return new CompositeCredentialsSupport(credentialSupplier);
    }

    @Override
    @Nonnull
    public Set<Class> getCredentialClasses() {
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        if (all.isEmpty()) {
            return ImmutableSet.of();
        }
        if (all.size() == 1) {
            return all.iterator().next().getCredentialClasses();
        }
        HashSet classes = Sets.newHashSet();
        for (CredentialsSupport c : all) {
            classes.addAll(c.getCredentialClasses());
        }
        return classes;
    }

    @Override
    @CheckForNull
    public String getUserId(@Nonnull Credentials credentials) {
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        for (CredentialsSupport c : all) {
            String userId = c.getUserId(credentials);
            if (userId == null) continue;
            return userId;
        }
        return null;
    }

    @Override
    @Nonnull
    public Map<String, ?> getAttributes(@Nonnull Credentials credentials) {
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        if (all.isEmpty()) {
            return ImmutableMap.of();
        }
        if (all.size() == 1) {
            return all.iterator().next().getAttributes(credentials);
        }
        HashMap attrs = Maps.newHashMap();
        for (CredentialsSupport c : all) {
            attrs.putAll(c.getAttributes(credentials));
        }
        return attrs;
    }

    @Override
    public boolean setAttributes(@Nonnull Credentials credentials, @Nonnull Map<String, ?> attributes) {
        boolean set = false;
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        for (CredentialsSupport c : all) {
            set = c.setAttributes(credentials, attributes) || set;
        }
        return set;
    }
}

