/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class CompositeHook
implements CommitHook {
    private final Collection<CommitHook> hooks;

    public static CommitHook compose(@Nonnull Collection<CommitHook> hooks) {
        switch (hooks.size()) {
            case 0: {
                return EmptyHook.INSTANCE;
            }
            case 1: {
                return hooks.iterator().next();
            }
        }
        return new CompositeHook(hooks);
    }

    private CompositeHook(@Nonnull Collection<CommitHook> hooks) {
        this.hooks = hooks;
    }

    public CompositeHook(CommitHook ... hooks) {
        this(Arrays.asList(hooks));
    }

    @Override
    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        NodeState newState = after;
        for (CommitHook hook : this.hooks) {
            newState = hook.processCommit(before, newState, info);
        }
        return newState;
    }
}

