/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.CoalesceImpl;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.ComparisonImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchImpl;
import org.apache.jackrabbit.oak.query.ast.InImpl;
import org.apache.jackrabbit.oak.query.ast.JoinImpl;
import org.apache.jackrabbit.oak.query.ast.LengthImpl;
import org.apache.jackrabbit.oak.query.ast.LowerCaseImpl;
import org.apache.jackrabbit.oak.query.ast.NativeFunctionImpl;
import org.apache.jackrabbit.oak.query.ast.NotImpl;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.SimilarImpl;
import org.apache.jackrabbit.oak.query.ast.SpellcheckImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.ast.SuggestImpl;
import org.apache.jackrabbit.oak.query.ast.UpperCaseImpl;

public abstract class AstVisitorBase
implements AstVisitor {
    @Override
    public boolean visit(AndImpl node) {
        for (ConstraintImpl constraint : node.getConstraints()) {
            constraint.accept(this);
        }
        return true;
    }

    @Override
    public boolean visit(ComparisonImpl node) {
        node.getOperand1().accept(this);
        node.getOperand2().accept(this);
        return true;
    }

    @Override
    public boolean visit(InImpl node) {
        node.getOperand1().accept(this);
        for (StaticOperandImpl s : node.getOperand2()) {
            s.accept(this);
        }
        return true;
    }

    @Override
    public boolean visit(FullTextSearchImpl node) {
        node.getFullTextSearchExpression().accept(this);
        return true;
    }

    @Override
    public boolean visit(NativeFunctionImpl node) {
        node.getNativeSearchExpression().accept(this);
        return true;
    }

    @Override
    public boolean visit(SimilarImpl node) {
        node.getPathExpression().accept(this);
        return true;
    }

    @Override
    public boolean visit(SpellcheckImpl node) {
        node.getExpression().accept(this);
        return true;
    }

    @Override
    public boolean visit(SuggestImpl node) {
        node.getExpression().accept(this);
        return true;
    }

    @Override
    public boolean visit(JoinImpl node) {
        node.getLeft().accept(this);
        node.getRight().accept(this);
        node.getJoinCondition().accept(this);
        return true;
    }

    @Override
    public boolean visit(LengthImpl node) {
        return node.getOperand().accept(this);
    }

    @Override
    public boolean visit(LowerCaseImpl node) {
        return node.getOperand().accept(this);
    }

    @Override
    public boolean visit(CoalesceImpl node) {
        node.getOperand1().accept(this);
        node.getOperand2().accept(this);
        return true;
    }

    @Override
    public boolean visit(NotImpl node) {
        return node.getConstraint().accept(this);
    }

    @Override
    public boolean visit(OrderingImpl node) {
        return node.getOperand().accept(this);
    }

    @Override
    public boolean visit(OrImpl node) {
        for (ConstraintImpl constraint : node.getConstraints()) {
            constraint.accept(this);
        }
        return true;
    }

    public void visit(QueryImpl query) {
        ColumnImpl[] columns;
        OrderingImpl[] orderings;
        query.getSource().accept(this);
        ConstraintImpl constraint = query.getConstraint();
        if (constraint != null) {
            constraint.accept(this);
        }
        if ((orderings = query.getOrderings()) != null) {
            for (OrderingImpl ordering : orderings) {
                ordering.accept(this);
            }
        }
        for (ColumnImpl column : columns = query.getColumns()) {
            column.accept(this);
        }
    }

    @Override
    public boolean visit(UpperCaseImpl node) {
        return node.getOperand().accept(this);
    }
}

