/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class UniversalFilter
implements EventFilter {
    private final NodeState beforeState;
    private final NodeState afterState;
    private final Selector selector;
    private final Predicate<NodeState> predicate;

    public UniversalFilter(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull Selector selector, @Nonnull Predicate<NodeState> predicate) {
        this.beforeState = (NodeState)Preconditions.checkNotNull((Object)before);
        this.afterState = (NodeState)Preconditions.checkNotNull((Object)after);
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
        this.selector = (Selector)Preconditions.checkNotNull((Object)selector);
    }

    @Nonnull
    public NodeState getBeforeState() {
        return this.beforeState;
    }

    @Nonnull
    public NodeState getAfterState() {
        return this.afterState;
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return this.predicate.apply((Object)this.selector.select(this, null, after));
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return this.predicate.apply((Object)this.selector.select(this, before, after));
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return this.predicate.apply((Object)this.selector.select(this, before, null));
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return this.predicate.apply((Object)this.selector.select(this, name, EmptyNodeState.MISSING_NODE, after));
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return this.predicate.apply((Object)this.selector.select(this, name, before, EmptyNodeState.MISSING_NODE));
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        return this.predicate.apply((Object)this.selector.select(this, name, EmptyNodeState.MISSING_NODE, moved));
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return this.predicate.apply((Object)this.selector.select(this, name, EmptyNodeState.MISSING_NODE, reordered));
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        return new UniversalFilter(this.beforeState.getChildNode(name), this.afterState.getChildNode(name), this.selector, this.predicate);
    }

    public static interface Selector {
        @Nonnull
        public NodeState select(@Nonnull UniversalFilter var1, @CheckForNull PropertyState var2, @CheckForNull PropertyState var3);

        @Nonnull
        public NodeState select(@Nonnull UniversalFilter var1, @Nonnull String var2, @Nonnull NodeState var3, @Nonnull NodeState var4);
    }
}

