/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={QueryIndexProvider.class})
public class OrderedPropertyIndexProvider
implements QueryIndexProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPropertyIndexProvider.class);
    private static int hits;
    private static int threshold;

    @Override
    public List<? extends QueryIndex> getQueryIndexes(NodeState nodeState) {
        if (this.getHits() % threshold == 0) {
            LOG.warn("Ordered Index has been deprecated since Oak 1.1.8. Please replace the index definition ({}) with Lucene Property index and remove the index providers from the repository. See docs at http://jackrabbit.apache.org/oak/docs");
        }
        return Lists.newArrayList();
    }

    private synchronized int getHits() {
        return hits++;
    }

    static void setThreshold(int t) {
        threshold = t;
    }

    static {
        threshold = 10000;
    }
}

