/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.atomic;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.atomic.AtomicCounterEditor;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"type=atomicCounter"}, service={EditorProvider.class})
public class AtomicCounterEditorProvider
implements EditorProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AtomicCounterEditorProvider.class);
    private AtomicReference<Clusterable> cluster = new AtomicReference();
    private volatile AtomicReference<NodeStore> store = new AtomicReference();
    private volatile AtomicReference<ScheduledExecutorService> scheduler = new AtomicReference();
    private volatile AtomicReference<Whiteboard> whiteboard = new AtomicReference();
    private final Supplier<Clusterable> clusterSupplier;
    private final Supplier<ScheduledExecutorService> schedulerSupplier;
    private final Supplier<NodeStore> storeSupplier;
    private final Supplier<Whiteboard> wbSupplier;

    public AtomicCounterEditorProvider() {
        this.clusterSupplier = new Supplier<Clusterable>(){

            public Clusterable get() {
                return (Clusterable)AtomicCounterEditorProvider.this.cluster.get();
            }
        };
        this.schedulerSupplier = new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return (ScheduledExecutorService)AtomicCounterEditorProvider.this.scheduler.get();
            }
        };
        this.storeSupplier = new Supplier<NodeStore>(){

            public NodeStore get() {
                return (NodeStore)AtomicCounterEditorProvider.this.store.get();
            }
        };
        this.wbSupplier = new Supplier<Whiteboard>(){

            public Whiteboard get() {
                return (Whiteboard)AtomicCounterEditorProvider.this.whiteboard.get();
            }
        };
    }

    public AtomicCounterEditorProvider(@Nullable Supplier<Clusterable> clusterInfo, @Nullable Supplier<ScheduledExecutorService> executor, @Nullable Supplier<NodeStore> store, @Nullable Supplier<Whiteboard> whiteboard) {
        this.clusterSupplier = clusterInfo;
        this.schedulerSupplier = executor;
        this.storeSupplier = store;
        this.wbSupplier = whiteboard;
    }

    private String getInstanceId() {
        Clusterable c = (Clusterable)this.clusterSupplier.get();
        if (c == null) {
            return null;
        }
        return c.getInstanceId();
    }

    private ScheduledExecutorService getScheduler() {
        return (ScheduledExecutorService)this.schedulerSupplier.get();
    }

    private NodeStore getStore() {
        return (NodeStore)this.storeSupplier.get();
    }

    private Whiteboard getBoard() {
        return (Whiteboard)this.wbSupplier.get();
    }

    @Activate
    public void activate(BundleContext context) {
        this.whiteboard.set(new OsgiWhiteboard(context));
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("atomic-counter-%d").build();
        this.scheduler.set(Executors.newScheduledThreadPool(10, tf));
    }

    @Deactivate
    public void deactivate() {
        ScheduledExecutorService ses = this.getScheduler();
        if (ses == null) {
            LOG.debug("No ScheduledExecutorService found");
        } else {
            LOG.debug("Shutting down ScheduledExecutorService");
            new ExecutorCloser(ses).close();
        }
    }

    @Reference(name="cluster", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void bindCluster(Clusterable store) {
        this.cluster.set(store);
    }

    protected void unbindCluster(Clusterable store) {
        this.cluster.compareAndSet(store, null);
    }

    @Reference(name="store", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void bindStore(NodeStore store) {
        this.store.set(store);
    }

    protected void unbindStore(NodeStore store) {
        this.store.compareAndSet(store, null);
    }

    @Override
    public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
        return new AtomicCounterEditor(builder, this.getInstanceId(), this.getScheduler(), this.getStore(), this.getBoard());
    }
}

