/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

public class PrincipalManagerDelegator
implements PrincipalManager {
    private final SessionDelegate delegate;
    private final PrincipalManager principalManager;

    public PrincipalManagerDelegator(SessionDelegate delegate, PrincipalManager principalManager) {
        this.principalManager = principalManager;
        this.delegate = delegate;
    }

    @Override
    public boolean hasPrincipal(final String principalName) {
        return this.delegate.safePerform(new SessionOperation<Boolean>("hasPrincipal"){

            @Override
            @Nonnull
            public Boolean perform() {
                return PrincipalManagerDelegator.this.principalManager.hasPrincipal(principalName);
            }
        });
    }

    @Override
    public Principal getPrincipal(final String principalName) {
        try {
            return this.delegate.performNullable(new SessionOperation<Principal>("getPrincipal"){

                @Override
                public Principal performNullable() {
                    return PrincipalManagerDelegator.this.principalManager.getPrincipal(principalName);
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unexpected exception thrown by operation 'getPrincipal'", e);
        }
    }

    @Override
    public PrincipalIterator findPrincipals(final String simpleFilter) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("findPrincipals"){

            @Override
            @Nonnull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.findPrincipals(simpleFilter);
            }
        });
    }

    @Override
    public PrincipalIterator findPrincipals(final String simpleFilter, final int searchType) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("findPrincipals"){

            @Override
            @Nonnull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.findPrincipals(simpleFilter, searchType);
            }
        });
    }

    @Override
    public PrincipalIterator getPrincipals(final int searchType) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("getPrincipals"){

            @Override
            @Nonnull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.getPrincipals(searchType);
            }
        });
    }

    @Override
    public PrincipalIterator getGroupMembership(final Principal principal) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("getGroupMembership"){

            @Override
            @Nonnull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.getGroupMembership(principal);
            }
        });
    }

    @Override
    public Principal getEveryone() {
        return this.delegate.safePerform(new SessionOperation<Principal>("getEveryone"){

            @Override
            @Nonnull
            public Principal perform() {
                return PrincipalManagerDelegator.this.principalManager.getEveryone();
            }
        });
    }
}

