/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import com.google.common.base.Charsets;
import java.util.UUID;
import javax.annotation.Nonnull;

public final class UUIDUtils {
    private UUIDUtils() {
    }

    @Nonnull
    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    @Nonnull
    public static String generateUUID(String hint) {
        UUID uuid = UUID.nameUUIDFromBytes(hint.getBytes(Charsets.UTF_8));
        return uuid.toString();
    }

    public static boolean isValidUUID(String uuid) {
        try {
            UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

