/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.testing.resourceresolver.MockResourceResolver;

public class MockValueMap
extends DeepReadModifiableValueMapDecorator
implements ModifiableValueMap {
    private final Resource resource;
    private final MockResourceResolver mockResourceResolver;

    public MockValueMap(Resource resource) {
        this(resource, new HashMap<String, Object>());
    }

    public MockValueMap(Resource resource, Map<String, Object> map) {
        super(resource, (ValueMap)new ValueMapDecorator(MockValueMap.convertForWriteAll(map)));
        this.resource = resource;
        this.mockResourceResolver = MockValueMap.getMockResourceResolver(resource);
    }

    private static MockResourceResolver getMockResourceResolver(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        if (resolver instanceof MockResourceResolver) {
            return (MockResourceResolver)resolver;
        }
        return null;
    }

    public <T> T get(String name, Class<T> type) {
        if (type == InputStream.class) {
            byte[] data = this.get(name, byte[].class);
            if (data != null) {
                return (T)new ByteArrayInputStream(data);
            }
            return null;
        }
        if (type == null) {
            return (T)super.get((Object)name);
        }
        return (T)super.get(name, type);
    }

    public Object put(String key, Object value) {
        this.markResourceAsChanged();
        return super.put(key, MockValueMap.convertForWrite(value));
    }

    public void putAll(Map<? extends String, ?> map) {
        this.markResourceAsChanged();
        super.putAll(MockValueMap.convertForWriteAll(map));
    }

    public Object remove(Object key) {
        this.markResourceAsChanged();
        return super.remove(key);
    }

    public void clear() {
        this.markResourceAsChanged();
        super.clear();
    }

    private static Object convertForWrite(Object value) {
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            value = calendar;
        } else if (value instanceof InputStream) {
            try {
                value = IOUtils.toByteArray((InputStream)((InputStream)value));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to convert input stream to byte array.");
            }
        }
        return value;
    }

    private static Map<String, Object> convertForWriteAll(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                newMap.put(entry.getKey(), MockValueMap.convertForWrite(entry.getValue()));
            }
        }
        return newMap;
    }

    private void markResourceAsChanged() {
        if (this.mockResourceResolver != null) {
            this.mockResourceResolver.addChanged(this.resource.getPath(), (Map<String, Object>)((Object)this));
        }
    }
}

