/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.expression.nodes;

import java.util.Collection;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.render.ObjectModel;

public enum BinaryOperator {
    AND{

        @Override
        public Object eval(Object left, Object right) {
            return ObjectModel.toBoolean((Object)left) ? right : left;
        }
    }
    ,
    OR{

        @Override
        public Object eval(Object left, Object right) {
            return ObjectModel.toBoolean((Object)left) ? left : right;
        }
    }
    ,
    CONCATENATE{

        @Override
        public Object eval(Object left, Object right) {
            return ObjectModel.toString((Object)left).concat(ObjectModel.toString((Object)right));
        }
    }
    ,
    LT{

        @Override
        public Object eval(Object left, Object right) {
            return 4.lt(left, right);
        }
    }
    ,
    LEQ{

        @Override
        public Object eval(Object left, Object right) {
            return 5.leq(left, right);
        }
    }
    ,
    GT{

        @Override
        public Object eval(Object left, Object right) {
            return !6.leq(left, right);
        }
    }
    ,
    GEQ{

        @Override
        public Object eval(Object left, Object right) {
            return !7.lt(left, right);
        }
    }
    ,
    EQ{

        @Override
        public Object eval(Object left, Object right) {
            return 8.eq(left, right);
        }
    }
    ,
    NEQ{

        @Override
        public Object eval(Object left, Object right) {
            return !9.eq(left, right);
        }
    }
    ,
    STRICT_EQ{

        @Override
        public Object eval(Object left, Object right) {
            return 10.strictEq(left, right);
        }
    }
    ,
    STRICT_NEQ{

        @Override
        public Object eval(Object left, Object right) {
            return !11.strictEq(left, right);
        }
    }
    ,
    ADD{

        @Override
        public Object eval(Object left, Object right) {
            return BinaryOperator.adjust(ObjectModel.toNumber((Object)left).doubleValue() + ObjectModel.toNumber((Object)right).doubleValue());
        }
    }
    ,
    SUB{

        @Override
        public Object eval(Object left, Object right) {
            return BinaryOperator.adjust(ObjectModel.toNumber((Object)left).doubleValue() - ObjectModel.toNumber((Object)right).doubleValue());
        }
    }
    ,
    MUL{

        @Override
        public Object eval(Object left, Object right) {
            return BinaryOperator.adjust(ObjectModel.toNumber((Object)left).doubleValue() * ObjectModel.toNumber((Object)right).doubleValue());
        }
    }
    ,
    DIV{

        @Override
        public Object eval(Object left, Object right) {
            return BinaryOperator.adjust(ObjectModel.toNumber((Object)left).doubleValue() / ObjectModel.toNumber((Object)right).doubleValue());
        }
    }
    ,
    I_DIV{

        @Override
        public Object eval(Object left, Object right) {
            return ObjectModel.toNumber((Object)left).intValue() / ObjectModel.toNumber((Object)right).intValue();
        }
    }
    ,
    REM{

        @Override
        public Object eval(Object left, Object right) {
            return BinaryOperator.adjust(ObjectModel.toNumber((Object)left).intValue() % ObjectModel.toNumber((Object)right).intValue());
        }
    }
    ,
    IN{

        @Override
        public Object eval(Object left, Object right) {
            return 18.inOp(left, right);
        }
    };


    public static boolean eq(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    public static boolean lt(Object left, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return ((Number)left).doubleValue() < ((Number)right).doubleValue();
        }
        throw new SightlyCompilerException("Operands are not of the same type: comparison is supported for Number types only.");
    }

    public static boolean leq(Object left, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
        }
        throw new SightlyCompilerException("Operands are not of the same type: comparison is supported for Number types only.");
    }

    public static boolean strictEq(Object left, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return ((Number)left).doubleValue() == ((Number)right).doubleValue();
        }
        if (left instanceof String && right instanceof String) {
            return left.equals(right);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return left.equals(right);
        }
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Enum && right instanceof String || left instanceof String && right instanceof Enum) {
            String constantName = left instanceof String ? (String)left : (String)right;
            Enum enumObject = left instanceof Enum ? (Enum)left : (Enum)right;
            try {
                Object enumComparisonObject = Enum.valueOf(enumObject.getClass(), constantName);
                return enumComparisonObject == enumObject;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (left == null || right == null) {
            Object notNull;
            Object object = notNull = left != null ? left : right;
            if (notNull instanceof String || notNull instanceof Boolean || notNull instanceof Number) {
                return false;
            }
        }
        throw new SightlyCompilerException("Operands are not of the same type: the equality operator can only be applied to String, Number and Boolean types.");
    }

    public static boolean inOp(Object left, Object right) {
        if (left instanceof String && right instanceof String) {
            String leftString = (String)left;
            String rightString = (String)right;
            return rightString.contains(leftString);
        }
        Collection rightElements = ObjectModel.toCollection((Object)right);
        for (Object element : rightElements) {
            if (!element.equals(left)) continue;
            return true;
        }
        return false;
    }

    private static Number adjust(double x) {
        if (Math.floor(x) == x) {
            return (int)x;
        }
        return x;
    }

    public abstract Object eval(Object var1, Object var2);
}

