/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import org.apache.sling.resourceresolver.impl.providers.ProviderContextImpl;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.tree.Pathable;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;

public class ResourceProviderHandler
implements Comparable<ResourceProviderHandler>,
Pathable {
    private volatile BundleContext bundleContext;
    private volatile ProviderContextImpl context = new ProviderContextImpl();
    private volatile ResourceProviderInfo info;
    private volatile ResourceProvider<Object> provider;
    private volatile boolean isUsed = false;

    public ResourceProviderHandler(BundleContext bc, ResourceProviderInfo info) {
        this.info = info;
        this.bundleContext = bc;
    }

    public ResourceProviderInfo getInfo() {
        return this.info;
    }

    public boolean activate() {
        if (this.provider == null) {
            this.provider = (ResourceProvider)this.bundleContext.getService(this.info.getServiceReference());
            if (this.provider != null) {
                this.provider.start((ProviderContext)this.context);
            }
            this.isUsed = false;
        }
        return this.provider != null;
    }

    public void deactivate() {
        if (this.provider != null) {
            this.provider.stop();
            this.provider = null;
            this.context.update(null, null);
            this.bundleContext.ungetService(this.info.getServiceReference());
        }
    }

    public void dispose() {
        this.info = null;
        this.bundleContext = null;
        this.context = null;
        this.isUsed = false;
    }

    public ResourceProvider<Object> getResourceProvider() {
        return this.provider;
    }

    public ResourceProvider<Object> useResourceProvider() {
        this.isUsed = true;
        return this.provider;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    @Override
    public int compareTo(ResourceProviderHandler o) {
        ResourceProviderInfo localInfo = this.info;
        ResourceProviderInfo otherInfo = o.info;
        if (localInfo == null) {
            if (otherInfo == null) {
                return 0;
            }
            return 1;
        }
        if (otherInfo == null) {
            return -1;
        }
        return localInfo.compareTo(otherInfo);
    }

    @Override
    public String getPath() {
        return this.getInfo().getPath();
    }

    public void update() {
        if (this.provider != null) {
            this.provider.update(3L);
        }
    }

    public ProviderContextImpl getProviderContext() {
        return this.context;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "# provider: " + this.provider + " ]";
    }
}

