/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.resourcemerger.impl.MergingResourceProvider;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker2;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;

public class CRUDMergingResourceProvider
extends MergingResourceProvider {
    public CRUDMergingResourceProvider(String mergeRootPath, MergedResourcePicker2 picker, boolean traverseHierarchie) {
        super(mergeRootPath, picker, false, traverseHierarchie);
    }

    private ExtendedResourceHolder getAllResources(ResourceResolver resolver, String path, String relativePath) {
        ExtendedResourceHolder holder = new ExtendedResourceHolder(ResourceUtil.getName((String)path));
        holder.count = 0;
        boolean isUnderlying = true;
        for (Resource rsrc : this.picker.pickResources(resolver, relativePath, null)) {
            boolean hidden;
            ++holder.count;
            holder.highestResourcePath = rsrc.getPath();
            if (isUnderlying) {
                isUnderlying = false;
                hidden = false;
            } else {
                Resource parent = rsrc.getParent();
                boolean bl = hidden = parent == null ? false : new MergingResourceProvider.ParentHidingHandler(parent, this.traverseHierarchie).isHidden(holder.name, true);
            }
            if (hidden) {
                holder.resources.clear();
                continue;
            }
            if (ResourceUtil.isNonExistingResource((Resource)rsrc)) continue;
            holder.resources.add(rsrc);
        }
        return holder;
    }

    public Resource create(ResolveContext<Void> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        ResourceResolver resolver = ctx.getResourceResolver();
        Resource mountResource = this.getResource(ctx, path, ResourceContext.EMPTY_CONTEXT, null);
        if (mountResource != null) {
            throw new PersistenceException("Resource at " + path + " already exists.", null, path, null);
        }
        String relativePath = this.getRelativePath(path);
        if (relativePath == null || relativePath.length() == 0) {
            throw new PersistenceException("Resource at " + path + " can't be created.", null, path, null);
        }
        ExtendedResourceHolder holder = this.getAllResources(resolver, path, relativePath);
        if (holder.count < 2) {
            throw new PersistenceException("Modifying is only supported with at least two potentially merged resources.", null, path, null);
        }
        if (holder.resources.size() == 0 || holder.resources.size() < holder.count && !holder.resources.get(holder.resources.size() - 1).getPath().equals(holder.highestResourcePath)) {
            String createPath = holder.highestResourcePath;
            Resource parentResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)ResourceUtil.getParent((String)createPath), (String)null, null, (boolean)false);
            resolver.create(parentResource, ResourceUtil.getName((String)createPath), properties);
        } else {
            Resource hidingResource = resolver.getResource(holder.highestResourcePath);
            if (hidingResource != null) {
                ModifiableValueMap mvm = (ModifiableValueMap)hidingResource.adaptTo(ModifiableValueMap.class);
                mvm.remove((Object)"sling:hideResource");
                mvm.putAll(properties);
            }
        }
        return this.getResource(ctx, path, ResourceContext.EMPTY_CONTEXT, null);
    }

    public void delete(ResolveContext<Void> ctx, Resource resource) throws PersistenceException {
        ResourceResolver resolver = ctx.getResourceResolver();
        String path = resource.getPath();
        String relativePath = this.getRelativePath(path);
        if (relativePath == null || relativePath.length() == 0) {
            throw new PersistenceException("Resource at " + path + " can't be deleted.", null, path, null);
        }
        ExtendedResourceHolder holder = this.getAllResources(resolver, path, relativePath);
        if (holder.count < 2) {
            throw new PersistenceException("Modifying is only supported with at least two potentially merged resources.", null, path, null);
        }
        if (holder.resources.size() == 1 && holder.resources.get(0).getPath().equals(holder.highestResourcePath)) {
            resolver.delete(holder.resources.get(0));
        } else {
            String createPath = holder.highestResourcePath;
            Resource parentResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)ResourceUtil.getParent((String)createPath), (String)null, null, (boolean)false);
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("sling:hideResource", Boolean.TRUE);
            resolver.create(parentResource, ResourceUtil.getName((String)createPath), properties);
        }
    }

    public void revert(ResolveContext<Void> ctx) {
    }

    public void commit(ResolveContext<Void> ctx) throws PersistenceException {
    }

    public boolean hasChanges(ResolveContext<Void> ctx) {
        return false;
    }

    private static final class ExtendedResourceHolder {
        public final String name;
        public final List<Resource> resources = new ArrayList<Resource>();
        public int count;
        public String highestResourcePath;

        public ExtendedResourceHolder(String n) {
            this.name = n;
        }
    }
}

