/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourcemerger.impl.CRUDMergingResourceProvider;
import org.apache.sling.resourcemerger.impl.MergingResourceProvider;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker2;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component
public class MergedResourcePickerWhiteboard
implements ServiceTrackerCustomizer {
    private ServiceTracker tracker;
    private BundleContext bundleContext;
    private final Map<Long, ServiceRegistration> serviceRegistrations = new ConcurrentHashMap<Long, ServiceRegistration>();

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.tracker = new ServiceTracker(bundleContext, bundleContext.createFilter("(|(objectClass=" + MergedResourcePicker.class.getName() + ")(objectClass=" + MergedResourcePicker2.class.getName() + "))"), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.tracker.close();
    }

    public Object addingService(ServiceReference reference) {
        Object pickerObj = this.bundleContext.getService(reference);
        if (pickerObj != null) {
            String mergeRoot = PropertiesUtil.toString((Object)reference.getProperty("merge.root"), null);
            if (mergeRoot != null) {
                MergedResourcePicker2 picker;
                boolean readOnly = PropertiesUtil.toBoolean((Object)reference.getProperty("merge.readOnly"), (boolean)true);
                boolean traverseParent = PropertiesUtil.toBoolean((Object)reference.getProperty("merge.traverseParent"), (boolean)false);
                if (pickerObj instanceof MergedResourcePicker2) {
                    picker = (MergedResourcePicker2)pickerObj;
                } else {
                    final MergedResourcePicker deprecatedPicker = (MergedResourcePicker)pickerObj;
                    picker = new MergedResourcePicker2(){

                        @Override
                        public List<Resource> pickResources(ResourceResolver resolver, String relativePath, Resource relatedResource) {
                            return deprecatedPicker.pickResources(resolver, relativePath);
                        }
                    };
                }
                MergingResourceProvider provider = readOnly ? new MergingResourceProvider(mergeRoot, picker, true, traverseParent) : new CRUDMergingResourceProvider(mergeRoot, picker, traverseParent);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("provider.name", readOnly ? "Merging" : "CRUDMerging");
                ((Dictionary)props).put("provider.root", mergeRoot);
                ((Dictionary)props).put("provider.modifiable", !readOnly);
                ((Dictionary)props).put("provider.authenticate", "no");
                Long key = (Long)reference.getProperty("service.id");
                ServiceRegistration reg = this.bundleContext.registerService(ResourceProvider.class.getName(), (Object)provider, props);
                this.serviceRegistrations.put(key, reg);
            }
            return pickerObj;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        Long key = (Long)reference.getProperty("service.id");
        ServiceRegistration reg = this.serviceRegistrations.get(key);
        if (reg != null) {
            reg.unregister();
            this.bundleContext.ungetService(reference);
        }
    }
}

