/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl.picker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourcemerger.impl.StubResource;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.resourcemerger.picker.overriding", label="Apache Sling Overriding Resource Picker", description="This resource picker delivers merged resources based on the resource type hierarchy.", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="merge.root", value={"/mnt/override"}, label="Root", description="Root path at which merged resources will be available."), @Property(name="merge.readOnly", boolValue={true}, label="Read Only", description="Specifies if the resources are read-only or can be modified.")})
public class OverridingResourcePicker
implements MergedResourcePicker {
    public static final String DEFAULT_ROOT = "/mnt/override";

    @Override
    public List<Resource> pickResources(ResourceResolver resolver, String relativePath) {
        String absPath = "/" + relativePath;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Object currentTarget = resolver.getResource(absPath);
        if (currentTarget == null) {
            currentTarget = new StubResource(resolver, absPath);
        }
        resources.add((Resource)currentTarget);
        while (currentTarget != null) {
            Resource inheritanceRootResource = this.findInheritanceRoot((Resource)currentTarget);
            if (inheritanceRootResource == null) {
                currentTarget = null;
                continue;
            }
            String relPath = currentTarget.getPath().substring(inheritanceRootResource.getPath().length());
            String superType = inheritanceRootResource.getResourceSuperType();
            if (superType == null) {
                currentTarget = null;
                continue;
            }
            String superTypeChildPath = superType + relPath;
            Resource superTypeResource = resolver.getResource(superTypeChildPath);
            if (superTypeResource != null) {
                resources.add(superTypeResource);
                currentTarget = superTypeResource;
                continue;
            }
            resources.add((Resource)new NonExistingResource(resolver, superTypeChildPath));
            currentTarget = null;
        }
        Collections.reverse(resources);
        return resources;
    }

    private Resource findInheritanceRoot(Resource target) {
        String superType = target.getResourceSuperType();
        if (superType != null) {
            return target;
        }
        Resource parent = target.getParent();
        if (parent == null) {
            return null;
        }
        return this.findInheritanceRoot(parent);
    }
}

