/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourcemerger.impl.CRUDMergedResource;
import org.apache.sling.resourcemerger.impl.MergedResource;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;

class MergingResourceProvider
implements ResourceProvider {
    protected final String mergeRootPath;
    protected final MergedResourcePicker picker;
    private final boolean readOnly;
    protected final boolean traverseHierarchie;

    MergingResourceProvider(String mergeRootPath, MergedResourcePicker picker, boolean readOnly, boolean traverseHierarchie) {
        this.mergeRootPath = mergeRootPath;
        this.picker = picker;
        this.readOnly = readOnly;
        this.traverseHierarchie = traverseHierarchie;
    }

    private Resource createMergedResource(ResourceResolver resolver, String relativePath, ResourceHolder holder) {
        int index = 0;
        while (index < holder.resources.size()) {
            Resource baseRes = holder.resources.get(index);
            ValueMap props = baseRes.getValueMap();
            holder.valueMaps.add(props);
            if (((Boolean)props.get("sling:hideResource", (Object)Boolean.FALSE)).booleanValue()) {
                for (int i = 0; i <= index; ++i) {
                    holder.resources.remove(0);
                }
                holder.valueMaps.clear();
                index = 0;
                continue;
            }
            ++index;
        }
        if (!holder.resources.isEmpty()) {
            if (this.readOnly) {
                return new MergedResource(resolver, this.mergeRootPath, relativePath, holder.resources, holder.valueMaps);
            }
            return new CRUDMergedResource(resolver, this.mergeRootPath, relativePath, holder.resources, holder.valueMaps, this.picker);
        }
        return null;
    }

    protected String getRelativePath(String path) {
        if (path.startsWith(this.mergeRootPath)) {
            if ((path = path.substring(this.mergeRootPath.length())).length() == 0) {
                return path;
            }
            if (path.charAt(0) == '/') {
                return path.substring(1);
            }
        }
        return null;
    }

    public Resource getResource(ResourceResolver resolver, String path) {
        String relativePath = this.getRelativePath(path);
        if (relativePath != null) {
            ResourceHolder holder = new ResourceHolder(ResourceUtil.getName((String)path));
            Iterator<Resource> resources = this.picker.pickResources(resolver, relativePath).iterator();
            if (!resources.hasNext()) {
                return null;
            }
            boolean isUnderlying = true;
            while (resources.hasNext()) {
                boolean hidden;
                Resource resource = resources.next();
                if (isUnderlying) {
                    hidden = false;
                    isUnderlying = false;
                } else {
                    Resource parent = resource.getParent();
                    boolean bl = hidden = parent == null ? false : new ParentHidingHandler(parent, this.traverseHierarchie).isHidden(holder.name);
                }
                if (hidden) {
                    holder.resources.clear();
                    continue;
                }
                if (ResourceUtil.isNonExistingResource((Resource)resource)) continue;
                holder.resources.add(resource);
            }
            return this.createMergedResource(resolver, relativePath, holder);
        }
        return null;
    }

    public Iterator<Resource> listChildren(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        String relativePath = this.getRelativePath(resource.getPath());
        if (relativePath != null) {
            ArrayList<ResourceHolder> candidates = new ArrayList<ResourceHolder>();
            Iterator<Resource> resources = this.picker.pickResources(resolver, relativePath).iterator();
            boolean isUnderlying = true;
            while (resources.hasNext()) {
                Resource parentResource = resources.next();
                ParentHidingHandler handler = !isUnderlying ? new ParentHidingHandler(parentResource, this.traverseHierarchie) : null;
                isUnderlying = false;
                for (Resource child : parentResource.getChildren()) {
                    String rsrcName = child.getName();
                    ResourceHolder holder = null;
                    for (ResourceHolder current : candidates) {
                        if (!current.name.equals(rsrcName)) continue;
                        holder = current;
                        break;
                    }
                    if (holder == null) {
                        holder = new ResourceHolder(rsrcName);
                        candidates.add(holder);
                    }
                    holder.resources.add(child);
                    int orderBeforeIndex = -1;
                    ValueMap vm = child.getValueMap();
                    String orderBefore = (String)vm.get("sling:orderBefore", String.class);
                    if (orderBefore != null && !orderBefore.equals(rsrcName)) {
                        for (int index = 0; index < candidates.size(); ++index) {
                            ResourceHolder current = (ResourceHolder)candidates.get(index);
                            if (!current.name.equals(orderBefore)) continue;
                            orderBeforeIndex = index;
                            break;
                        }
                    }
                    if (orderBeforeIndex <= -1) continue;
                    candidates.add(orderBeforeIndex, holder);
                    candidates.remove(candidates.size() - 1);
                }
                if (handler == null) continue;
                Iterator iter = candidates.iterator();
                while (iter.hasNext()) {
                    ResourceHolder holder = (ResourceHolder)iter.next();
                    if (!handler.isHidden(holder.name)) continue;
                    iter.remove();
                }
            }
            ArrayList<Resource> children = new ArrayList<Resource>();
            for (ResourceHolder holder : candidates) {
                Resource mergedResource = this.createMergedResource(resolver, relativePath.length() == 0 ? holder.name : relativePath + '/' + holder.name, holder);
                if (mergedResource == null) continue;
                children.add(mergedResource);
            }
            return children.iterator();
        }
        return null;
    }

    public Resource getResource(ResourceResolver resolver, HttpServletRequest request, String path) {
        return this.getResource(resolver, path);
    }

    protected static final class ResourceHolder {
        public final String name;
        public final List<Resource> resources = new ArrayList<Resource>();
        public final List<ValueMap> valueMaps = new ArrayList<ValueMap>();

        public ResourceHolder(String n) {
            this.name = n;
        }
    }

    protected static final class ParentHidingHandler {
        private List<ExcludeEntry> entries = new ArrayList<ExcludeEntry>();

        public ParentHidingHandler(Resource parent, boolean traverseParent) {
            ValueMap parentProps = parent.getValueMap();
            String[] childrenToHideArray = (String[])parentProps.get("sling:hideChildren", String[].class);
            if (childrenToHideArray != null) {
                for (String value : childrenToHideArray) {
                    ExcludeEntry entry = new ExcludeEntry(value);
                    this.entries.add(entry);
                }
            }
            if (parent != null) {
                String previousAncestorName = parent.getName();
                for (Resource ancestor = parent.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                    ValueMap ancestorProps = ancestor.getValueMap();
                    String[] ancestorChildrenToHideArray = (String[])ancestorProps.get("sling:hideChildren", String[].class);
                    if (ancestorChildrenToHideArray != null) {
                        for (String value : ancestorChildrenToHideArray) {
                            ExcludeEntry entry = new ExcludeEntry(value);
                            Boolean hides = this.hides(entry, previousAncestorName);
                            if (hides == null || !hides.booleanValue()) continue;
                            this.entries.add(new ExcludeEntry("*"));
                            break;
                        }
                    }
                    if (!traverseParent) break;
                    previousAncestorName = ancestor.getName();
                }
            }
        }

        public boolean isHidden(String name) {
            boolean hidden = false;
            if (this.entries != null) {
                for (ExcludeEntry entry : this.entries) {
                    Boolean result = this.hides(entry, name);
                    if (result == null) continue;
                    hidden = result;
                    break;
                }
            }
            return hidden;
        }

        private Boolean hides(ExcludeEntry entry, String name) {
            Boolean result = null;
            if (entry.name.equals("*") || entry.name.equals(name)) {
                result = !entry.exclude;
            }
            return result;
        }
    }

    protected static final class ExcludeEntry {
        public final String name;
        public final boolean exclude;

        public ExcludeEntry(String value) {
            if (value.startsWith("!!")) {
                this.name = value.substring(1);
                this.exclude = false;
            } else if (value.startsWith("!")) {
                this.name = value.substring(1);
                this.exclude = true;
            } else {
                this.name = value;
                this.exclude = false;
            }
        }
    }
}

