/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcebuilder.impl;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.resourcebuilder.api.ResourceBuilder;
import org.apache.sling.resourcebuilder.api.ResourceBuilderFactory;
import org.apache.sling.resourcebuilder.impl.ResourceBuilderImpl;

@Component
@Service(value={ResourceBuilderFactory.class})
public class ResourceBuilderFactoryService
implements ResourceBuilderFactory {
    @Reference
    private MimeTypeService mimeTypeService;

    @Override
    public ResourceBuilder forParent(Resource parent) {
        return new ResourceBuilderImpl(parent, this.mimeTypeService);
    }

    @Override
    public ResourceBuilder forResolver(ResourceResolver r) {
        Resource root = r.getResource("/");
        if (root == null) {
            throw new IllegalStateException("Cannot read root resource");
        }
        return this.forParent(root);
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

