/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import org.apache.sling.repoinit.parser.impl.WithPathOptions;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.apache.sling.repoinit.parser.operations.OperationWithPathOptions;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CreateUser
extends OperationWithPathOptions {
    private final String username;
    private final String passwordEncoding;
    private final String password;

    public CreateUser(String username, String passwordEncoding, String password) {
        this(username, passwordEncoding, password, null);
    }

    public CreateUser(String username, String passwordEncoding, String password, WithPathOptions wpopt) {
        super(wpopt);
        this.username = username;
        this.passwordEncoding = passwordEncoding;
        this.password = password;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitCreateUser(this);
    }

    @Override
    protected String getParametersDescription() {
        String forced;
        StringBuilder sb = new StringBuilder(this.username);
        String string = forced = this.isForcedPath() ? "forced " : "";
        if (this.getPath() != null) {
            sb.append(" with " + forced + "path ").append(this.getPath());
        }
        if (this.password != null) {
            if (this.passwordEncoding == null) {
                sb.append(" (with password)");
            } else {
                sb.append(" (with encoded password)");
            }
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        String path = this.getPath();
        if (path == null || path.isEmpty()) {
            return String.format("create user %s%s%n", this.username, this.getPwString());
        }
        String forced = this.isForcedPath() ? "forced " : "";
        return String.format("create user %s with %spath %s%s%n", this.username, forced, path, this.getPwString());
    }

    @NotNull
    private String getPwString() {
        if (this.password == null || this.password.isEmpty()) {
            return "";
        }
        String enc = this.passwordEncoding != null ? "{" + this.passwordEncoding + "} " : "";
        return String.format(" with password %s%s", enc, this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordEncoding() {
        return this.passwordEncoding;
    }
}

